/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.common.component.checkboxtree;

import com.neogls.prism.central.vaadin.common.component.ContextMenuEvent;
import com.vaadin.flow.component.AbstractCompositeField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.VaadinIcon;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;

public class CheckboxTreeItem<T>
extends AbstractCompositeField<Div, CheckboxTreeItem<T>, Boolean>
implements HasLabel {
    private final T item;
    private final ItemLabelGenerator<T> itemLabelGenerator;
    private final Div toggle;
    private final Checkbox checkbox;
    private final List<CheckboxTreeItem<T>> childrenCheckboxes = new LinkedList();
    private final Div childrenContainer = new Div();
    private boolean collapsed = true;

    CheckboxTreeItem(T item, ItemLabelGenerator<T> itemLabelGenerator, ComponentEventListener<ContextMenuEvent<?>> rightClickListener) {
        super((Object)false);
        this.item = item;
        this.itemLabelGenerator = itemLabelGenerator;
        this.toggle = this.createToggle();
        this.checkbox = this.createCheckBox(item);
        ((Div)this.getContent()).add(new Component[]{this.toggle, this.checkbox, this.childrenContainer});
        this.toggle.getStyle().set("visibility", "hidden");
        this.childrenContainer.getStyle().set("margin-left", "1.525em");
        this.childrenContainer.setVisible(false);
        ContextMenuEvent.addListener((Component)this.checkbox, arg_0 -> rightClickListener.onComponentEvent(arg_0));
    }

    public void addChildCheckbox(CheckboxTreeItem<T> checkbox) {
        this.toggle.getStyle().remove("visibility");
        this.childrenCheckboxes.add(checkbox);
        this.childrenContainer.add(new Component[]{checkbox});
    }

    private Div createToggle() {
        Div toggleDiv = new Div(new Component[]{VaadinIcon.ANGLE_RIGHT.create()});
        toggleDiv.addClassName("inline-block");
        toggleDiv.addClickListener((ComponentEventListener & Serializable)event -> {
            if (this.collapsed) {
                this.expand();
            } else {
                this.collapse();
            }
        });
        return toggleDiv;
    }

    private Checkbox createCheckBox(T item) {
        return new Checkbox(this.itemLabelGenerator.apply(item), (HasValue.ValueChangeListener & Serializable)event -> {
            if (!event.isFromClient()) {
                return;
            }
            this.setModelValue((Object)((Boolean)event.getValue()), true);
            if (((Boolean)event.getValue()).booleanValue()) {
                this.expand();
            } else {
                this.collapseRecursively();
            }
        });
    }

    public void expand() {
        if (!this.collapsed) {
            return;
        }
        this.childrenContainer.setVisible(true);
        this.toggle.removeAll();
        this.toggle.add(new Component[]{VaadinIcon.ANGLE_DOWN.create()});
        this.collapsed = false;
    }

    public void collapse() {
        if (this.collapsed) {
            return;
        }
        this.childrenContainer.setVisible(false);
        this.toggle.removeAll();
        this.toggle.add(new Component[]{VaadinIcon.ANGLE_RIGHT.create()});
        this.collapsed = true;
    }

    public void collapseRecursively() {
        this.childrenCheckboxes.forEach(CheckboxTreeItem::collapseRecursively);
        this.collapse();
    }

    public List<CheckboxTreeItem<T>> getChildrenCheckboxes() {
        return Collections.unmodifiableList(this.childrenCheckboxes);
    }

    protected void setPresentationValue(Boolean newPresentationValue) {
        this.checkbox.setValue((Object)newPresentationValue);
    }

    public String getLabel() {
        return this.checkbox.getLabel();
    }

    public void setLabel(String label) {
        this.checkbox.setLabel(label);
    }

    @Generated
    public T getItem() {
        return (T)this.item;
    }
}

