/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.common.component.checkboxtree;

import com.neogls.prism.central.vaadin.common.component.checkboxtree.CheckboxTree;
import com.neogls.prism.central.vaadin.common.component.checkboxtree.CheckboxTreeItem;
import com.vaadin.flow.component.AbstractCompositeField;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.function.ValueProvider;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;

public class CheckboxTree<K, T>
extends AbstractCompositeField<Div, CheckboxTree<K, T>, Set<T>> {
    private final HashMap<K, CheckboxTreeItem<T>> checkboxes = new HashMap();
    private final ValueProvider<T, K> itemIdProvider;
    private final ValueProvider<T, K> parentIdProvider;
    private final ItemLabelGenerator<T> itemLabelGenerator;

    public CheckboxTree(Collection<T> items, ValueProvider<T, K> itemIdProvider, ValueProvider<T, K> parentIdProvider, ItemLabelGenerator<T> itemLabelGenerator) {
        super(Set.of());
        this.itemIdProvider = itemIdProvider;
        this.parentIdProvider = parentIdProvider;
        this.itemLabelGenerator = itemLabelGenerator;
        for (T item : items) {
            CheckboxTreeItem checkbox = new CheckboxTreeItem(item, itemLabelGenerator, (ComponentEventListener & Serializable)event -> this.fireEvent((ComponentEvent)new RightClickEvent(this, event.isFromClient(), item)));
            checkbox.addValueChangeListener(arg_0 -> this.onItemValueChange(arg_0));
            this.checkboxes.put(itemIdProvider.apply(item), checkbox);
        }
        for (T item : items) {
            Object parentId = parentIdProvider.apply(item);
            CheckboxTreeItem checkbox = (CheckboxTreeItem)this.checkboxes.get(itemIdProvider.apply(item));
            if (parentId == null) {
                ((Div)this.getContent()).add(new Component[]{checkbox});
                continue;
            }
            ((CheckboxTreeItem)this.checkboxes.get(parentId)).addChildCheckbox(checkbox);
        }
    }

    private void onItemValueChange(AbstractField.ComponentValueChangeEvent<CheckboxTreeItem<T>, Boolean> event) {
        if (!event.isFromClient()) {
            return;
        }
        HashSet<Object> value = new HashSet<Object>((Collection)this.getValue());
        if (((Boolean)event.getValue()).booleanValue()) {
            CheckboxTreeItem checkbox = (CheckboxTreeItem)event.getSource();
            while (checkbox != null) {
                Object item = checkbox.getItem();
                value.add(item);
                checkbox.setValue((Object)true);
                checkbox = Optional.ofNullable(this.parentIdProvider.apply(item)).map(this.checkboxes::get).orElse(null);
            }
        } else {
            LinkedList<CheckboxTreeItem> queue = new LinkedList<CheckboxTreeItem>();
            queue.addLast((CheckboxTreeItem)event.getSource());
            while (!queue.isEmpty()) {
                CheckboxTreeItem checkbox = (CheckboxTreeItem)queue.pop();
                value.remove(checkbox.getItem());
                checkbox.setValue((Object)false);
                queue.addAll(checkbox.getChildrenCheckboxes());
            }
        }
        this.setModelValue(value, true);
    }

    public void expand(T item) {
        ((CheckboxTreeItem)this.checkboxes.get(this.itemIdProvider.apply(item))).expand();
    }

    public void collapse(T item) {
        ((CheckboxTreeItem)this.checkboxes.get(this.itemIdProvider.apply(item))).collapse();
    }

    public void collapseRecursively(T item) {
        ((CheckboxTreeItem)this.checkboxes.get(this.itemIdProvider.apply(item))).collapseRecursively();
    }

    public void updateItemLabels(@Nullable T item) {
        if (item != null) {
            ((CheckboxTreeItem)this.checkboxes.get(this.itemIdProvider.apply(item))).setLabel(this.itemLabelGenerator.apply(item));
        } else {
            for (CheckboxTreeItem checkbox : this.checkboxes.values()) {
                checkbox.setLabel(this.itemLabelGenerator.apply(checkbox.getItem()));
            }
        }
    }

    protected void setPresentationValue(Set<T> newPresentationValue) {
        for (CheckboxTreeItem checkbox : this.checkboxes.values()) {
            checkbox.clear();
            checkbox.collapse();
        }
        for (Object item : newPresentationValue) {
            CheckboxTreeItem checkbox = (CheckboxTreeItem)this.checkboxes.get(this.itemIdProvider.apply(item));
            checkbox.setValue((Object)true);
            checkbox.expand();
        }
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        for (CheckboxTreeItem checkbox : this.checkboxes.values()) {
            checkbox.setReadOnly(readOnly);
        }
    }

    public void addRightClickListener(ComponentEventListener<RightClickEvent<T>> listener) {
        this.addListener(RightClickEvent.class, listener);
    }
}

