/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.common.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.component.upload.receivers.MemoryBuffer;
import elemental.json.Json;
import elemental.json.JsonValue;
import java.io.Serializable;

@CssImport(value="./themes/prism-theme/components/uploader.css", themeFor="vaadin-upload")
public class Uploader
extends Upload {
    String defaultText = "entity-editor.upload";
    String changeText = "entity-editor.change";
    Button button = new Button();
    String defaultBackgroundColor = this.button.getStyle().get("background-color");
    MemoryBuffer memoryBuffer;

    public Uploader(MemoryBuffer memoryBuffer, String allowedExtensions, int maxSize) {
        super((Receiver)memoryBuffer);
        this.memoryBuffer = memoryBuffer;
        this.setAcceptedFileTypes(new String[]{allowedExtensions});
        this.setDefaultText();
        this.setDropAllowed(false);
        this.setMaxFileSize(maxSize);
        this.setUploadButton((Component)this.button);
        this.button.addClickListener((ComponentEventListener & Serializable)e -> this.setInvalid(Boolean.valueOf(false)));
    }

    public Uploader(MemoryBuffer memoryBuffer, String allowedExtensions, int maxSize, String text, Boolean setFullSize) {
        this(memoryBuffer, allowedExtensions, maxSize);
        this.defaultText = text;
        this.setDefaultText();
        if (setFullSize.booleanValue()) {
            this.setFullSize();
        }
    }

    public void setFullSize() {
        this.addClassName("large");
        this.button.setWidthFull();
    }

    public void setChangeText() {
        this.button.setText(this.getTranslation(this.changeText, new Object[0]));
    }

    public void setDefaultText() {
        this.button.setText(this.getTranslation(this.defaultText, new Object[0]));
    }

    public void setButtonVisible(Boolean b) {
        this.getUploadButton().setVisible(b.booleanValue());
    }

    public void setButtonEnabled(Boolean b) {
        this.button.setEnabled(b.booleanValue());
    }

    public void removeFiles() {
        this.getElement().setPropertyJson("files", (JsonValue)Json.createArray());
        this.setButtonEnabled(Boolean.valueOf(true));
    }

    public void setInvalid(Boolean isInvalid) {
        if (isInvalid.booleanValue()) {
            this.button.getStyle().set("transition-duration", "0.5s");
            this.button.getStyle().set("background-color", "pink");
        } else {
            this.button.getStyle().set("background-color", this.defaultBackgroundColor);
        }
    }
}

