/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.common.component;

import com.neogls.prism.central.vaadin.common.component.Table;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.grid.ItemDoubleClickEvent;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

@CssImport(value="./themes/prism-theme/components/table.css", themeFor="vaadin-grid")
public class Table<T>
extends Div {
    private boolean ordered = false;
    private final List<T> items = new ArrayList();
    private final Grid<T> grid = new Grid();
    private Consumer<T> onEdit = null;
    private Consumer<TableItemDeleteEvent> deleteListener = null;
    private Runnable deletedListener = null;

    public Table() {
        this(false);
        this.grid.getStyle().set("font-weight", "initial");
    }

    public Table(boolean selectable) {
        this.grid.setSelectionMode(selectable ? Grid.SelectionMode.SINGLE : Grid.SelectionMode.NONE);
        this.grid.addThemeVariants(new GridVariant[]{GridVariant.LUMO_WRAP_CELL_CONTENT});
        this.add(new Component[]{this.grid});
    }

    public Table<T> addColumn(ValueProvider<T, ?> valueProvider) {
        return this.addColumn(null, valueProvider);
    }

    public Table<T> addColumn(String name, ValueProvider<T, ?> valueProvider) {
        return this.addColumn(name, false, valueProvider, true, false);
    }

    public Table<T> addColumn(String name, boolean translated, ValueProvider<T, ?> valueProvider) {
        return this.addColumn(name, translated, valueProvider, true, false);
    }

    public Table<T> addColumn(ValueProvider<T, ?> valueProvider, boolean canGrow, boolean sortable) {
        return this.addColumn(null, false, valueProvider, canGrow, sortable);
    }

    public Table<T> addColumn(String name, boolean translated, ValueProvider<T, ?> valueProvider, boolean canGrow, boolean sortable) {
        Objects.requireNonNull(valueProvider);
        Grid.Column col = this.grid.addColumn(valueProvider).setSortable(sortable);
        if (!canGrow) {
            col.setAutoWidth(true).setFlexGrow(0);
        }
        if (name != null) {
            col.setHeader(translated ? name : this.getTranslation(name, new Object[0]));
        }
        return this;
    }

    public Table<T> addComponentColumn(ValueProvider<T, ? extends Component> valueProvider) {
        return this.addComponentColumn(valueProvider, true);
    }

    public Table<T> addComponentColumn(String name, ValueProvider<T, ? extends Component> valueProvider) {
        return this.addComponentColumn(name, false, valueProvider, true);
    }

    public Table<T> addComponentColumn(ValueProvider<T, ? extends Component> valueProvider, boolean canGrow) {
        return this.addComponentColumn(null, false, valueProvider, canGrow);
    }

    public Table<T> addComponentColumn(String name, boolean translated, ValueProvider<T, ? extends Component> valueProvider, boolean canGrow) {
        Objects.requireNonNull(valueProvider);
        Grid.Column col = this.grid.addComponentColumn((ValueProvider & Serializable)item -> {
            Component c = (Component)valueProvider.apply(item);
            if (!(c instanceof HasStyle)) {
                c = c == null ? new Div() : new Div(new Component[]{c});
            }
            c.setClassName("flex items-center");
            return c;
        });
        if (!canGrow) {
            col.setAutoWidth(true).setFlexGrow(0);
        }
        if (name != null) {
            col.setHeader(translated ? name : this.getTranslation(name, new Object[0]));
        }
        return this;
    }

    public Table<T> addSortControls() {
        if (this.ordered) {
            throw new IllegalStateException("Sort controls were already added to this table");
        }
        this.ordered = true;
        return this.addComponentColumn((ValueProvider & Serializable)t -> {
            Div div = new Div();
            int index = this.items.indexOf(t);
            Icon up = VaadinIcon.ARROW_UP.create();
            Icon down = VaadinIcon.ARROW_DOWN.create();
            if (index > 0) {
                up.addClickListener((ComponentEventListener & Serializable)event -> {
                    this.items.set(index, this.items.get(index - 1));
                    this.items.set(index - 1, t);
                    this.refreshGrid();
                });
            } else {
                up.getStyle().set("visibility", "hidden");
            }
            if (index < this.items.size() - 1) {
                down.addClickListener((ComponentEventListener & Serializable)event -> {
                    this.items.set(index, this.items.get(index + 1));
                    this.items.set(index + 1, t);
                    this.refreshGrid();
                });
            } else {
                down.getStyle().set("visibility", "hidden");
            }
            div.add(new Component[]{up, down});
            return div;
        }, false);
    }

    public Table<T> addEditControls() {
        return this.addComponentColumn((ValueProvider & Serializable)t -> {
            Icon icon = VaadinIcon.PENCIL.create();
            icon.addClickListener((ComponentEventListener & Serializable)event -> this.onEdit.accept(t));
            return icon;
        }, false);
    }

    public Table<T> addEditControls(ValueProvider<T, Boolean> b) {
        this.addComponentColumn((ValueProvider & Serializable)t -> {
            Icon icon = new Icon("");
            if (((Boolean)b.apply(t)).booleanValue()) {
                icon = VaadinIcon.PENCIL.create();
                icon.addClickListener((ComponentEventListener & Serializable)event -> this.onEdit.accept(t));
            }
            return icon;
        }, false);
        return this;
    }

    public Table<T> addDeleteControls() {
        return this.addDeleteControls(t -> true);
    }

    public Table<T> addDeleteControls(Predicate<T> canDelete) {
        Objects.requireNonNull(canDelete);
        return this.addComponentColumn((ValueProvider & Serializable)t -> {
            Icon icon = VaadinIcon.CLOSE_SMALL.create();
            if (canDelete.test(t)) {
                icon.addClickListener((ComponentEventListener & Serializable)event -> this.removeItem(t));
            } else {
                icon.getStyle().set("color", "var(--lumo-contrast-40pct)");
            }
            return icon;
        }, false);
    }

    public void addItem(T item) {
        if (!this.items.contains(item)) {
            this.items.add(item);
            this.refreshGrid();
        }
    }

    private void removeItem(T item) {
        TableItemDeleteEvent event = new TableItemDeleteEvent(this, item);
        if (this.deleteListener != null) {
            this.deleteListener.accept(event);
        }
        if (event.isCanceled) {
            return;
        }
        if (this.items.remove(item)) {
            this.refreshGrid();
        }
        if (this.deletedListener != null) {
            this.deletedListener.run();
        }
    }

    private void refreshGrid() {
        this.grid.setItems((Collection)this.items);
    }

    public List<T> getItems() {
        return this.items;
    }

    public void setItems(List<T> items) {
        this.items.clear();
        this.items.addAll(items);
        this.refreshGrid();
    }

    public T getSelectedItem() {
        Set selectedItems = this.grid.getSelectedItems();
        if (selectedItems.isEmpty()) {
            return null;
        }
        return (T)selectedItems.iterator().next();
    }

    public Table<T> setDeleteListener(Consumer<TableItemDeleteEvent> deleteListener) {
        this.deleteListener = deleteListener;
        return this;
    }

    public Table<T> setDeletedListener(Runnable deletedListener) {
        this.deletedListener = deletedListener;
        return this;
    }

    public Table<T> setEditConsumer(Consumer<T> onEdit) {
        this.onEdit = onEdit;
        return this;
    }

    public void addSelectionListener(SelectionListener<Grid<T>, T> listener) {
        this.grid.addSelectionListener(listener);
    }

    public void addItemDoubleClickListener(ComponentEventListener<ItemDoubleClickEvent<T>> listener) {
        this.grid.addItemDoubleClickListener(listener);
    }

    public Table<T> setHeaderSmall() {
        this.grid.getElement().setAttribute("header-size", "small");
        return this;
    }

    public Table<T> setSize(TableSize size) {
        if (size == null) {
            this.grid.getElement().removeAttribute("table-size");
        } else {
            this.grid.getElement().setAttribute("table-size", size.attr);
        }
        return this;
    }

    public void refresh() {
        this.grid.getDataProvider().refreshAll();
    }

    public void removeColumns() {
        this.grid.removeAllColumns();
    }
}

