/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.common.component;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import jakarta.annotation.Nonnull;
import java.util.List;

public class PrismPaginator<T>
extends Composite<Div> {
    private final Div container = new Div();
    private final Div controls = new Div();
    private final Span pageLabel = new Span();
    private List<? extends T> items;
    private Component[] components;
    private int currentPage = 0;
    private final ComponentRenderer<? extends Component, T> renderer;

    public PrismPaginator(ComponentRenderer<?, T> renderer) {
        this.renderer = renderer;
        Button buttonPrevious = new Button((Component)VaadinIcon.ANGLE_LEFT.create(), arg_0 -> this.onPreviousClick(arg_0));
        Button buttonNext = new Button((Component)VaadinIcon.ANGLE_RIGHT.create(), arg_0 -> this.onNextClick(arg_0));
        buttonPrevious.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        buttonNext.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        this.controls.add(new Component[]{buttonPrevious, this.pageLabel, buttonNext});
        ((Div)this.getContent()).add(new Component[]{this.container, this.controls});
        this.addClassName("prism-paginator");
        this.container.addClassName("paginator-container");
        this.controls.addClassName("paginator-controls");
        this.controls.setEnabled(false);
    }

    public void setItems(@Nonnull List<? extends T> items) {
        this.items = items;
        this.container.removeAll();
        this.components = new Component[items.size()];
        this.currentPage = -1;
        if (items.isEmpty()) {
            this.pageLabel.setText("0 / 0");
        } else {
            this.setPage(0);
        }
        this.controls.setEnabled(!items.isEmpty());
    }

    private void setPage(int newPage) {
        Component component;
        if (newPage < 0 || newPage >= this.items.size()) {
            throw new IndexOutOfBoundsException("Page out of bounds");
        }
        if (this.currentPage != -1) {
            this.components[this.currentPage].setVisible(false);
        }
        if ((component = this.components[newPage]) != null) {
            component.setVisible(true);
        } else {
            Component newComponent;
            this.components[newPage] = newComponent = this.renderer.createComponent(this.items.get(newPage));
            this.container.add(new Component[]{newComponent});
        }
        this.pageLabel.setText(newPage + 1 + " / " + this.items.size());
        this.currentPage = newPage;
    }

    private void onPreviousClick(ClickEvent<Button> event) {
        int newPage = this.currentPage - 1;
        if (newPage < 0) {
            newPage = this.items.size() - 1;
        }
        this.setPage(newPage);
    }

    private void onNextClick(ClickEvent<Button> event) {
        int newPage = this.currentPage + 1;
        if (newPage >= this.items.size()) {
            newPage = 0;
        }
        this.setPage(newPage);
    }
}

