/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.common.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.AnchorTarget;
import com.vaadin.flow.component.html.AnchorTargetValue;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.select.SelectVariant;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.shared.Tooltip;
import java.util.List;

public abstract class AbstractExportButton<T>
extends FlexLayout {
    private final Select<T> selectFormat = new Select();
    private final Anchor aDownload = new Anchor();
    private final Tooltip anchorTooltip = Tooltip.forComponent((Component)this.aDownload);

    protected AbstractExportButton(List<T> formats) {
        this.selectFormat.setItemLabelGenerator(arg_0 -> this.exportFormatToString(arg_0));
        this.selectFormat.addThemeVariants((ThemeVariant[])new SelectVariant[]{SelectVariant.LUMO_SMALL});
        Button bDownload = new Button((Component)VaadinIcon.DOWNLOAD_ALT.create());
        bDownload.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        this.aDownload.setTarget((AnchorTargetValue)AnchorTarget.BLANK);
        this.aDownload.add(new Component[]{bDownload});
        this.add(new Component[]{this.selectFormat, this.aDownload});
        this.addClassName("export-button");
        this.selectFormat.setItems(formats);
    }

    protected abstract String exportFormatToString(T var1);

    protected final void setFormatsInternal(List<T> formats) {
        if (formats.isEmpty()) {
            throw new IllegalArgumentException("Formats cannot be empty");
        }
        this.selectFormat.setItems(formats);
        this.selectFirstItem();
    }

    protected final void selectFirstItem() {
        this.selectFormat.getListDataView().getItems().findFirst().ifPresent(arg_0 -> ((Select)this.selectFormat).setValue(arg_0));
    }

    protected void addFormatValueChangeListener(HasValue.ValueChangeListener<HasValue.ValueChangeEvent<T>> listener) {
        this.selectFormat.addValueChangeListener(listener);
    }

    protected final void setHref(String href) {
        this.aDownload.setHref(href);
    }

    protected final void setAnchorEnabled(boolean enabled) {
        this.aDownload.setEnabled(enabled);
    }

    protected final void setAnchorTooltip(String tooltip) {
        this.anchorTooltip.setText(tooltip);
    }
}

