/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin;

import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.i18n.PrismI18NProvider;
import com.vaadin.flow.i18n.I18NProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PrismI18NProviderImpl
implements PrismI18NProvider,
I18NProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrismI18NProviderImpl.class);
    private final String i18nOverrideBundleName;
    private final URLClassLoader i18nOverrideClassLoader;
    private static final String BUNDLE_NAME = "com.geolocsystems.prismcentralvaadin.messages";
    private static final String I18N_OVERRIDE_FOLDER_CONFIG = "prism-central-vaadin.i18n-override-folder";
    private static final String I18N_OVERRIDE_BUNDLE_NAME_CONFIG = "prism-central-vaadin.i18n-override-bundle-name";
    private static final String I18N_OVERRIDE_FOLDER_CONFIG_DEFAULT = "config";
    private static final String I18N_OVERRIDE_BUNDLE_NAME_CONFIG_DEFAULT = "messages";
    private static final Locale SPANISH = new Locale("es");
    private static final Locale PORTUGUESE = new Locale("pt");
    private static final List<Locale> PROVIDED_LOCALES = List.of(Locale.FRENCH, Locale.ENGLISH, Locale.GERMAN, Locale.ITALIAN, SPANISH, PORTUGUESE);
    private static final Locale DEFAULT_LOCALE = PROVIDED_LOCALES.stream().filter(Locale.getDefault()::equals).findFirst().orElse((Locale)PROVIDED_LOCALES.stream().findFirst().orElseThrow());

    public PrismI18NProviderImpl(ConfigurationService configurationService) throws MalformedURLException {
        Path i18nOverrideFolderPath = Path.of(".", new String[0]).resolve(configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, I18N_OVERRIDE_FOLDER_CONFIG).orElse(I18N_OVERRIDE_FOLDER_CONFIG_DEFAULT));
        this.i18nOverrideBundleName = configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, I18N_OVERRIDE_BUNDLE_NAME_CONFIG).orElse(I18N_OVERRIDE_BUNDLE_NAME_CONFIG_DEFAULT);
        this.i18nOverrideClassLoader = new URLClassLoader(new URL[]{i18nOverrideFolderPath.toUri().toURL()});
    }

    private ResourceBundle getBundle(Locale locale) {
        try {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }
        catch (MissingResourceException e) {
            log.error("Missing bundle {} for locale {}", (Object)BUNDLE_NAME, (Object)locale);
            return null;
        }
    }

    private ResourceBundle getOverrideBundle(Locale locale) {
        try {
            return ResourceBundle.getBundle(this.i18nOverrideBundleName, locale, this.i18nOverrideClassLoader);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private String getTranslationBase(String key, Locale locale) {
        ResourceBundle bundle;
        ResourceBundle overrideBundle = this.getOverrideBundle(locale);
        if (overrideBundle != null) {
            try {
                return overrideBundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if ((bundle = this.getBundle(locale)) == null) {
            return null;
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            log.warn("Missing translation: {} (locale: {})", (Object)key, (Object)bundle.getLocale());
            return null;
        }
    }

    private String formatTranslation(String translation, Object ... params) {
        if (params.length == 0) {
            return translation;
        }
        return MessageFormat.format(translation, params);
    }

    public Locale getDefaultLocale() {
        return DEFAULT_LOCALE;
    }

    public List<Locale> getProvidedLocales() {
        return PROVIDED_LOCALES;
    }

    public Optional<String> findTranslation(String key, Locale locale, Object ... params) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(locale);
        Objects.requireNonNull(params);
        return Optional.ofNullable(this.getTranslationBase(key, locale)).map(translation -> this.formatTranslation(translation, params));
    }

    public Optional<String> findTranslation(String key, Object ... params) {
        return this.findTranslation(key, this.getDefaultLocale(), params);
    }

    public String getTranslation(String key, Locale locale, Object ... params) {
        return (String)((Object)this.findTranslation(key, locale, params).orElse("!{" + key + "}!"));
    }

    public String getTranslation(String key, Object ... params) {
        return this.getTranslation(key, this.getDefaultLocale(), params);
    }

    public boolean hasKey(String key, Locale locale) {
        return this.getTranslationBase(key, locale) != null;
    }

    public boolean hasKey(String key) {
        return this.hasKey(key, this.getDefaultLocale());
    }
}

