/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin;

import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.view.mct.patrol.MctPatrouillage;
import com.neogls.prism.central.vaadin.view.mct.tableaudebord.MctTableauDeBord;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.Route;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.security.PermitAll;
import java.util.Map;
import lombok.Generated;

@PermitAll
@Route(value="/", layout=PrismLayout.class)
public class MainView
extends VerticalLayout
implements BeforeEnterObserver {
    private final UserPermissionService userPermissionService;
    private static final Class<? extends Component> DEFAULT_VIEW = MctPatrouillage.class;
    private static final Map<String, Class<? extends Component>> VIEWS_BY_OLD_CLASSNAME = Map.of("com.geolocsystems.prismcentralvaadin.ui.mct.MctTableauDeBord", MctTableauDeBord.class);

    @PostConstruct
    private void init() {
        this.add(new Component[]{new Button("Test")});
    }

    public void beforeEnter(BeforeEnterEvent event) {
        String moduleAccueil = this.userPermissionService.getCurrentUser().getProfil().getModule_accueil();
        Class classByName = this.getClassByName(moduleAccueil);
        Class view = moduleAccueil == null ? DEFAULT_VIEW : (classByName != null ? classByName : VIEWS_BY_OLD_CLASSNAME.getOrDefault(moduleAccueil, DEFAULT_VIEW));
        event.forwardTo(view);
    }

    private Class<? extends Component> getClassByName(String className) {
        if (className == null) {
            return null;
        }
        try {
            return Class.forName(className).asSubclass(Component.class);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Generated
    public MainView(UserPermissionService userPermissionService) {
        this.userPermissionService = userPermissionService;
    }
}

