/*
 * Decompiled with CFR 0.152.
 */
package gls.wms;

import gls.outils.GLS;
import gls.wms.LayerInformation;
import gls.wms.RequestParameter;
import gls.wms.ServerInformation;
import java.awt.Image;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.imageio.ImageIO;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class WMSClient {
    private Logger logger = Logger.getLogger((String)"cartoj.WMS");
    private LayerInformation layerInformation;
    private Image imageLayer;

    public WMSClient(String nom, String urlMapserver, String mapfile, String layers) {
        ServerInformation serveurWMS = new ServerInformation();
        serveurWMS.setName(nom);
        serveurWMS.setGetMapURL(urlMapserver);
        serveurWMS.setGetMapFile(mapfile);
        this.layerInformation = new LayerInformation(serveurWMS);
        if (layers.contains(",")) {
            this.layerInformation.setField("layers", layers);
        } else {
            this.layerInformation.setField("layer", layers);
        }
    }

    public void getImage(RequestParameter requestParameter) {
        this.getImage(requestParameter, null);
    }

    public void getImage(RequestParameter requestParameter, String dirTmp) {
        try {
            float[] f = this.layerInformation.getLatLonBoundingBox();
            String s = new String(this.layerInformation.getServerInformation().getGetMapURL());
            if (this.layerInformation.getServerInformation().getGetMapFile() != null && !this.layerInformation.getServerInformation().getGetMapFile().equals("")) {
                s = String.valueOf(s) + "?MAP=" + this.layerInformation.getServerInformation().getGetMapFile();
            }
            String requestMethod = requestParameter.getRequestMethod() != null ? requestParameter.getRequestMethod() : "GetMap";
            StringBuffer url = new StringBuffer(s);
            url.append(s.indexOf("?") == -1 ? "?" : "&");
            url.append("REQUEST=" + requestMethod);
            url.append("&STYLES=");
            if (this.layerInformation.getField("layers") != null) {
                url.append("&LAYERS=" + this.layerInformation.getField("layers"));
            }
            if (this.layerInformation.getField("layer") != null) {
                if (!"GetMap".equals(requestMethod)) {
                    url.append("&LAYER=" + this.layerInformation.getField("layer"));
                } else {
                    url.append("&LAYERS=" + this.layerInformation.getField("layer"));
                }
            }
            if (requestParameter.getBoundingX1() != -1.0f) {
                url.append("&BBOX=" + new Float(requestParameter.getBoundingX1()).toString());
                url.append("," + new Float(requestParameter.getBoundingY1()).toString());
                url.append("," + new Float(requestParameter.getBoundingX2()).toString());
                url.append("," + new Float(requestParameter.getBoundingY2()).toString());
            }
            url.append("&SRS=" + requestParameter.getSRS());
            url.append("&TRANSPARENT=TRUE");
            url.append("&WIDTH=" + requestParameter.getPixelWidth() + "&HEIGHT=" + requestParameter.getPixelHeight());
            url.append("&FORMAT=" + requestParameter.getImageFormat());
            url.append("&VERSION=1.1");
            url.append("&SERVICE=WMS");
            url.append("&t=" + GLS.genererNumeroUnique());
            url.append("&" + requestParameter.getVariables());
            this.logger.debug((Object)url.toString());
            System.out.println(url.toString());
            if (this.layerInformation.getServerInformation().getGetMapURL().startsWith("https")) {
                File ff = !GLS.estVide(dirTmp) ? File.createTempFile(GLS.genererNumeroUnique("img_pat"), "png", new File(dirTmp)) : File.createTempFile(GLS.genererNumeroUnique("img_pat"), "png");
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("TLS");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                URL urlHttps = new URL(url.toString());
                URLConnection connection = urlHttps.openConnection();
                FileUtils.copyURLToFile((URL)connection.getURL(), (File)ff);
                this.imageLayer = ImageIO.read(ff);
                ff.delete();
            } else {
                this.imageLayer = ImageIO.read(new URL(url.toString()));
            }
        }
        catch (MalformedURLException mue) {
            this.logger.error((Object)"", (Throwable)mue);
            mue.printStackTrace();
        }
        catch (Exception e) {
            this.logger.error((Object)("Error loading layer '" + this.layerInformation.getField("name") + "': "), (Throwable)e);
            e.printStackTrace();
        }
    }

    public Image getImageLayer() {
        return this.imageLayer;
    }

    public void setImageLayer(Image imageLayer) {
        this.imageLayer = imageLayer;
    }
}

