/*
 * Decompiled with CFR 0.152.
 */
package gls.wms;

import commun.UnPoint;
import fr.geo.convert.Lambert93;
import fr.geo.convert.UTM;
import gls.wms.RequestParameter;
import gls.wms.RequestParameterImp;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class RequestParamaterFactory {
    public static RequestParameter getRequestParameter(String projection, int width, int height, Rectangle2D.Float aire) {
        if (projection.toLowerCase().equals("epsg:32630")) {
            return RequestParamaterFactory.getRequestParameterUTM(width, height, aire);
        }
        if (projection.toLowerCase().equals("epsg:2154")) {
            return RequestParamaterFactory.getRequestParameterLB93(width, height, aire);
        }
        return RequestParamaterFactory.getRequestParameter(width, height, aire);
    }

    public static RequestParameter getRequestParameter(int width, int height, Rectangle2D.Float aire) {
        RequestParameterImp requestParameter = new RequestParameterImp();
        requestParameter.setSrs("EPSG:4326");
        UnPoint p1 = new UnPoint(aire.x, aire.y).toLL(30, "N");
        UnPoint p2 = new UnPoint(aire.x, aire.y + aire.height).toLL(30, "N");
        UnPoint p3 = new UnPoint(aire.x + aire.width, aire.y).toLL(30, "N");
        UnPoint p4 = new UnPoint(aire.x + aire.width, aire.y + aire.height).toLL(30, "N");
        requestParameter.setBoundingbox(RequestParamaterFactory.minimum(p1.x, p2.x, p3.x, p4.x), RequestParamaterFactory.minimum(p1.y, p2.y, p3.y, p4.y), RequestParamaterFactory.maximum(p1.x, p2.x, p3.x, p4.x), RequestParamaterFactory.maximum(p1.y, p2.y, p3.y, p4.y));
        requestParameter.setImageFormat("image/png");
        requestParameter.setImageWidth(width);
        requestParameter.setImageHeight(height);
        return requestParameter;
    }

    public static RequestParameter getRequestParameterUTM(int width, int height, Rectangle2D.Float aire) {
        RequestParameterImp requestParameter = new RequestParameterImp();
        requestParameter.setSrs("EPSG:32630");
        requestParameter.setBoundingbox(aire.x, aire.y, aire.x + aire.width, aire.y + aire.height);
        requestParameter.setImageFormat("image/png");
        requestParameter.setImageWidth(width);
        requestParameter.setImageHeight(height);
        return requestParameter;
    }

    public static RequestParameter getRequestParameterLB93(int width, int height, Rectangle2D.Float aire) {
        RequestParameterImp requestParameter = new RequestParameterImp();
        requestParameter.setSrs("epsg:2154");
        UTM utm = new UTM(30, (double)aire.x, (double)aire.y, 0.0, true);
        Lambert93 l1 = (Lambert93)new Lambert93().create(utm.toWGS84());
        UTM utm2 = new UTM(30, (double)(aire.x + aire.width), (double)(aire.y + aire.height), 0.0, true);
        Lambert93 l2 = (Lambert93)new Lambert93().create(utm2.toWGS84());
        UTM utm3 = new UTM(30, (double)(aire.x + aire.width), (double)aire.y, 0.0, true);
        Lambert93 l3 = (Lambert93)new Lambert93().create(utm3.toWGS84());
        UTM utm4 = new UTM(30, (double)aire.x, (double)(aire.y + aire.height), 0.0, true);
        Lambert93 l4 = (Lambert93)new Lambert93().create(utm4.toWGS84());
        requestParameter.setBoundingbox(RequestParamaterFactory.minimum(l1.getX(), l2.getX(), l3.getX(), l4.getX()), RequestParamaterFactory.minimum(l1.getY(), l2.getY(), l3.getY(), l4.getY()), RequestParamaterFactory.maximum(l1.getX(), l2.getX(), l3.getX(), l4.getX()), RequestParamaterFactory.maximum(l1.getY(), l2.getY(), l3.getY(), l4.getY()));
        requestParameter.setImageFormat("image/png");
        requestParameter.setImageWidth(width);
        requestParameter.setImageHeight(height);
        return requestParameter;
    }

    private static float maximum(float x, float x2, float x3, float x4) {
        DecimalFormat format = new DecimalFormat();
        format.setMaximumFractionDigits(4);
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        format.setDecimalFormatSymbols(symbols);
        symbols.setGroupingSeparator('\u0000');
        format.setGroupingUsed(false);
        return new Float(format.format(Double.parseDouble(String.valueOf(Math.max(Math.max(Math.max(x, x2), x3), x4)).replace(',', '.')))).floatValue();
    }

    private static float maximum(double x, double x2, double x3, double x4) {
        return new Double(Math.max(Math.max(Math.max(x, x2), x3), x4)).intValue();
    }

    private static float minimum(float x, float x2, float x3, float x4) {
        DecimalFormat format = new DecimalFormat();
        format.setMaximumFractionDigits(4);
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        format.setDecimalFormatSymbols(symbols);
        symbols.setGroupingSeparator('\u0000');
        format.setGroupingUsed(false);
        return new Float(format.format(Double.parseDouble(String.valueOf(Math.min(Math.min(Math.min(x, x2), x3), x4)).replace(',', '.')))).floatValue();
    }

    private static float minimum(double x, double x2, double x3, double x4) {
        return new Double(Math.min(Math.min(Math.min(x, x2), x3), x4)).floatValue();
    }

    public static void main(String[] args) {
        UnPoint p1 = new UnPoint(4.66, 44.6).toNewUTM(30);
        UnPoint p2 = new UnPoint(6.44, 46.0).toNewUTM(30);
        UnPoint p3 = new UnPoint(6.44, 44.6).toNewUTM(30);
        UnPoint p4 = new UnPoint(4.66, 46.0).toNewUTM(30);
        System.out.println(String.valueOf(RequestParamaterFactory.minimum(p1.x, p2.x, p3.x, p4.x)) + " " + RequestParamaterFactory.minimum(p1.y, p2.y, p3.y, p4.y) + " " + RequestParamaterFactory.maximum(p1.x, p2.x, p3.x, p4.x) + " " + RequestParamaterFactory.maximum(p1.y, p2.y, p3.y, p4.y));
    }
}

