/*
 * Decompiled with CFR 0.152.
 */
package gls.utils.transfert;

import gls.utils.filtre.MonFiltre;
import gls.utils.transfert.BarreAttente;
import gls.utils.transfert.ImageAppareilPhoto;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JOptionPane;

public class Transfert {
    public String nomEvenement;
    public File cheminAccesImages;
    public String repertoireCible;
    public static String repImagesDefaut = "H:/Documents and Settings/All Users/Documents/Mes images/\u00c9chantillons d'images";
    public static String repCibleDefaut = "H:/Documents and Settings/All Users/Documents/Mes images";
    public static String[] extensionImage = new String[]{".JPEG", ".BMP", ".JPG"};

    public Transfert(String evenement, String repCible, String sourceImages) {
        this.cheminAccesImages = new File(sourceImages);
        this.repertoireCible = repCible;
        this.nomEvenement = evenement;
    }

    public Transfert(String evenement, String repCible) {
        this(evenement, repCible, repImagesDefaut);
    }

    public Transfert(String evenement) {
        this(evenement, repCibleDefaut, repImagesDefaut);
    }

    public boolean creerRepEven() {
        boolean repcree = true;
        File repEven = new File(String.valueOf(this.repertoireCible) + "/" + this.nomEvenement);
        try {
            if (repEven.exists()) {
                repEven.delete();
            }
            repEven.mkdir();
        }
        catch (Exception erreur) {
            JOptionPane.showMessageDialog(null, erreur.toString(), "Erreur", 0);
            repcree = false;
        }
        return repcree;
    }

    public void deplacerImages() {
        BarreAttente barreAttenteImage = new BarreAttente();
        barreAttenteImage.afficherBarre(true);
        if (!(this.cheminAccesImages.canRead() && this.cheminAccesImages.exists() && this.cheminAccesImages.isDirectory())) {
            JOptionPane.showMessageDialog(null, "Le fichier source ne peut pas \u00eatre lu ou n'existe pas ou n'est pas un repertoire", "Erreur", 0);
        } else {
            MonFiltre filtreImage = new MonFiltre();
            int j = 0;
            while (j < extensionImage.length) {
                filtreImage.addExtension(extensionImage[j]);
                ++j;
            }
            File[] images = this.cheminAccesImages.listFiles(filtreImage);
            if (this.creerRepEven()) {
                int i = 0;
                while (i < images.length) {
                    File newPicture = new File(String.valueOf(this.repertoireCible) + "/" + this.nomEvenement + "/" + this.nomEvenement + String.valueOf(i) + ".JPEG");
                    Transfert.deplacer(images[i], newPicture);
                    ImageAppareilPhoto image = new ImageAppareilPhoto(newPicture);
                    image.redimensionner();
                    ++i;
                }
            }
        }
        barreAttenteImage.afficherBarre(false);
    }

    public static boolean copier(File source, File destination) {
        boolean resultat = false;
        FileInputStream sourceFile = null;
        FileOutputStream destinationFile = null;
        try {
            try {
                int nbLecture;
                destination.createNewFile();
                sourceFile = new FileInputStream(source);
                destinationFile = new FileOutputStream(destination);
                byte[] buffer = new byte[524288];
                while ((nbLecture = sourceFile.read(buffer)) != -1) {
                    destinationFile.write(buffer, 0, nbLecture);
                }
                resultat = true;
            }
            catch (FileNotFoundException f) {
                JOptionPane.showMessageDialog(null, f.toString(), "Erreur", 0);
                try {
                    sourceFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    destinationFile.close();
                }
                catch (Exception exception) {}
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, e.toString(), "Erreur", 0);
                try {
                    sourceFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    destinationFile.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                sourceFile.close();
            }
            catch (Exception exception) {}
            try {
                destinationFile.close();
            }
            catch (Exception exception) {}
        }
        return resultat;
    }

    public static void deplacer(File source, File destination) {
        boolean result = false;
        result = Transfert.copier(source, destination);
        result = source.delete();
    }
}

