/*
 * Decompiled with CFR 0.152.
 */
package gls.utils.transfert;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ImageAppareilPhoto {
    double scale;
    String image_name;

    public ImageAppareilPhoto(File fichierImage) {
        this.image_name = fichierImage.getPath();
    }

    public void redimensionner() {
        this.redimensionner(0.5);
    }

    public void redimensionner(double facteur) {
        this.scale = facteur;
        Image img = new ImageIcon(this.image_name).getImage();
        BufferedImage smallImg = ImageAppareilPhoto.scale(ImageAppareilPhoto.toBufferedImage(img), this.scale);
        String file_format = this.image_name.substring(this.image_name.lastIndexOf(46) + 1);
        String nouvNomImage = String.valueOf(this.image_name.substring(0, this.image_name.lastIndexOf(46))) + "Small." + file_format;
        try {
            boolean success = ImageIO.write((RenderedImage)smallImg, file_format, new File(nouvNomImage));
            if (!success) {
                JOptionPane.showMessageDialog(new JFrame(), "Ecriture impossible:" + file_format);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Erreur", 0);
        }
    }

    public void redimensionner(Dimension d) {
        Image img = new ImageIcon(this.image_name).getImage();
        int w = new ImageIcon(this.image_name).getIconWidth();
        int h = new ImageIcon(this.image_name).getIconHeight();
        System.out.println("w: " + w);
        System.out.println("h: " + h);
        double scaleX = (double)d.width / (double)w;
        double scaleY = (double)d.height / (double)h;
        this.scale = Math.min(scaleX, scaleY);
        BufferedImage smallImg = ImageAppareilPhoto.scale(ImageAppareilPhoto.toBufferedImage(img), this.scale);
        String file_format = this.image_name.substring(this.image_name.lastIndexOf(46) + 1);
        String nouvNomImage = String.valueOf(this.image_name.substring(0, this.image_name.lastIndexOf(46))) + "Small." + file_format;
        try {
            boolean success = ImageIO.write((RenderedImage)smallImg, file_format, new File(nouvNomImage));
            if (!success) {
                JOptionPane.showMessageDialog(new JFrame(), "Ecriture impossible:" + file_format);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Erreur", 0);
        }
    }

    public static BufferedImage toBufferedImage(Image image) {
        return ImageAppareilPhoto.toBufferedImage(image, 6, true);
    }

    public static BufferedImage getNewTransparentBufferedImage(int width, int height) {
        return ImageAppareilPhoto.getNewTransparentBufferedImage(width, height, 6);
    }

    public static BufferedImage getNewTransparentBufferedImage(int width, int height, int type) {
        BufferedImage bi;
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bi = gc.createCompatibleImage(width, height, 3);
        }
        catch (Exception e) {
            bi = new BufferedImage(width, height, type);
            Graphics2D g = bi.createGraphics();
            g.setBackground(new Color(255, 255, 255, 0));
            g.clearRect(0, 0, bi.getWidth(), bi.getHeight());
        }
        return bi;
    }

    public static BufferedImage toTransparentBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        BufferedImage bufferedImage = ImageAppareilPhoto.getNewTransparentBufferedImage(image.getWidth(null), image.getHeight(null));
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bufferedImage;
    }

    public static BufferedImage toBufferedImage(Image image, int imageType) {
        return ImageAppareilPhoto.toBufferedImage(image, imageType, true);
    }

    public static BufferedImage toBufferedImage(Image image, int imageType, boolean transparent) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        BufferedImage bufferedImage = transparent ? ImageAppareilPhoto.getNewTransparentBufferedImage(image.getWidth(null), image.getHeight(null), imageType) : new BufferedImage(image.getWidth(null), image.getHeight(null), imageType);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bufferedImage;
    }

    public static BufferedImage scale(BufferedImage bi, double scaleValue) {
        return ImageAppareilPhoto.scale(bi, scaleValue, true);
    }

    public static BufferedImage scale(BufferedImage bi, double scaleValue, boolean typeParDefaut) {
        AffineTransform tx = new AffineTransform();
        tx.scale(scaleValue, scaleValue);
        AffineTransformOp op = new AffineTransformOp(tx, 2);
        BufferedImage biNew = null;
        biNew = typeParDefaut ? ImageAppareilPhoto.getNewTransparentBufferedImage((int)((double)bi.getWidth() * scaleValue), (int)((double)bi.getHeight() * scaleValue)) : new BufferedImage((int)((double)bi.getWidth() * scaleValue), (int)((double)bi.getHeight() * scaleValue), bi.getType());
        return op.filter(bi, biNew);
    }

    public Image getImage() {
        return new ImageIcon(this.image_name).getImage();
    }

    public Icon getIcon() {
        return new ImageIcon(this.image_name);
    }

    public ImageIcon getImageIcon() {
        return new ImageIcon(this.image_name);
    }
}

