/*
 * Decompiled with CFR 0.152.
 */
package gls.utils.fichiers;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.parser.PdfTextExtractor;
import gls.utils.fichiers.Occurrence;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SearchEngineIntoFile {
    public List<Occurrence> searchXword(String pathFolder, List<String> filesName, String maRecherche) {
        maRecherche = maRecherche.replaceAll(",", " ");
        maRecherche = maRecherche.replaceAll("\"", " ");
        Vector<String> filesNameTri = new Vector<String>();
        for (String docName : filesName) {
            File fichier = new File(String.valueOf(pathFolder) + docName);
            if (!fichier.exists()) continue;
            filesNameTri.add(docName);
        }
        return this.recherche(pathFolder, filesNameTri, maRecherche);
    }

    public List<Occurrence> searchXword(List<String> textes, String maRecherche) {
        ArrayList<Occurrence> lesOccurences = new ArrayList<Occurrence>();
        StringTokenizer Xarg = new StringTokenizer(maRecherche);
        for (String texte : textes) {
            if (texte == null) continue;
            lesOccurences.add(this.countToken(Xarg, texte));
        }
        return lesOccurences;
    }

    private List<Occurrence> recherche(String pathFolder, List<String> filesName, String maRecherche) {
        List<Occurrence> lesOccurrences = this.laListeDesOccurrences(filesName, maRecherche, pathFolder);
        return lesOccurrences;
    }

    private List<Occurrence> laListeDesOccurrences(List<String> filesName, String maRecherche, String pathName) {
        ArrayList<Occurrence> lesOccurences = new ArrayList<Occurrence>();
        for (String docName : filesName) {
            StringTokenizer Xarg = new StringTokenizer(maRecherche);
            File fichier = new File(String.valueOf(pathName) + docName);
            StringBuffer mesPagesDoc = new StringBuffer();
            String extension = this.getExtension(docName);
            if (extension.equals("pdf")) {
                mesPagesDoc = this.pdfToString(fichier, 2);
                lesOccurences.add(this.countToken(Xarg, mesPagesDoc, docName));
                continue;
            }
            if (!extension.equals("txt")) continue;
            mesPagesDoc = this.txtToString(fichier, 2);
            lesOccurences.add(this.countToken(Xarg, mesPagesDoc, docName));
        }
        return lesOccurences;
    }

    public String getExtension(String phrase) {
        int longueurV = phrase.indexOf(".");
        try {
            String extension = phrase.substring(longueurV + 1);
            return extension;
        }
        catch (Exception e) {
            return String.valueOf(e.getMessage()) + "cette chaine de caract\u00e8res ne poss\u00e8de pas d'extension";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StringBuffer pdfToString(File fichier, int etat) {
        StringBuffer mesPagesDoc = new StringBuffer();
        try {
            FileInputStream filepdf = new FileInputStream(fichier);
            PdfReader reader = new PdfReader((InputStream)filepdf);
            PdfTextExtractor pdftextextractor = new PdfTextExtractor(reader);
            int i = 0;
            while (true) {
                if (i >= reader.getNumberOfPages()) {
                    return mesPagesDoc;
                }
                if (etat == 2) {
                    mesPagesDoc.append(pdftextextractor.getTextFromPage(i + 1).toLowerCase(Locale.FRANCE));
                } else if (etat == 1) {
                    mesPagesDoc.append(pdftextextractor.getTextFromPage(i + 1).toUpperCase(Locale.FRANCE));
                } else {
                    if (etat != 0) return null;
                    mesPagesDoc.append(pdftextextractor.getTextFromPage(i + 1));
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public StringBuffer txtToString(File fichier, int etat) {
        StringBuffer chaine = new StringBuffer();
        try {
            FileReader reader = new FileReader(fichier);
            BufferedReader bf = new BufferedReader(reader);
            if (etat == 0) {
                String ligne = bf.readLine();
                while (ligne != null) {
                    chaine.append(String.valueOf(ligne) + "\n");
                    ligne = bf.readLine();
                }
            } else if (etat == 1) {
                String ligne = bf.readLine();
                while (ligne != null) {
                    chaine.append(String.valueOf(ligne.toUpperCase(Locale.FRANCE)) + "\n");
                    ligne = bf.readLine();
                }
            } else if (etat == 2) {
                String ligne = bf.readLine();
                while (ligne != null) {
                    chaine.append(String.valueOf(ligne.toLowerCase(Locale.FRANCE)) + "\n");
                    ligne = bf.readLine();
                }
            }
            bf.close();
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
            return null;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return null;
        }
        return chaine;
    }

    public void getListeWithPercentAttribute(List<Occurrence> liste) {
        Collections.sort(liste);
        int taille = liste.size();
        Occurrence premier = liste.get(taille - 1);
        int monDiviseur = premier.getNbOccurrence();
        for (Occurrence oc : liste) {
            float f = oc.getNbOccurrence() * 100 / monDiviseur;
        }
    }

    private Occurrence countToken(StringTokenizer Xarg, StringBuffer mesPagesDoc, String docName) {
        Occurrence entree = new Occurrence();
        TreeMap<String, Integer> uneTmap = new TreeMap<String, Integer>();
        HashMap<Integer, String> hmapDoublon = new HashMap<Integer, String>();
        int compte = 0;
        while (Xarg.hasMoreTokens()) {
            int occurrence = 0;
            String arg = Xarg.nextToken().trim();
            if (hmapDoublon.containsValue(arg)) continue;
            hmapDoublon.put(compte++, arg);
            Pattern pattern = Pattern.compile(arg);
            Matcher matcher = pattern.matcher(mesPagesDoc);
            while (matcher.find()) {
                ++occurrence;
            }
            uneTmap.put(arg, occurrence);
        }
        entree.setTmap(uneTmap);
        entree.setNom(docName);
        return entree;
    }

    private Occurrence countToken(StringTokenizer Xarg, String mesPagesDoc) {
        Occurrence entree = new Occurrence();
        TreeMap<String, Integer> uneTmap = new TreeMap<String, Integer>();
        HashMap<Integer, String> hmapDoublon = new HashMap<Integer, String>();
        int compte = 0;
        while (Xarg.hasMoreTokens()) {
            int occurrence = 0;
            String arg = Xarg.nextToken().trim().toLowerCase(Locale.FRANCE);
            if (hmapDoublon.containsValue(arg)) continue;
            hmapDoublon.put(compte++, arg);
            Pattern pattern = Pattern.compile(arg);
            Matcher matcher = pattern.matcher(mesPagesDoc.toLowerCase(Locale.FRANCE));
            while (matcher.find()) {
                ++occurrence;
            }
            uneTmap.put(arg, occurrence);
        }
        entree.setTmap(uneTmap);
        entree.setNom("document");
        return entree;
    }
}

