/*
 * Decompiled with CFR 0.152.
 */
package gls.ui.mytable;

import gls.ui.mytable.MyTableListener;
import gls.ui.mytable.TableSorter;
import java.awt.FontMetrics;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;

public class MyTable
extends JTable {
    private Vector myTableListener = new Vector();

    public MyTable(TableSorter sorter) {
        super(sorter);
    }

    public void addMyTableListener(MyTableListener tableListener) {
        this.myTableListener.add(tableListener);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        try {
            int size = this.myTableListener.size();
            int i = 0;
            while (i < size) {
                MyTableListener tableListener = (MyTableListener)this.myTableListener.elementAt(i);
                tableListener.update(e);
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void moveColumn(int column, int targetColumn) {
    }

    public void setColumnInvisible(Object columnObject) {
        this.getColumn(columnObject).setPreferredWidth(0);
        this.getColumn(columnObject).setMinWidth(0);
        this.getColumn(columnObject).setMaxWidth(0);
    }

    public void setColumnSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int i = 0;
        while (i < this.getColumnCount()) {
            int max = 0;
            int j = 0;
            while (j < this.getRowCount()) {
                int taille;
                Object o = this.getValueAt(j, i);
                if (o instanceof String && (taille = fm.stringWidth((String)this.getValueAt(j, i))) > max) {
                    max = taille;
                }
                ++j;
            }
            String nom = (String)this.getColumnModel().getColumn(i).getIdentifier();
            int taille = fm.stringWidth(nom);
            if (taille > max) {
                max = taille;
            }
            this.getColumnModel().getColumn(i).setPreferredWidth(max + 5);
            ++i;
        }
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }
}

