/*
 * Decompiled with CFR 0.152.
 */
package gls.ui.myspinner;

import gls.ui.myspinner.DateSpinnerModel;
import gls.ui.myspinner.MySpinnerDate;
import gls.ui.myspinner.MySpinnerModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MySpinner
extends JPanel {
    protected List changeListeners = new ArrayList();
    protected int orientation = 1;
    protected JButton incrementButton;
    protected JButton decrementButton;
    protected MySpinnerModel spinnerModel;
    protected JTextField input;
    protected Font fonte;

    protected MySpinner() {
    }

    public MySpinner(MySpinnerModel spinnerModel) {
        this.spinnerModel = spinnerModel;
        this.createComponents();
        this.setValue(spinnerModel.getValue());
    }

    public MySpinner(MySpinnerModel spinnerModel, int orientation) {
        this.spinnerModel = spinnerModel;
        this.orientation = orientation;
        this.createComponents();
        this.setValue(spinnerModel.getValue());
    }

    public MySpinner(int orientation) {
        this.orientation = orientation;
        this.createComponents();
        this.setValue(new Integer(0));
    }

    @Override
    public void setEnabled(boolean enable) {
        this.incrementButton.setEnabled(enable);
        this.decrementButton.setEnabled(enable);
    }

    @Override
    public boolean isEnabled() {
        return this.incrementButton.isEnabled() && this.decrementButton.isEnabled();
    }

    protected void createComponents() {
        this.createComponents(3);
    }

    protected void createComponents(int nbLignes) {
        JPanel arrows = new JPanel();
        ActionListenerSpinner actionListener = new ActionListenerSpinner();
        this.input = new JTextField(nbLignes);
        if (this.orientation == 1) {
            arrows.setLayout(new GridLayout(2, 1));
            this.incrementButton = new JButton("+");
            this.incrementButton.addActionListener(actionListener);
            this.decrementButton = new JButton("-");
            this.decrementButton.addActionListener(actionListener);
            arrows.add(this.incrementButton);
            arrows.add(this.decrementButton);
        } else if (this.orientation == 0) {
            arrows.setLayout(new GridLayout(1, 2));
            this.incrementButton = new JButton("+");
            this.incrementButton.addActionListener(actionListener);
            this.decrementButton = new JButton("-");
            this.decrementButton.addActionListener(actionListener);
            arrows.add(this.decrementButton);
            arrows.add(this.incrementButton);
        }
        this.add((Component)this.input, "Center");
        this.add((Component)arrows, "East");
    }

    public JButton getIncrementButton() {
        return this.incrementButton;
    }

    public JButton getDecrementButton() {
        return this.decrementButton;
    }

    public void setValue(Object value) {
    }

    public void setValue() {
    }

    public void fireChangeValue() {
        ListIterator it = this.changeListeners.listIterator();
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(new ChangeEvent(this));
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        JPanel panel = (JPanel)frame.getContentPane();
        panel.setLayout(new BorderLayout());
        JTextField field = new JTextField(20);
        DateSpinnerModel model = new DateSpinnerModel(Calendar.getInstance().getTime(), null, null, 12);
        model.setCalendarField(12);
        MySpinnerDate spinner = new MySpinnerDate(model, new SimpleDateFormat("HH:mm"), 0);
        frame.add(spinner);
        Dimension dim = frame.getToolkit().getScreenSize();
        frame.setLocation(dim.width / 2 - frame.getWidth() / 2, dim.height / 2 - frame.getHeight() / 2);
        frame.pack();
        frame.show();
    }

    public Font getFonte() {
        return this.fonte;
    }

    public void setFonte(Font font) {
        this.fonte = font;
        this.input.setFont(this.fonte);
        this.incrementButton.setFont(this.fonte);
        this.decrementButton.setFont(this.fonte);
    }

    private class ActionListenerSpinner
    implements ActionListener {
        private ActionListenerSpinner() {
        }

        @Override
        public void actionPerformed(ActionEvent action) {
            System.out.println("OK");
            JButton button = (JButton)action.getSource();
            if (button == MySpinner.this.incrementButton) {
                MySpinner.this.spinnerModel.setValue(MySpinner.this.spinnerModel.getNextValue());
                MySpinner.this.setValue();
            } else if (button == MySpinner.this.decrementButton) {
                MySpinner.this.spinnerModel.setValue(MySpinner.this.spinnerModel.getPreviousValue());
                MySpinner.this.setValue();
            }
        }
    }
}

