/*
 * Decompiled with CFR 0.152.
 */
package gls.ui.myspinner;

import gls.ui.myspinner.MySpinnerModel;
import java.util.Calendar;
import java.util.Date;
import javax.swing.event.ChangeListener;

public class DateSpinnerModel
implements MySpinnerModel {
    private Comparable start;
    private Comparable end;
    private Calendar value;
    private int calendarField;
    int step = 1;

    private boolean calendarFieldOK(int calendarField) {
        switch (calendarField) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public DateSpinnerModel(Date value, Comparable start, Comparable end, int calendarField) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (!this.calendarFieldOK(calendarField)) {
            throw new IllegalArgumentException("invalid calendarField");
        }
        if (start != null && start.compareTo(value) > 0 || end != null && end.compareTo(value) < 0) {
            throw new IllegalArgumentException("(start <= value <= end) is false");
        }
        this.value = Calendar.getInstance();
        this.start = start;
        this.end = end;
        this.calendarField = calendarField;
        this.value.setTime(value);
    }

    public DateSpinnerModel() {
        this(new Date(), null, null, 5);
    }

    public void setStart(Comparable start) {
        if (start == null ? this.start != null : !start.equals(this.start)) {
            this.start = start;
            this.fireStateChanged();
        }
    }

    private void fireStateChanged() {
    }

    public Comparable getStart() {
        return this.start;
    }

    public void setEnd(Comparable end) {
        if (end == null ? this.end != null : !end.equals(this.end)) {
            this.end = end;
            this.fireStateChanged();
        }
    }

    public Comparable getEnd() {
        return this.end;
    }

    public void setCalendarField(int calendarField) {
        if (!this.calendarFieldOK(calendarField)) {
            throw new IllegalArgumentException("invalid calendarField");
        }
        if (calendarField != this.calendarField) {
            this.calendarField = calendarField;
            this.fireStateChanged();
        }
    }

    public int getCalendarField() {
        return this.calendarField;
    }

    @Override
    public Object getNextValue() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.value.getTime());
        cal.add(this.calendarField, this.step);
        Date next = cal.getTime();
        return this.end == null || this.end.compareTo(next) >= 0 ? next : null;
    }

    @Override
    public Object getPreviousValue() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.value.getTime());
        cal.add(this.calendarField, -1 * this.step);
        Date prev = cal.getTime();
        return this.start == null || this.start.compareTo(prev) <= 0 ? prev : null;
    }

    public Date getDate() {
        return this.value.getTime();
    }

    @Override
    public Object getValue() {
        return this.value.getTime();
    }

    @Override
    public void setValue(Object value) {
        if (value == null || !(value instanceof Date)) {
            throw new IllegalArgumentException("null value");
        }
        if (!value.equals(this.value.getTime())) {
            this.value.setTime((Date)value);
            this.fireStateChanged();
        }
    }

    @Override
    public void addChangeListener(ChangeListener l) {
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
    }

    @Override
    public void setStep(Object step) {
        if (step instanceof Integer) {
            this.step = (Integer)step;
        }
    }

    @Override
    public Object getStep() {
        return new Integer(this.step);
    }
}

