/*
 * Decompiled with CFR 0.152.
 */
package gls.ui.mycombobox;

import gls.ui.mycombobox.MyComboBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.swing.JTextField;

public class MyKeyListener
implements KeyListener {
    private MyComboBox myCombobox;
    private JTextField jtfTextField;
    private String realTextEntered = "";
    private int indice;
    private List indicePrecedent;
    private Comparator COMPARATOR;
    private Comparator compartor = this.COMPARATOR = this.initComparateurDefaut();

    public MyKeyListener(MyComboBox myCombobox, JTextField jtfTextField) {
        this.myCombobox = myCombobox;
        this.jtfTextField = jtfTextField;
        this.indice = 0;
        this.indicePrecedent = new ArrayList();
        this.indicePrecedent.add(0, new Integer(0));
    }

    private Comparator initComparateurDefaut() {
        Collator c = Collator.getInstance(Locale.FRENCH);
        c.setStrength(0);
        return c;
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int charTyped = e.getKeyCode();
        if (charTyped == 10 || charTyped == 9) {
            ActionListener[] actionListeners = this.myCombobox.getActionListeners();
            int i = 0;
            while (i < actionListeners.length) {
                actionListeners[i].actionPerformed(new ActionEvent(this.myCombobox, 0, "comboBoxSelection"));
                ++i;
            }
            this.realTextEntered = this.jtfTextField.getText();
        }
        if (charTyped != 10 && charTyped != 16) {
            int position;
            String text;
            if (!this.myCombobox.isPopupVisible()) {
                this.myCombobox.setPopupVisible(true);
            }
            if (charTyped == 8) {
                try {
                    this.realTextEntered = this.realTextEntered.substring(0, this.realTextEntered.length() - 1);
                }
                catch (Exception actionListeners) {
                    // empty catch block
                }
                text = this.jtfTextField.getText();
                position = this.rechercherText(this.myCombobox, this.realTextEntered);
                this.ajusterSelection(this.myCombobox, position);
                this.jtfTextField.setText(this.realTextEntered);
            } else if (e.getKeyCode() == 127) {
                int debutSelection = this.jtfTextField.getSelectionStart();
                int finSelection = this.jtfTextField.getSelectionEnd();
                this.realTextEntered = this.realTextEntered.substring(debutSelection, finSelection);
                String text2 = this.jtfTextField.getText();
                int position2 = this.rechercherText(this.myCombobox, this.realTextEntered);
                this.ajusterSelection(this.myCombobox, position2);
                this.jtfTextField.setText(this.realTextEntered);
            } else if (e.getKeyCode() == 40) {
                this.realTextEntered = (String)this.myCombobox.getSelectedItem();
            } else if (e.getKeyCode() == 38) {
                this.realTextEntered = (String)this.myCombobox.getSelectedItem();
            } else if (e.getKeyCode() != 37 && e.getKeyCode() != 39) {
                this.realTextEntered = String.valueOf(this.realTextEntered) + e.getKeyChar();
                text = this.jtfTextField.getText();
                position = this.rechercherText(this.myCombobox, this.realTextEntered);
                this.ajusterSelection(this.myCombobox, position);
                if (position != -1) {
                    this.jtfTextField.setText((String)this.myCombobox.getItemAt(position));
                    String selection = (String)this.myCombobox.getSelectedItem();
                    int indexDebut = selection.toLowerCase().indexOf(this.realTextEntered.toLowerCase());
                    this.jtfTextField.setSelectedTextColor(Color.red);
                    this.jtfTextField.setSelectionStart(indexDebut);
                    this.jtfTextField.setSelectionEnd(indexDebut + this.realTextEntered.length());
                    this.jtfTextField.setText(this.realTextEntered);
                } else {
                    this.jtfTextField.setText(this.realTextEntered);
                }
            }
        }
    }

    private void ajusterSelection(MyComboBox myCombobox, int position) {
        int nbItems = myCombobox.getItemCount();
        if (position != -1) {
            if (position + myCombobox.getMaximumRowCount() < nbItems) {
                myCombobox.setSelectedIndex(position + myCombobox.getMaximumRowCount());
            }
            myCombobox.setSelectedIndex(position);
        }
    }

    private int rechercherText(MyComboBox myCombobox, String text) {
        int nbItems = myCombobox.getItemCount();
        int tailleTexte = text.length();
        int i = 0;
        while (i < nbItems) {
            int resultatcomparaison;
            String item = ((String)myCombobox.getItemAt(i)).toLowerCase();
            int tailleItem = item.length();
            if (tailleItem < tailleTexte) {
                String textSub = text.substring(0, tailleItem);
                resultatcomparaison = this.compartor.compare(item, textSub);
                if (resultatcomparaison > 0) {
                    return i == 0 ? 0 : i - 1;
                }
            } else {
                String itemSub = item.substring(0, tailleTexte);
                resultatcomparaison = this.compartor.compare(itemSub, text);
                if (resultatcomparaison == 0) {
                    this.indicePrecedent.add(0, new Integer(this.indice));
                    this.indice = i;
                    return i;
                }
                if (resultatcomparaison == 1) {
                    this.indicePrecedent.add(0, new Integer(this.indice));
                    this.indice = i;
                    return i == 0 ? 0 : i - 1;
                }
            }
            ++i;
        }
        this.indicePrecedent.add(0, new Integer(this.indice));
        this.indice = -1;
        return -1;
    }

    public Comparator getCompartor() {
        return this.compartor;
    }

    public void setCompartor(Comparator comparator) {
        this.compartor = comparator;
    }
}

