/*
 * Decompiled with CFR 0.152.
 */
package gls.ui.calendarcombobox;

import gls.ui.calendarcombobox.CalendarComboBoxMediator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class CalendarComboBoxEmbarque
extends JPanel {
    private static final DateFormatSymbols DATE_FORMAT_SYMBOLS = new DateFormatSymbols();
    private static final String[] MONTHS = DATE_FORMAT_SYMBOLS.getMonths();
    private static final String[] dAY_NAMES = new String[7];
    private static final Toolkit TOOLKIT = Toolkit.getDefaultToolkit();
    private final JPanel inputPanel = new JPanel();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    private final JTextField input = new JTextField(this.dateFormat.format(new Date()));
    private final BasicArrowButton comboBtn = new BasicArrowButton(5);
    private final JPanel calPanel = new JPanel();
    private final JTextField calLabel = new JTextField(11);
    private final Calendar current = new GregorianCalendar();
    private final CalendarModel display = new CalendarModel(6, 6);
    private final JTable table = new JTable(this.display);
    private final BasicArrowButton nextBtn = new BasicArrowButton(3);
    private final BasicArrowButton prevBtn = new BasicArrowButton(7);
    private final BasicArrowButton closeCalendarBtn = new BasicArrowButton(1);
    private Popup popup;
    private CalendarComboBoxMediator mediator;
    private CalendarComboBoxEmbarque date;
    private Font fonteUtilisee;

    public CalendarComboBoxEmbarque() {
        this(new GregorianCalendar());
    }

    public CalendarComboBoxEmbarque(Calendar cal) {
        Date date = cal.getTime();
        this.current.setTime(date);
        this.input.setHorizontalAlignment(0);
        this.input.setText(this.dateFormat.format(date));
        this.input.setFont(new Font("Arial", 0, 24));
        this.buildInputPanel();
        this.registerListeners();
        this.setBackground(Color.white);
        this.add(this.inputPanel);
        this.mediator = null;
        date = null;
        this.setEnabled(false);
    }

    @Override
    public void setFont(Font nouvelleFonte) {
        this.fonteUtilisee = nouvelleFonte;
        if (this.input != null) {
            this.input.setFont(this.fonteUtilisee);
        }
    }

    public void addMediator(CalendarComboBoxMediator mediator) {
        this.mediator = mediator;
    }

    public void setCalendarComboBox(CalendarComboBoxEmbarque date) {
        this.date = date;
    }

    private void buildInputPanel() {
        this.inputPanel.setLayout(new BoxLayout(this.inputPanel, 0));
        this.input.setColumns(10);
        this.inputPanel.add(this.input);
    }

    public void changeFont(Font _fnt) {
        this.input.setFont(_fnt);
    }

    protected void buildCalendarDisplay() {
        this.table.setCellSelectionEnabled(true);
        this.table.setSelectionMode(0);
        this.table.setShowGrid(false);
        String[] names = DATE_FORMAT_SYMBOLS.getShortWeekdays();
        int i = 1;
        while (i < names.length) {
            CalendarComboBoxEmbarque.dAY_NAMES[i - 1] = "" + names[i].charAt(0);
            ++i;
        }
        this.display.setColumnIdentifiers(dAY_NAMES);
        this.table.setModel(this.display);
        this.table.setAutoResizeMode(0);
        int count = this.table.getColumnCount();
        int i2 = 0;
        while (i2 < count) {
            TableColumn col = this.table.getColumnModel().getColumn(i2);
            col.setPreferredWidth(10);
            ++i2;
        }
        JTableHeader header = this.table.getTableHeader();
        header.setFont(header.getFont());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(header);
        panel.add(this.table);
        this.calPanel.setBorder(new LineBorder(Color.black));
        this.calPanel.setLayout(new BorderLayout());
        this.calPanel.add((Component)this.buildCalendarNavigationPanel(), "North");
        this.calPanel.add(panel);
    }

    protected JPanel buildCalendarNavigationPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.calLabel.setEditable(false);
        int fontSize = this.calLabel.getFont().getSize();
        this.calLabel.setFont(this.calLabel.getFont());
        panel.add(this.calLabel);
        this.prevBtn.setActionCommand("prevBtn");
        this.nextBtn.setActionCommand("nextBtn");
        this.closeCalendarBtn.setActionCommand("close");
        return panel;
    }

    @Override
    public void setEnabled(boolean _etat) {
        this.inputPanel.remove(this.comboBtn);
        if (_etat) {
            this.inputPanel.add(this.comboBtn);
        }
        this.comboBtn.setEnabled(_etat);
        this.input.setEnabled(_etat);
        this.table.setEnabled(false);
    }

    private void registerListeners() {
        ButtonActionListener btnListener = new ButtonActionListener();
        this.input.addKeyListener(new InputListener());
        this.comboBtn.addActionListener(btnListener);
        CalendarSelectionListener listener = new CalendarSelectionListener();
        this.table.getSelectionModel().addListSelectionListener(listener);
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(listener);
        this.prevBtn.addActionListener(btnListener);
        this.nextBtn.addActionListener(btnListener);
        this.closeCalendarBtn.addActionListener(btnListener);
    }

    private void updateTable(Calendar cal) {
        GregorianCalendar dayOne = new GregorianCalendar(cal.get(1), cal.get(2), 1);
        int actualDays = cal.getActualMaximum(5);
        int startIndex = dayOne.get(7) - 1;
        int day = 1;
        int row = 0;
        while (row < 6) {
            int col = 0;
            while (col < 7) {
                if (col < startIndex && row == 0 || day > actualDays) {
                    this.display.setValueAt("", row, col);
                } else {
                    this.display.setValueAt(new Integer(day), row, col);
                    ++day;
                }
                ++col;
            }
            ++row;
        }
        this.calLabel.setText(String.valueOf(MONTHS[cal.get(2)]) + ", " + cal.get(1));
    }

    public Calendar getDate() {
        return this.current;
    }

    public void setDate(Date newDate) {
        this.current.setTime(newDate);
        this.input.setText(this.dateFormat.format(this.current.getTime()));
    }

    public void closePopup() {
        try {
            this.popup.hide();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class ButtonActionListener
    implements ActionListener {
        private ButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals("prevBtn")) {
                CalendarComboBoxEmbarque.this.current.add(2, -1);
                CalendarComboBoxEmbarque.this.input.setText(CalendarComboBoxEmbarque.this.dateFormat.format(CalendarComboBoxEmbarque.this.current.getTime()));
            } else if (cmd.equals("nextBtn")) {
                CalendarComboBoxEmbarque.this.current.add(2, 1);
                CalendarComboBoxEmbarque.this.input.setText(CalendarComboBoxEmbarque.this.dateFormat.format(CalendarComboBoxEmbarque.this.current.getTime()));
            } else if (cmd.equals("close")) {
                CalendarComboBoxEmbarque.this.popup.hide();
                CalendarComboBoxEmbarque.this.comboBtn.setEnabled(true);
                if (CalendarComboBoxEmbarque.this.mediator != null) {
                    CalendarComboBoxEmbarque.this.mediator.update(CalendarComboBoxEmbarque.this.current);
                }
                if (CalendarComboBoxEmbarque.this.date != null) {
                    Calendar dateFin = CalendarComboBoxEmbarque.this.date.getDate();
                    if (CalendarComboBoxEmbarque.this.current.after(dateFin)) {
                        CalendarComboBoxEmbarque.this.date.setDate(CalendarComboBoxEmbarque.this.current.getTime());
                    }
                }
            } else {
                CalendarComboBoxEmbarque.this.comboBtn.setEnabled(false);
            }
            if (!cmd.equals("close")) {
                CalendarComboBoxEmbarque.this.updateTable(CalendarComboBoxEmbarque.this.current);
            }
        }
    }

    private class CalendarModel
    extends DefaultTableModel {
        public CalendarModel(int row, int col) {
            super(row, col);
        }

        public Class getColumnClass(int column) {
            return Integer.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    private class CalendarSelectionListener
    implements ListSelectionListener {
        private CalendarSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                int row = CalendarComboBoxEmbarque.this.table.getSelectedRow();
                int col = CalendarComboBoxEmbarque.this.table.getSelectedColumn();
                Object value = null;
                try {
                    value = CalendarComboBoxEmbarque.this.display.getValueAt(row, col);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (value instanceof Integer) {
                    int day = (Integer)value;
                    CalendarComboBoxEmbarque.this.current.set(5, day);
                    CalendarComboBoxEmbarque.this.input.setText(CalendarComboBoxEmbarque.this.dateFormat.format(CalendarComboBoxEmbarque.this.current.getTime()));
                }
            }
        }
    }

    private class InputListener
    extends KeyAdapter {
        private InputListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            DateFormat df = DateFormat.getDateInstance();
            Date date = null;
            try {
                date = df.parse(CalendarComboBoxEmbarque.this.input.getText());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            char c = e.getKeyChar();
            if (date != null && (c == '\n' || c == '\t')) {
                CalendarComboBoxEmbarque.this.current.setTime(date);
                CalendarComboBoxEmbarque.this.updateTable(CalendarComboBoxEmbarque.this.current);
            }
        }
    }
}

