/*
 * Decompiled with CFR 0.152.
 */
package gls.ui.calendarcombobox;

import gls.ui.calendarcombobox.CalendarComboBoxMediator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BoxLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class CalendarComboBox
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final DateFormatSymbols dfs = new DateFormatSymbols();
    private static final String[] months = dfs.getMonths();
    private static final String[] dayNames = new String[7];
    private static final Toolkit toolkit = Toolkit.getDefaultToolkit();
    private static final Dimension screenSize = toolkit.getScreenSize();
    private static final PopupFactory factory = PopupFactory.getSharedInstance();
    private final JPanel inputPanel = new JPanel();
    private final JFormattedTextField input = new JFormattedTextField(new Date());
    private final BasicArrowButton comboBtn = new BasicArrowButton(5);
    private final JPanel calPanel = new JPanel();
    private final JTextField calLabel = new JTextField(11);
    private final Calendar current = new GregorianCalendar();
    private final CalendarModel display = new CalendarModel(6, 6);
    private final JTable table = new JTable(this.display);
    private final BasicArrowButton nextBtn = new BasicArrowButton(3);
    private final BasicArrowButton prevBtn = new BasicArrowButton(7);
    private final BasicArrowButton closeCalendarBtn = new BasicArrowButton(1);
    private Popup popup;
    private int oldDay;
    private CalendarComboBoxMediator mediator;
    private CalendarComboBox date;

    public CalendarComboBox() {
        this(new GregorianCalendar());
    }

    public CalendarComboBox(Calendar cal) {
        Date date = cal.getTime();
        this.current.setTime(date);
        this.input.setValue(date);
        this.oldDay = this.current.get(5);
        this.buildInputPanel();
        this.buildCalendarDisplay();
        this.registerListeners();
        this.setBackground(Color.white);
        this.add(this.inputPanel);
        this.mediator = null;
        date = null;
    }

    public void addMediator(CalendarComboBoxMediator mediator) {
        this.mediator = mediator;
    }

    public void setCalendarComboBox(CalendarComboBox date) {
        this.date = date;
    }

    private void buildInputPanel() {
        this.inputPanel.setLayout(new BoxLayout(this.inputPanel, 0));
        this.input.setColumns(12);
        this.inputPanel.add(this.input);
        this.comboBtn.setActionCommand("combo");
        this.inputPanel.add(this.comboBtn);
    }

    public void changeFont(Font _fnt) {
        this.input.setFont(_fnt);
    }

    private void buildCalendarDisplay() {
        this.table.setCellSelectionEnabled(true);
        this.table.setSelectionMode(0);
        this.table.setShowGrid(false);
        String[] names = dfs.getShortWeekdays();
        int i = 1;
        while (i < names.length) {
            CalendarComboBox.dayNames[i - 1] = "" + names[i].charAt(0);
            ++i;
        }
        this.display.setColumnIdentifiers(dayNames);
        this.table.setModel(this.display);
        this.table.setAutoResizeMode(0);
        int count = this.table.getColumnCount();
        int i2 = 0;
        while (i2 < count) {
            TableColumn col = this.table.getColumnModel().getColumn(i2);
            col.setPreferredWidth(20);
            ++i2;
        }
        JTableHeader header = this.table.getTableHeader();
        header.setFont(header.getFont().deriveFont(1));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(header);
        panel.add(this.table);
        this.calPanel.setBorder(new LineBorder(Color.black));
        this.calPanel.setLayout(new BorderLayout());
        this.calPanel.add((Component)this.buildCalendarNavigationPanel(), "North");
        this.calPanel.add(panel);
    }

    private JPanel buildCalendarNavigationPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.calLabel.setEditable(false);
        int fontSize = this.calLabel.getFont().getSize();
        this.calLabel.setFont(this.calLabel.getFont().deriveFont(0, fontSize - 2));
        panel.add(this.calLabel);
        this.prevBtn.setActionCommand("prevBtn");
        this.nextBtn.setActionCommand("nextBtn");
        this.closeCalendarBtn.setActionCommand("close");
        panel.add(this.prevBtn);
        panel.add(this.nextBtn);
        panel.add(this.closeCalendarBtn);
        return panel;
    }

    @Override
    public void setEnabled(boolean _etat) {
        this.comboBtn.setEnabled(_etat);
        this.input.setEnabled(_etat);
        this.table.setEnabled(false);
    }

    private void registerListeners() {
        ButtonActionListener btnListener = new ButtonActionListener();
        this.input.addKeyListener(new InputListener());
        this.comboBtn.addActionListener(btnListener);
        CalendarSelectionListener listener = new CalendarSelectionListener();
        this.table.getSelectionModel().addListSelectionListener(listener);
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(listener);
        this.prevBtn.addActionListener(btnListener);
        this.nextBtn.addActionListener(btnListener);
        this.closeCalendarBtn.addActionListener(btnListener);
    }

    private void updateTable(Calendar cal) {
        GregorianCalendar dayOne = new GregorianCalendar(cal.get(1), cal.get(2), 1);
        int actualDays = cal.getActualMaximum(5);
        int startIndex = dayOne.get(7) - 1;
        int day = 1;
        int row = 0;
        while (row < 6) {
            int col = 0;
            while (col < 7) {
                if (col < startIndex && row == 0 || day > actualDays) {
                    this.display.setValueAt("", row, col);
                } else {
                    this.display.setValueAt(new Integer(day), row, col);
                    ++day;
                }
                ++col;
            }
            ++row;
        }
        this.calLabel.setText(String.valueOf(months[cal.get(2)]) + ", " + cal.get(1));
    }

    private Popup getPopup() {
        Point p = this.input.getLocationOnScreen();
        Dimension inputSize = this.input.getPreferredSize();
        Dimension calendarSize = this.calPanel.getPreferredSize();
        this.popup = p.y + calendarSize.height < CalendarComboBox.screenSize.height ? factory.getPopup(this.input, this.calPanel, p.x, p.y + inputSize.height) : factory.getPopup(this.input, this.calPanel, p.x, p.y - calendarSize.height);
        return this.popup;
    }

    public Calendar getDate() {
        return this.current;
    }

    public void setDate(Date newDate) {
        this.current.setTime(newDate);
        this.input.setValue(this.current.getTime());
        this.oldDay = this.current.get(5);
    }

    public void closePopup() {
        try {
            this.popup.hide();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class ButtonActionListener
    implements ActionListener {
        private ButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals("prevBtn")) {
                CalendarComboBox.this.current.add(2, -1);
                CalendarComboBox.this.input.setValue(CalendarComboBox.this.current.getTime());
            } else if (cmd.equals("nextBtn")) {
                CalendarComboBox.this.current.add(2, 1);
                CalendarComboBox.this.input.setValue(CalendarComboBox.this.current.getTime());
            } else if (cmd.equals("close")) {
                CalendarComboBox.this.popup.hide();
                CalendarComboBox.this.comboBtn.setEnabled(true);
                if (CalendarComboBox.this.mediator != null) {
                    CalendarComboBox.this.mediator.update(CalendarComboBox.this.current);
                }
                if (CalendarComboBox.this.date != null) {
                    Calendar dateFin = CalendarComboBox.this.date.getDate();
                    if (CalendarComboBox.this.current.after(dateFin)) {
                        CalendarComboBox.this.date.setDate(CalendarComboBox.this.current.getTime());
                    }
                }
            } else {
                CalendarComboBox.this.comboBtn.setEnabled(false);
                CalendarComboBox.this.popup = CalendarComboBox.this.getPopup();
                CalendarComboBox.this.popup.show();
            }
            if (!cmd.equals("close")) {
                CalendarComboBox.this.updateTable(CalendarComboBox.this.current);
            }
        }
    }

    private class CalendarModel
    extends DefaultTableModel {
        public CalendarModel(int row, int col) {
            super(row, col);
        }

        public Class getColumnClass(int column) {
            return Integer.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    private class CalendarSelectionListener
    implements ListSelectionListener {
        private CalendarSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                int row = CalendarComboBox.this.table.getSelectedRow();
                int col = CalendarComboBox.this.table.getSelectedColumn();
                Object value = null;
                try {
                    value = CalendarComboBox.this.display.getValueAt(row, col);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (value instanceof Integer) {
                    int day = (Integer)value;
                    CalendarComboBox.this.current.set(5, day);
                    CalendarComboBox.this.input.setValue(CalendarComboBox.this.current.getTime());
                }
            }
        }
    }

    private class InputListener
    extends KeyAdapter {
        private InputListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            DateFormat df = DateFormat.getDateInstance();
            Date date = null;
            try {
                date = df.parse(CalendarComboBox.this.input.getText());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            char c = e.getKeyChar();
            if (date != null && (c == '\n' || c == '\t')) {
                CalendarComboBox.this.current.setTime(date);
                CalendarComboBox.this.updateTable(CalendarComboBox.this.current);
            }
        }
    }
}

