/*
 * Decompiled with CFR 0.152.
 */
package gls.ui.aidesaisie.keyListener;

import gls.comparator.CollatorFactory;
import gls.ui.aidesaisie.combobox.MyComboBoxAideSaisie;
import gls.ui.aidesaisie.combobox.MyComboBoxWithRenderer;
import gls.ui.aidesaisie.comboboxrenderer.ComboBoxAideRender;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JTextField;

public class MyKeyListenerRecherche
implements KeyListener {
    private static String TOKENS = " -'";
    private MyComboBoxWithRenderer myCombobox;
    private ComboBoxAideRender renderer = null;
    private JTextField jtfTextField;
    private String realTextEntered = "";
    private Comparator COMPARATOR;
    private Comparator compartor = this.COMPARATOR = this.initComparateurDefaut();
    private HashMap hashRecherche = new HashMap();

    public MyKeyListenerRecherche(MyComboBoxWithRenderer myCombobox, JTextField jtfTextField) {
        this.myCombobox = myCombobox;
        this.jtfTextField = jtfTextField;
        this.jtfTextField.addFocusListener(new MyFocusListener());
    }

    private Comparator initComparateurDefaut() {
        return CollatorFactory.create();
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int tailleText;
        int charTyped = e.getKeyCode();
        if (charTyped == 8 && (tailleText = this.realTextEntered.length()) > 0) {
            this.realTextEntered = this.realTextEntered.substring(0, this.realTextEntered.length() - 1);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.jtfTextField.setCursor(Cursor.getPredefinedCursor(3));
        int charTyped = e.getKeyCode();
        if (charTyped == 10 || charTyped == 9) {
            ActionListener[] actionListeners = this.myCombobox.getActionListeners();
            int i = 0;
            while (i < actionListeners.length) {
                actionListeners[i].actionPerformed(new ActionEvent(this.myCombobox, 0, "comboBoxSelection"));
                ++i;
            }
            this.realTextEntered = this.jtfTextField.getText();
        }
        if (charTyped != 10 && charTyped != 16) {
            int position;
            String text;
            if (!this.myCombobox.isPopupVisible()) {
                this.myCombobox.setPopupVisible(true);
            }
            if (charTyped == 8) {
                text = this.jtfTextField.getText();
                position = this.rechercherText(this.myCombobox, this.realTextEntered);
                if (this.renderer != null) {
                    this.renderer.setTexteRecherche(this.realTextEntered);
                }
                this.myCombobox.setSelectedIndex(position);
                this.jtfTextField.setText(this.realTextEntered);
            } else if (e.getKeyCode() == 127) {
                int debutSelection = this.jtfTextField.getSelectionStart();
                int finSelection = this.jtfTextField.getSelectionEnd();
                this.realTextEntered = this.realTextEntered.substring(debutSelection, finSelection);
                String text2 = this.jtfTextField.getText();
                int position2 = this.rechercherText(this.myCombobox, this.realTextEntered);
                if (this.renderer != null) {
                    this.renderer.setTexteRecherche(this.realTextEntered);
                }
                this.myCombobox.setSelectedIndex(position2);
                this.jtfTextField.setText(this.realTextEntered);
            } else if (e.getKeyCode() == 40) {
                this.realTextEntered = (String)this.myCombobox.getSelectedItem();
            } else if (e.getKeyCode() == 38) {
                this.realTextEntered = (String)this.myCombobox.getSelectedItem();
            } else if (e.getKeyCode() != 37 && e.getKeyCode() != 39) {
                this.realTextEntered = String.valueOf(this.realTextEntered) + e.getKeyChar();
                text = this.jtfTextField.getText();
                position = this.rechercherText(this.myCombobox, this.realTextEntered);
                if (this.renderer != null) {
                    this.renderer.setTexteRecherche(this.realTextEntered);
                }
                this.myCombobox.setSelectedIndex(position);
                this.jtfTextField.setText(this.realTextEntered);
            }
        }
        this.jtfTextField.setCursor(Cursor.getPredefinedCursor(0));
    }

    private int rechercherText_1(MyComboBoxAideSaisie myCombobox, String text) {
        int i;
        Vector resultat = new Vector();
        if (this.hashRecherche.containsKey(text)) {
            resultat = (Vector)this.hashRecherche.get(text);
        } else {
            int nbItems = myCombobox.getItemCount();
            i = 0;
            while (i < nbItems) {
                String item = (String)myCombobox.getItemAt(i);
                String itemLowerCase = item.toLowerCase();
                StringTokenizer st = new StringTokenizer(itemLowerCase, TOKENS);
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!token.startsWith(text)) continue;
                    resultat.add(item);
                    break;
                }
                ++i;
            }
            this.hashRecherche.put(text, resultat);
        }
        myCombobox.removeAllItems(false);
        int size = resultat.size();
        i = 0;
        while (i < size) {
            myCombobox.addItem(resultat.get(i));
            ++i;
        }
        return size > 0 ? 0 : -1;
    }

    private int rechercherText(MyComboBoxWithRenderer myCombobox, String text) {
        Vector resultat = new Vector();
        String textLower = text.toLowerCase();
        if (this.hashRecherche.containsKey(text.toLowerCase())) {
            resultat = (Vector)this.hashRecherche.get(text.toLowerCase());
        } else {
            Vector v = myCombobox.getElements();
            int nbItems = v.size();
            int i = 0;
            while (i < nbItems) {
                String item = v.get(i).toString();
                String itemLowerCase = item.toLowerCase();
                if (textLower.indexOf(" ") != -1 || textLower.indexOf("-") != -1) {
                    this.rechercheMultiple(resultat, textLower, item);
                } else {
                    this.rechercheSimple(resultat, textLower, item);
                }
                ++i;
            }
            this.hashRecherche.put(text.toLowerCase(), resultat);
        }
        myCombobox.removeAllItems(false);
        int i = 0;
        while (i < resultat.size()) {
            myCombobox.addItem(resultat.get(i));
            ++i;
        }
        return resultat.size() > 0 ? 0 : -1;
    }

    private void rechercheMultiple(Vector resultat, String textLower, String item) {
        StringTokenizer stRecherche = new StringTokenizer(textLower, TOKENS);
        while (stRecherche.hasMoreTokens()) {
            String tokenRecherche = stRecherche.nextToken();
            int lgTokenRecherche = tokenRecherche.length();
            StringTokenizer st = new StringTokenizer(item.toLowerCase(), TOKENS);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (stRecherche.hasMoreTokens()) {
                    if (this.compartor.compare(token.toLowerCase(), tokenRecherche) != 0) continue;
                    break;
                }
                if (token.length() < lgTokenRecherche || this.compartor.compare(token.substring(0, lgTokenRecherche), tokenRecherche) != 0) continue;
                resultat.add(item);
                break;
            }
            if (!stRecherche.hasMoreTokens() || st.hasMoreTokens()) continue;
            return;
        }
    }

    private void rechercheSimple(Vector resultat, String textLower, String item) {
        StringTokenizer stRecherche = new StringTokenizer(textLower, TOKENS);
        block0: while (stRecherche.hasMoreTokens()) {
            String tokenRecherche = stRecherche.nextToken();
            int lgTokenRecherche = tokenRecherche.length();
            StringTokenizer st = new StringTokenizer(item.toLowerCase(), TOKENS);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.length() < lgTokenRecherche || this.compartor.compare(token.substring(0, lgTokenRecherche), tokenRecherche) != 0) continue;
                resultat.add(item);
                continue block0;
            }
        }
    }

    public Comparator getCompartor() {
        return this.compartor;
    }

    public void setCompartor(Comparator comparator) {
        this.compartor = comparator;
    }

    public void raz() {
        this.realTextEntered = "";
        this.hashRecherche.clear();
    }

    public void initialisation(Vector localites) {
        this.hashRecherche.put("", localites);
    }

    public void setRenderer(ComboBoxAideRender renderer) {
        this.renderer = renderer;
    }

    public static void main(String[] args) {
        MyKeyListenerRecherche.rechercheMultipleMain(new Vector(), "sainte-cro", "sainte-croix");
    }

    private static void rechercheMultipleMain(Vector resultat, String textLower, String item) {
        StringTokenizer stRecherche = new StringTokenizer(textLower, TOKENS);
        while (stRecherche.hasMoreTokens()) {
            String tokenRecherche = stRecherche.nextToken();
            StringTokenizer st = new StringTokenizer(item.toLowerCase(), TOKENS);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (stRecherche.hasMoreTokens()) {
                    if (token.toLowerCase().compareTo(tokenRecherche) != 0) continue;
                    System.out.println("OK 1");
                    break;
                }
                if (!token.startsWith(tokenRecherche)) continue;
                System.out.println("Trouve");
                resultat.add(item);
                break;
            }
            if (!stRecherche.hasMoreTokens() || st.hasMoreTokens()) continue;
            return;
        }
    }

    private class MyFocusListener
    implements FocusListener {
        private MyFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent arg0) {
            try {
                if (MyKeyListenerRecherche.this.myCombobox.getSelectedIndex() != -1) {
                    MyKeyListenerRecherche.this.jtfTextField.setSelectedTextColor(Color.red);
                    MyKeyListenerRecherche.this.jtfTextField.setSelectionStart(0);
                    MyKeyListenerRecherche.this.jtfTextField.setSelectionEnd(MyKeyListenerRecherche.this.realTextEntered.length());
                    MyKeyListenerRecherche.this.realTextEntered = "";
                    if (MyKeyListenerRecherche.this.renderer != null) {
                        MyKeyListenerRecherche.this.renderer.setTexteRecherche(MyKeyListenerRecherche.this.realTextEntered);
                    }
                }
            }
            catch (Exception e) {
                MyKeyListenerRecherche.this.realTextEntered = "";
            }
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            if (MyKeyListenerRecherche.this.myCombobox.getSelectedIndex() != -1) {
                ActionListener[] actionListeners = MyKeyListenerRecherche.this.myCombobox.getActionListeners();
                int i = 0;
                while (i < actionListeners.length) {
                    actionListeners[i].actionPerformed(new ActionEvent(MyKeyListenerRecherche.this.myCombobox, 0, "comboBoxSelectionTab"));
                    ++i;
                }
                MyKeyListenerRecherche.this.realTextEntered = MyKeyListenerRecherche.this.myCombobox.getSelectedItem().toString();
            }
        }
    }
}

