/*
 * Decompiled with CFR 0.152.
 */
package gls.ui.aidesaisie.keyListener;

import gls.comparator.CollatorFactory;
import gls.ui.aidesaisie.combobox.MyComboBoxAideSaisieBasic;
import gls.ui.aidesaisie.comboboxrenderer.ComboboxRenderer;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class MyKeyListenerAideSasieBasic
implements KeyListener {
    private static String TOKENS = " -'";
    private MyComboBoxAideSaisieBasic myCombobox;
    private ComboboxRenderer renderer = null;
    private JTextField jtfTextField;
    private String realTextEntered = "";
    private Comparator COMPARATOR;
    private Comparator compartor = this.COMPARATOR = this.initComparateurDefaut();
    private HashMap hashRecherche = new HashMap();

    public MyKeyListenerAideSasieBasic(MyComboBoxAideSaisieBasic myCombobox, JTextField jtfTextField) {
        this.myCombobox = myCombobox;
        this.jtfTextField = jtfTextField;
        this.jtfTextField.addFocusListener(new MyFocusListener());
    }

    private Comparator initComparateurDefaut() {
        return CollatorFactory.create();
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int tailleText;
        int charTyped = e.getKeyCode();
        if (charTyped == 8 && (tailleText = this.realTextEntered.length()) > 0) {
            this.realTextEntered = this.realTextEntered.substring(0, this.realTextEntered.length() - 1);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int charTyped = e.getKeyCode();
        if (charTyped == 10 || charTyped == 9) {
            ActionListener[] actionListeners = this.myCombobox.getActionListeners();
            int i = 0;
            while (i < actionListeners.length) {
                actionListeners[i].actionPerformed(new ActionEvent(this.myCombobox, 0, "comboBoxSelection"));
                ++i;
            }
            this.realTextEntered = this.jtfTextField.getText();
        }
        if (charTyped != 10 && charTyped != 16) {
            int position;
            String text;
            if (!this.myCombobox.isPopupVisible()) {
                this.myCombobox.setPopupVisible(true);
            }
            if (charTyped == 8) {
                text = this.jtfTextField.getText();
                position = this.rechercherText(this.myCombobox, this.realTextEntered);
                if (this.renderer != null) {
                    this.renderer.setTexteRecherche(this.realTextEntered);
                }
                this.ajusterSelection(this.myCombobox, position);
                this.jtfTextField.setText(this.realTextEntered);
            } else if (e.getKeyCode() == 127) {
                int debutSelection = this.jtfTextField.getSelectionStart();
                int finSelection = this.jtfTextField.getSelectionEnd();
                this.realTextEntered = this.realTextEntered.substring(debutSelection, finSelection);
                String text2 = this.jtfTextField.getText();
                int position2 = this.rechercherText(this.myCombobox, this.realTextEntered);
                if (this.renderer != null) {
                    this.renderer.setTexteRecherche(this.realTextEntered);
                }
                this.ajusterSelection(this.myCombobox, position2);
                this.jtfTextField.setText(this.realTextEntered);
            } else if (e.getKeyCode() == 40) {
                this.realTextEntered = (String)this.myCombobox.getSelectedItem();
            } else if (e.getKeyCode() == 38) {
                this.realTextEntered = (String)this.myCombobox.getSelectedItem();
            } else if (e.getKeyCode() != 37 && e.getKeyCode() != 39) {
                this.realTextEntered = String.valueOf(this.realTextEntered) + e.getKeyChar();
                text = this.jtfTextField.getText();
                position = this.rechercherText(this.myCombobox, this.realTextEntered);
                if (this.renderer != null) {
                    this.renderer.setTexteRecherche(this.realTextEntered);
                }
                this.ajusterSelection(this.myCombobox, position);
                this.jtfTextField.setText(this.realTextEntered);
            }
        }
    }

    private void ajusterSelection(JComboBox myCombobox, int position) {
        int nbItems = myCombobox.getItemCount();
        if (this.renderer != null) {
            this.renderer.noRender();
        }
        if (position != -1) {
            if (position + myCombobox.getMaximumRowCount() < nbItems) {
                myCombobox.setSelectedIndex(position + myCombobox.getMaximumRowCount());
            }
            if (this.renderer != null) {
                this.renderer.render();
            }
            myCombobox.setSelectedIndex(position);
        }
    }

    private int rechercherText(JComboBox myCombobox, String text) {
        String textLower = text.toLowerCase();
        textLower = textLower.replace(' ', '_');
        return this.rechercheSimple(textLower);
    }

    private int rechercheSimple(String text) {
        int nbItems = this.myCombobox.getItemCount();
        int tailleTexte = text.length();
        int i = 0;
        while (i < nbItems) {
            int resultatcomparaison;
            String item = ((String)this.myCombobox.getItemAt(i)).toLowerCase();
            int tailleItem = item.length();
            if (tailleItem < tailleTexte) {
                String textSub = text.substring(0, tailleItem).replace(' ', '_');
                resultatcomparaison = this.compartor.compare(item, textSub);
                if (resultatcomparaison > 0) {
                    return i == 0 ? 0 : i - 1;
                }
            } else {
                String itemSub = item.substring(0, tailleTexte).replace(' ', '_');
                resultatcomparaison = this.compartor.compare(itemSub, text);
                if (resultatcomparaison == 0) {
                    return i;
                }
                if (resultatcomparaison == 1) {
                    return i == 0 ? 0 : i;
                }
            }
            ++i;
        }
        return -1;
    }

    private int rechercherText_complet(MyComboBoxAideSaisieBasic myCombobox, String text) {
        Vector resultat = new Vector();
        String textLower = text.toLowerCase();
        if (this.hashRecherche.containsKey(text.toLowerCase())) {
            resultat = (Vector)this.hashRecherche.get(text.toLowerCase());
        } else {
            Vector v = myCombobox.getElements();
            int nbItems = v.size();
            int i = 0;
            while (i < nbItems) {
                String item = (String)v.get(i);
                String itemLowerCase = item.toLowerCase();
                if (itemLowerCase.startsWith(text)) {
                    resultat.add(item);
                }
                ++i;
            }
            this.hashRecherche.put(text.toLowerCase(), resultat);
        }
        myCombobox.removeAllItems(false);
        int i = 0;
        while (i < resultat.size()) {
            myCombobox.addItem(resultat.get(i));
            ++i;
        }
        return resultat.size() > 0 ? 0 : -1;
    }

    private void rechercheMultiple(Vector resultat, String textLower, String item) {
        StringTokenizer stRecherche = new StringTokenizer(textLower, TOKENS);
        while (stRecherche.hasMoreTokens()) {
            String tokenRecherche = stRecherche.nextToken();
            int lgTokenRecherche = tokenRecherche.length();
            StringTokenizer st = new StringTokenizer(item.toLowerCase(), TOKENS);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (stRecherche.hasMoreTokens()) {
                    if (this.compartor.compare(token.toLowerCase(), tokenRecherche) != 0) continue;
                    break;
                }
                if (token.length() < lgTokenRecherche || this.compartor.compare(token.substring(0, lgTokenRecherche), tokenRecherche) != 0) continue;
                resultat.add(item);
                break;
            }
            if (!stRecherche.hasMoreTokens() || st.hasMoreTokens()) continue;
            return;
        }
    }

    private void rechercheSimple(Vector resultat, String textLower, String item) {
        StringTokenizer stRecherche = new StringTokenizer(textLower, TOKENS);
        block0: while (stRecherche.hasMoreTokens()) {
            String tokenRecherche = stRecherche.nextToken();
            int lgTokenRecherche = tokenRecherche.length();
            StringTokenizer st = new StringTokenizer(item.toLowerCase(), TOKENS);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.length() < lgTokenRecherche || this.compartor.compare(token.substring(0, lgTokenRecherche), tokenRecherche) != 0) continue;
                resultat.add(item);
                continue block0;
            }
        }
    }

    public Comparator getCompartor() {
        return this.compartor;
    }

    public void setCompartor(Comparator comparator) {
        this.compartor = comparator;
    }

    public void raz() {
        this.realTextEntered = "";
        this.hashRecherche.clear();
    }

    public void initialisation(Vector localites) {
        this.hashRecherche.put("", localites);
    }

    public void setRenderer(ComboboxRenderer renderer) {
        this.renderer = renderer;
    }

    public static void main(String[] args) {
        JComboBox<String> jcb = new JComboBox<String>();
        jcb.addItem("Foy");
        jcb.addItem("Fragolard");
        jcb.addItem("Franc Sanson");
        jcb.addItem("Franc-Sanson");
        System.out.println(MyKeyListenerAideSasieBasic.rechercherText_main(jcb, "fran"));
    }

    private static int rechercherText_main(JComboBox myCombobox, String text) {
        Collator compartor = CollatorFactory.create();
        int nbItems = myCombobox.getItemCount();
        int tailleTexte = text.length();
        int i = 0;
        while (i < nbItems) {
            int resultatcomparaison;
            String item = ((String)myCombobox.getItemAt(i)).toLowerCase();
            int tailleItem = item.length();
            if (tailleItem < tailleTexte) {
                String textSub = text.substring(0, tailleItem);
                resultatcomparaison = compartor.compare(item, textSub);
                System.out.println(String.valueOf(item) + ", " + textSub + " = " + resultatcomparaison);
                if (resultatcomparaison > 0) {
                    return i == 0 ? 0 : i - 1;
                }
            } else {
                String itemSub = item.substring(0, tailleTexte);
                resultatcomparaison = compartor.compare(itemSub, text);
                System.out.println(String.valueOf(itemSub) + ", " + text + " = " + resultatcomparaison);
                if (resultatcomparaison == 0) {
                    return i;
                }
                if (resultatcomparaison == 1) {
                    return i == 0 ? 0 : i - 1;
                }
            }
            ++i;
        }
        return -1;
    }

    private static void rechercheMultipleMain(Vector resultat, String textLower, String item) {
        StringTokenizer stRecherche = new StringTokenizer(textLower, TOKENS);
        while (stRecherche.hasMoreTokens()) {
            String tokenRecherche = stRecherche.nextToken();
            StringTokenizer st = new StringTokenizer(item.toLowerCase(), TOKENS);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (stRecherche.hasMoreTokens()) {
                    if (token.toLowerCase().compareTo(tokenRecherche) != 0) continue;
                    System.out.println("OK 1");
                    break;
                }
                if (!token.startsWith(tokenRecherche)) continue;
                resultat.add(item);
                break;
            }
            if (!stRecherche.hasMoreTokens() || st.hasMoreTokens()) continue;
            return;
        }
    }

    private class MyFocusListener
    implements FocusListener {
        private MyFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent arg0) {
            try {
                if (MyKeyListenerAideSasieBasic.this.myCombobox.getSelectedIndex() != -1) {
                    MyKeyListenerAideSasieBasic.this.jtfTextField.setSelectedTextColor(Color.red);
                    MyKeyListenerAideSasieBasic.this.jtfTextField.setSelectionStart(0);
                    MyKeyListenerAideSasieBasic.this.jtfTextField.setSelectionEnd(MyKeyListenerAideSasieBasic.this.realTextEntered.length());
                    MyKeyListenerAideSasieBasic.this.realTextEntered = "";
                    if (MyKeyListenerAideSasieBasic.this.renderer != null) {
                        MyKeyListenerAideSasieBasic.this.renderer.setTexteRecherche(MyKeyListenerAideSasieBasic.this.realTextEntered);
                    }
                }
            }
            catch (Exception e) {
                MyKeyListenerAideSasieBasic.this.realTextEntered = "";
            }
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            if (MyKeyListenerAideSasieBasic.this.myCombobox.getSelectedIndex() != -1) {
                ActionListener[] actionListeners = MyKeyListenerAideSasieBasic.this.myCombobox.getActionListeners();
                int i = 0;
                while (i < actionListeners.length) {
                    actionListeners[i].actionPerformed(new ActionEvent(MyKeyListenerAideSasieBasic.this.myCombobox, 0, "comboBoxSelectionTab"));
                    ++i;
                }
                MyKeyListenerAideSasieBasic.this.realTextEntered = (String)MyKeyListenerAideSasieBasic.this.myCombobox.getSelectedItem();
            }
        }
    }
}

