/*
 * Decompiled with CFR 0.152.
 */
package gls.ui.aidesaisie.comboboxrenderer;

import gls.comparator.CollatorFactory;
import gls.console.imp.ConsoleImp;
import gls.ui.aidesaisie.comboboxrenderer.ComboboxRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.Collator;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.apache.log4j.Logger;

public class ComboBoxAideRender
extends ConsoleImp
implements ListCellRenderer,
ComboboxRenderer {
    private static Logger cat1 = Logger.getLogger((String)"resura");
    private JComboBox combobox;
    private static String TOKENS = " -'";
    private static int TAILLE_PAR_DEFAUT = 25;
    int taille;
    private String texteRecherche = "";
    private Font font;

    public ComboBoxAideRender(int taille) {
        this.taille = taille;
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setBounds(0, 0, 0, 0);
    }

    public ComboBoxAideRender() {
        this(TAILLE_PAR_DEFAUT);
    }

    @Override
    public void setTexteRecherche(String texte) {
        this.texteRecherche = texte;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (value != null) {
            boolean trouve = false;
            String item = value.toString();
            String itemLowerCase = item.toLowerCase();
            Font f = this.font;
            if (this.texteRecherche.compareTo("") == 0) {
                this.setText("");
                this.append(item, Color.black, isSelected ? list.getSelectionBackground() : list.getBackground(), false);
                int lgItem = item.length();
                if (lgItem > this.taille) {
                    this.remove(lgItem - this.taille);
                }
            } else {
                String aRechercher;
                int indexChaine;
                StringTokenizer st = new StringTokenizer(this.texteRecherche.toLowerCase(), TOKENS);
                if (st.hasMoreTokens() && (indexChaine = this.rechercher(itemLowerCase, aRechercher = st.nextToken())) != -1) {
                    int lgItem = item.length();
                    this.setText("");
                    this.append(item.substring(0, indexChaine), Color.black, isSelected ? list.getSelectionBackground() : list.getBackground(), false);
                    this.setFont(new Font(f.getFamily(), 1, f.getSize()));
                    try {
                        this.append(item.substring(indexChaine, indexChaine + this.texteRecherche.length()), Color.black, isSelected ? list.getSelectionBackground() : list.getBackground(), true);
                    }
                    catch (Exception e) {
                        cat1.error((Object)"", (Throwable)e);
                    }
                    this.setFont(f);
                    try {
                        this.append(item.substring(indexChaine + this.texteRecherche.length(), item.length()), Color.black, isSelected ? list.getSelectionBackground() : list.getBackground(), false);
                    }
                    catch (Exception e) {
                        cat1.error((Object)"", (Throwable)e);
                    }
                    if (lgItem > this.taille) {
                        this.remove(lgItem - this.taille);
                    }
                }
            }
        }
        return this;
    }

    private int rechercher(String itemLowerCase, String aRechercher) {
        Collator c = CollatorFactory.create();
        int j = 0;
        int lg = itemLowerCase.length();
        int i = 0;
        while (i < lg) {
            if (c.compare(String.valueOf(aRechercher.charAt(j)), String.valueOf(itemLowerCase.charAt(i))) == 0) {
                if (++j == aRechercher.length()) {
                    return i - (j - 1);
                }
            } else {
                j = 0;
            }
            ++i;
        }
        return -1;
    }

    private static int rechercherstatic(String itemLowerCase, String aRechercher) {
        Collator c = CollatorFactory.create();
        int j = 0;
        int lg = itemLowerCase.length();
        int i = 0;
        while (i < lg) {
            if (c.compare(String.valueOf(aRechercher.charAt(j)), String.valueOf(itemLowerCase.charAt(i))) == 0) {
                if (++j == aRechercher.length()) {
                    return i - (j - 1);
                }
            } else {
                j = 0;
            }
            ++i;
        }
        return -1;
    }

    public static void main(String[] args) {
        System.out.println(ComboBoxAideRender.rechercherstatic("test", "te"));
        System.out.println(ComboBoxAideRender.rechercherstatic("test", "tea"));
        System.out.println(ComboBoxAideRender.rechercherstatic("test", "t\u00e9"));
        System.out.println(ComboBoxAideRender.rechercherstatic("t\u00e9st", "te"));
        System.out.println(ComboBoxAideRender.rechercherstatic("at\u00e9st", "te"));
        System.out.println(ComboBoxAideRender.rechercherstatic("azt\u00e9", "tea"));
        System.out.println(ComboBoxAideRender.rechercherstatic("azt\u00e9", "t\u00e8"));
        System.out.println(ComboBoxAideRender.rechercherstatic("B\u00e8gles", "be"));
    }

    @Override
    public void setIndex(int index) {
    }

    @Override
    public void noRender() {
    }

    @Override
    public void render() {
    }

    @Override
    public void setFont(Font f) {
        this.font = f;
        this.setFontSize(f.getSize());
    }
}

