/*
 * Decompiled with CFR 0.152.
 */
package gls.ui.Clavier;

import gls.outils.GLS;
import gls.outils.ui.GlsUI;
import gls.outils.ui.msgbox.MsgBox;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormatSymbols;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class JClavier
extends JPanel
implements ActionListener {
    private JButton[] jbTouchesNormales = new JButton[48];
    private JButton[] jbTouchesSpeciales = new JButton[9];
    private char[] symbolesNormales;
    private char[] symbolesMajuscules;
    private boolean majuscule = false;
    private boolean capsLock = false;
    private JButton jbFermer;
    private JButton jbValider;
    private JTextArea texte;
    private JPanel jpClavier;
    private JTextComponent textComponent;
    public static boolean ACTIVE;
    private static JClavier instance;
    private JFrame frame;

    public JFrame getFrame() {
        return this.frame;
    }

    public void setFrame(JFrame frame) {
        this.frame = frame;
    }

    protected JClavier() {
        ACTIVE = true;
        this.setLayout(new BorderLayout());
        this.jpClavier = new JPanel();
        this.jbFermer = new JButton("Fermer");
        this.jbFermer.addActionListener(this);
        this.jbValider = new JButton("Valider");
        this.jbValider.addActionListener(this);
        this.texte = new JTextArea();
        this.texte.setFont(new Font("Arial", 0, 18));
        this.texte.setBorder(BorderFactory.createLineBorder(Color.black));
        this.texte.setLineWrap(true);
        this.initialisationClassique();
        this.init();
        this.setButtonsSymboles();
        int i = 0;
        while (i < 48) {
            this.jbTouchesNormales[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aevt) {
                    JClavier.this.jbTouchesNormalesActionPerformed(aevt);
                }
            });
            ++i;
        }
        i = 0;
        while (i < 9) {
            this.jbTouchesSpeciales[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aevt) {
                    JClavier.this.jbTouchesSpecialesActionPerformed(aevt);
                }
            });
            ++i;
        }
        JPanel panneauHaut = new JPanel(new BorderLayout());
        JPanel panneauBoutons = new JPanel(new GridLayout(1, 2));
        panneauBoutons.add(this.jbFermer);
        panneauBoutons.add(this.jbValider);
        panneauHaut.add((Component)GlsUI.getScollPane(this.texte, GlsUI.TAILLE_ECRAN.width - 300, 50), "Center");
        panneauHaut.add((Component)panneauBoutons, "East");
        this.add((Component)panneauHaut, "North");
        this.add((Component)this.jpClavier, "Center");
    }

    public void initialisation() {
        this.textComponent = null;
    }

    public static JClavier instanceOf() {
        if (instance == null) {
            instance = new JClavier();
        }
        return instance;
    }

    public void initialisationClassique() {
        this.symbolesNormales = new char[48];
        this.symbolesNormales[0] = 49;
        this.symbolesNormales[1] = 50;
        this.symbolesNormales[2] = 51;
        this.symbolesNormales[3] = 52;
        this.symbolesNormales[4] = 53;
        this.symbolesNormales[5] = 54;
        this.symbolesNormales[6] = 55;
        this.symbolesNormales[7] = 56;
        this.symbolesNormales[8] = 57;
        this.symbolesNormales[9] = 48;
        this.symbolesNormales[10] = 176;
        this.symbolesNormales[11] = 43;
        this.symbolesNormales[12] = 97;
        this.symbolesNormales[13] = 122;
        this.symbolesNormales[14] = 101;
        this.symbolesNormales[15] = 114;
        this.symbolesNormales[16] = 116;
        this.symbolesNormales[17] = 121;
        this.symbolesNormales[18] = 117;
        this.symbolesNormales[19] = 105;
        this.symbolesNormales[20] = 111;
        this.symbolesNormales[21] = 112;
        this.symbolesNormales[22] = 94;
        this.symbolesNormales[23] = 36;
        this.symbolesNormales[24] = 113;
        this.symbolesNormales[25] = 115;
        this.symbolesNormales[26] = 100;
        this.symbolesNormales[27] = 102;
        this.symbolesNormales[28] = 103;
        this.symbolesNormales[29] = 104;
        this.symbolesNormales[30] = 106;
        this.symbolesNormales[31] = 107;
        this.symbolesNormales[32] = 108;
        this.symbolesNormales[33] = 109;
        this.symbolesNormales[34] = 249;
        this.symbolesNormales[35] = 119;
        this.symbolesNormales[36] = 120;
        this.symbolesNormales[37] = 99;
        this.symbolesNormales[38] = 118;
        this.symbolesNormales[39] = 98;
        this.symbolesNormales[40] = 110;
        this.symbolesNormales[41] = 44;
        this.symbolesNormales[42] = 59;
        this.symbolesNormales[43] = 58;
        this.symbolesNormales[44] = 33;
        this.symbolesNormales[45] = 60;
        this.symbolesNormales[46] = 181;
        this.symbolesNormales[47] = 178;
        this.symbolesMajuscules = new char[48];
        this.symbolesMajuscules[0] = 38;
        this.symbolesMajuscules[1] = 233;
        this.symbolesMajuscules[2] = 187;
        this.symbolesMajuscules[3] = 39;
        this.symbolesMajuscules[4] = 40;
        this.symbolesMajuscules[5] = 45;
        this.symbolesMajuscules[6] = 232;
        this.symbolesMajuscules[7] = 95;
        this.symbolesMajuscules[8] = 231;
        this.symbolesMajuscules[9] = 224;
        this.symbolesMajuscules[10] = 41;
        this.symbolesMajuscules[11] = 61;
        this.symbolesMajuscules[12] = 65;
        this.symbolesMajuscules[13] = 90;
        this.symbolesMajuscules[14] = 69;
        this.symbolesMajuscules[15] = 82;
        this.symbolesMajuscules[16] = 84;
        this.symbolesMajuscules[17] = 89;
        this.symbolesMajuscules[18] = 85;
        this.symbolesMajuscules[19] = 73;
        this.symbolesMajuscules[20] = 79;
        this.symbolesMajuscules[21] = 80;
        this.symbolesMajuscules[22] = 168;
        this.symbolesMajuscules[23] = 163;
        this.symbolesMajuscules[24] = 81;
        this.symbolesMajuscules[25] = 83;
        this.symbolesMajuscules[26] = 68;
        this.symbolesMajuscules[27] = 70;
        this.symbolesMajuscules[28] = 71;
        this.symbolesMajuscules[29] = 72;
        this.symbolesMajuscules[30] = 74;
        this.symbolesMajuscules[31] = 75;
        this.symbolesMajuscules[32] = 76;
        this.symbolesMajuscules[33] = 77;
        this.symbolesMajuscules[34] = 37;
        this.symbolesMajuscules[35] = 87;
        this.symbolesMajuscules[36] = 88;
        this.symbolesMajuscules[37] = 67;
        this.symbolesMajuscules[38] = 86;
        this.symbolesMajuscules[39] = 66;
        this.symbolesMajuscules[40] = 78;
        this.symbolesMajuscules[41] = 63;
        this.symbolesMajuscules[42] = 46;
        this.symbolesMajuscules[43] = 47;
        this.symbolesMajuscules[44] = 167;
        this.symbolesMajuscules[45] = 62;
        this.symbolesMajuscules[46] = 42;
        this.symbolesMajuscules[47] = 34;
    }

    private void setButtonsSymboles() {
        if (!this.capsLock && this.majuscule || this.capsLock && !this.majuscule) {
            int i = 0;
            while (i < 48) {
                this.jbTouchesNormales[i].setText("" + this.symbolesMajuscules[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < 48) {
                this.jbTouchesNormales[i].setText("" + this.symbolesNormales[i]);
                ++i;
            }
        }
    }

    public void majUIClavier(Font font) {
        int i = 0;
        while (i < 48) {
            this.jbTouchesNormales[i].setFont(new Font("Arial", 1, 22));
            this.jbTouchesNormales[i].setBackground(Color.white);
            ++i;
        }
        i = 0;
        while (i < 9) {
            this.jbTouchesSpeciales[i].setFont(new Font("Arial", 1, 12));
            this.jbTouchesSpeciales[i].setText(GLS.getLibelleComposantPlusieursLigne(this.jbTouchesSpeciales[i].getText()));
            this.jbTouchesSpeciales[i].setBackground(Color.white);
            ++i;
        }
    }

    private void erstellSymbBtn(int i, GridBagLayout meinGBL, GridBagConstraints meinGBC) {
        this.jbTouchesNormales[i] = new JButton(" ");
        this.jbTouchesNormales[i].setMinimumSize(new Dimension(56, 56));
        this.jbTouchesNormales[i].setPreferredSize(new Dimension(56, 56));
        meinGBL.setConstraints(this.jbTouchesNormales[i], meinGBC);
        this.jpClavier.add(this.jbTouchesNormales[i]);
    }

    private void erstellAnderBtn(int i, String meinName, GridBagLayout meinGBL, GridBagConstraints meinGBC, Dimension preferredSize) {
        this.jbTouchesSpeciales[i] = new JButton(meinName);
        this.jbTouchesSpeciales[i].setMinimumSize(new Dimension(56, 56));
        this.jbTouchesSpeciales[i].setPreferredSize(preferredSize);
        meinGBL.setConstraints(this.jbTouchesSpeciales[i], meinGBC);
        this.jpClavier.add(this.jbTouchesSpeciales[i]);
    }

    private void jbTouchesNormalesActionPerformed(ActionEvent aevt) {
        int i = 0;
        while (i < 48) {
            if (this.getToucheNormal(i).equals(aevt.getActionCommand()) | this.getToucheMajuscule(i).equals(aevt.getActionCommand())) {
                this.addSymbolInComponent(i);
                if (!this.majuscule || this.capsLock) break;
                this.shiftDruecken();
                break;
            }
            ++i;
        }
    }

    private void init() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.jpClavier.setLayout(gbl);
        int i = 0;
        while (i < 12) {
            this.erstellSymbBtn(i, gbl, gbc);
            ++i;
        }
        gbc.gridwidth = 0;
        this.erstellAnderBtn(0, "Del", gbl, gbc, new Dimension(60, 56));
        gbc.gridwidth = 1;
        this.erstellAnderBtn(1, "Tab", gbl, gbc, new Dimension(60, 56));
        i = 12;
        while (i < 24) {
            this.erstellSymbBtn(i, gbl, gbc);
            ++i;
        }
        gbc.gridwidth = 0;
        this.erstellAnderBtn(2, "Suppr", gbl, gbc, new Dimension(56, 56));
        gbc.gridwidth = 1;
        this.erstellAnderBtn(3, "Caps", gbl, gbc, new Dimension(60, 56));
        i = 24;
        while (i < 35) {
            this.erstellSymbBtn(i, gbl, gbc);
            ++i;
        }
        gbc.gridwidth = 2;
        gbc.gridwidth = 0;
        this.erstellAnderBtn(4, "Entr\u00e9e", gbl, gbc, new Dimension(112, 56));
        gbc.gridwidth = 2;
        this.erstellAnderBtn(5, "Shift", gbl, gbc, new Dimension(60, 56));
        gbc.gridwidth = 1;
        i = 35;
        while (i < 45) {
            this.erstellSymbBtn(i, gbl, gbc);
            ++i;
        }
        gbc.gridwidth = 2;
        gbc.gridwidth = 0;
        this.erstellAnderBtn(6, "Shift", gbl, gbc, new Dimension(60, 56));
        gbc.gridwidth = 2;
        this.erstellAnderBtn(7, "Copy", gbl, gbc, new Dimension(56, 56));
        gbc.gridwidth = 1;
        this.erstellSymbBtn(45, gbl, gbc);
        gbc.gridwidth = 8;
        this.erstellAnderBtn(8, "Espace", gbl, gbc, new Dimension(150, 56));
        gbc.gridwidth = 1;
        i = 46;
        while (i < 48) {
            this.erstellSymbBtn(i, gbl, gbc);
            ++i;
        }
    }

    private void addSymbolInComponent(int i) {
        this.addSymbolInComponent(i, this.getTextComponent());
    }

    private void addSymbolInComponent(int i, JTextComponent textComponent) {
        if (this.majuscule ^ this.capsLock) {
            this.addText(this.getToucheMajuscule(i));
        } else {
            this.addText(this.getToucheNormal(i));
        }
    }

    private void addText(String caractere) {
        this.texte.insert(caractere, this.texte.getCaretPosition());
        this.texte.requestFocus();
    }

    private void setText(String texte) {
        this.texte.setText(texte);
    }

    private String getToucheNormal(int i) {
        return "" + this.symbolesNormales[i];
    }

    private String getToucheMajuscule(int i) {
        return "" + this.symbolesMajuscules[i];
    }

    private void jbTouchesSpecialesActionPerformed(ActionEvent aevt) {
        this.jbTouchesSpecialesActionPerformed(aevt, this.getTextComponent());
    }

    private void jbTouchesSpecialesActionPerformed(ActionEvent aevt, JTextComponent textComponent) {
        Object command = aevt.getSource();
        if (aevt.getSource() == this.jbTouchesSpeciales[0]) {
            this.mnuBearbeitenLoeschen();
        } else if (aevt.getSource() == this.jbTouchesSpeciales[1]) {
            this.setText(String.valueOf(textComponent.getText()) + "\t");
        } else if (aevt.getSource() == this.jbTouchesSpeciales[2]) {
            this.mnuBearbeitenEntfernen();
        } else if (aevt.getSource() == this.jbTouchesSpeciales[3]) {
            this.capsDruecken();
        } else if (aevt.getSource() == this.jbTouchesSpeciales[4]) {
            this.setText(String.valueOf(textComponent.getText()) + "\n");
        } else if (aevt.getSource() == this.jbTouchesSpeciales[5]) {
            this.shiftDruecken();
        } else if (aevt.getSource() == this.jbTouchesSpeciales[6]) {
            this.shiftDruecken();
        } else if (aevt.getSource() == this.jbTouchesSpeciales[7]) {
            this.mnuBearbeitenKopieren();
        } else if (aevt.getSource() == this.jbTouchesSpeciales[8]) {
            this.setText(String.valueOf(textComponent.getText()) + " ");
        }
        this.texte.requestFocus();
    }

    private void mnuBearbeitenLoeschen() {
        this.mnuBearbeitenLoeschen(this.getTextComponent());
    }

    private void mnuBearbeitenLoeschen(JTextComponent textComponent) {
        if (textComponent.getSelectedText() == null || textComponent.getSelectedText().equals("")) {
            textComponent.select(textComponent.getCaretPosition() - 1, textComponent.getCaretPosition());
            textComponent.replaceSelection("");
        } else {
            textComponent.replaceSelection("");
        }
    }

    private void mnuBearbeitenEntfernen() {
        this.mnuBearbeitenEntfernen(this.getTextComponent());
    }

    private void mnuBearbeitenEntfernen(JTextComponent textComponent) {
        if (textComponent.getSelectedText() == null) {
            textComponent.select(textComponent.getCaretPosition(), textComponent.getCaretPosition() + 1);
        }
        textComponent.replaceSelection("");
    }

    private void mnuBearbeitenKopieren() {
    }

    private void capsDruecken() {
        if (!this.capsLock) {
            this.capsLock = true;
            this.jbTouchesSpeciales[3].setBackground(new Color(165, 165, 165));
        } else {
            this.capsLock = false;
            this.jbTouchesSpeciales[3].setBackground(new Color(204, 204, 204));
        }
        this.setButtonsSymboles();
    }

    private void shiftDruecken() {
        if (!this.majuscule) {
            this.majuscule = true;
            this.jbTouchesSpeciales[5].setBackground(new Color(165, 165, 165));
            this.jbTouchesSpeciales[6].setBackground(new Color(165, 165, 165));
        } else {
            this.majuscule = false;
            this.jbTouchesSpeciales[5].setBackground(new Color(204, 204, 204));
            this.jbTouchesSpeciales[6].setBackground(new Color(204, 204, 204));
        }
        this.setButtonsSymboles();
    }

    public static void main(String[] args) {
        JFrame fenetre2 = new JFrame();
        JTextField text = new JTextField();
        fenetre2.getContentPane().add(text);
        JClavier.instanceOf().setTextComponent(text);
        JClavier.instanceOf().setVisible(true);
        fenetre2.setVisible(true);
    }

    public void fermer() {
        if (this.isVisible()) {
            this.setVisible(false);
            this.actionApresFermeture();
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg) {
        if (arg.getSource() == this.jbFermer) {
            this.fermer();
        } else if (arg.getSource() == this.jbValider) {
            if (this.textComponent instanceof JFormattedTextField) {
                JFormattedTextField jft = (JFormattedTextField)this.textComponent;
                char separateur = DecimalFormatSymbols.getInstance().getDecimalSeparator();
                String v = this.texte.getText();
                if (separateur == '.') {
                    v = v.replace(',', separateur);
                } else if (separateur == ',') {
                    v = v.replace('.', separateur);
                }
                try {
                    Object value = jft.getFormatter().stringToValue(v);
                    jft.setValue(value);
                }
                catch (Exception e) {
                    String value = "";
                    e.printStackTrace();
                    MsgBox.afficherErreur("La valeur n'est pas valide");
                }
            } else {
                this.textComponent.setText(this.texte.getText());
            }
            this.setVisible(false);
            this.actionApresFermeture();
        }
    }

    public void simulateEnter(Component c) {
        Robot m_robot;
        try {
            m_robot = new Robot();
        }
        catch (AWTException ex) {
            m_robot = null;
        }
        if (m_robot != null) {
            c.requestFocus();
            m_robot.keyPress(10);
        }
    }

    public void actionApresFermeture() {
        if (this.frame != null) {
            this.frame.repaint();
        }
    }

    public JTextComponent getTextComponent() {
        return this.texte;
    }

    public void setTextComponent(JTextComponent component) {
        this.textComponent = component;
        this.texte.setText(this.textComponent.getText());
    }
}

