/*
 * Decompiled with CFR 0.152.
 */
package gls.referentiel;

import cartoj.Enregistrement;
import cartoj.ICouche;
import gls.geometry.GeoPositionnement;
import gls.localisation.InfoTroncon;
import gls.localisation.Localisation;
import gls.localisation.LocalisationInfo;
import gls.localisation.distance.DistanceInfo;
import gls.localisation.plo.GestionPlo;
import gls.localisation.pr.GestionPr;
import gls.localisation.pr.LocalisantPr;
import gls.localisation.recherche.Recherche;
import gls.outils.CSV;
import gls.outils.GLS;
import gls.outils.fichier.Fichier;
import gls.outils.fichier.MonFichier;
import gls.referentiel.CartoReferentiel;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Referentiel {
    private static final Logger log = Logger.getLogger(Referentiel.class);
    protected CartoReferentiel carto;
    protected MonFichier rapport;
    protected MonFichier rapportErreurCSV;
    protected MonFichier rapportCorrectionCSV;
    protected MonFichier rapportAjoutCSV;
    protected int nbPointBaionnette;
    protected int nbPrRepositionne;
    protected int iSectionCourante;
    protected boolean reinitialiserBaionnette;
    protected String nomRouteCourante;
    public static int DISTANCE_MAX_REPOSITIONNEMENT_PR_DEBUT = 21;
    public static int DISTANCE_MAX_TOLERENCE_PB_DEBUT = 21;
    public static int DISTANCE_MAX_REPOSITIONNEMENT_PR_0 = DISTANCE_MAX_REPOSITIONNEMENT_PR_DEBUT;
    public static final String[] ENTETE_RAPPORT_CSV = new String[]{"RD", "N\u00b0 SECTION", "PR DEBUT", "PR FIN", "COMMENTAIRE"};
    public static final String[] ENTETE_AJOUT_CSV = new String[]{"RD", "PRD", "ABD"};
    public static final String NOM_FICHIER_RAPPORT_ERREUR_CSV = "rapportErreurReferentiel.csv";
    public static final String NOM_FICHIER_RAPPORT_CORRECTION_CSV = "rapportCorrectionReferentiel.csv";
    public static final String NOM_FICHIER_RAPPORT_TEXTE = "rapportVerificationReferentiel.txt";
    public static final String NOM_FICHIER_RAPPORT_AJOUT_PB = "rapportAjoutPb.csv";

    public Referentiel(CartoReferentiel carto, String cheminFichierRapport, boolean reinitialiserBaionnette) throws Exception {
        this.carto = carto;
        this.reinitialiserBaionnette = reinitialiserBaionnette;
        if (!GLS.estVide(cheminFichierRapport)) {
            String repertoire = Fichier.getRepertoire(cheminFichierRapport);
            try {
                Fichier.effacerFichier(repertoire.concat(NOM_FICHIER_RAPPORT_ERREUR_CSV));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Fichier.effacerFichier(repertoire.concat(NOM_FICHIER_RAPPORT_CORRECTION_CSV));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Fichier.effacerFichier(repertoire.concat(NOM_FICHIER_RAPPORT_TEXTE));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Fichier.effacerFichier(repertoire.concat(NOM_FICHIER_RAPPORT_AJOUT_PB));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.rapport = new MonFichier(repertoire.concat(NOM_FICHIER_RAPPORT_TEXTE), 1);
            this.rapportErreurCSV = new MonFichier(repertoire.concat(NOM_FICHIER_RAPPORT_ERREUR_CSV), 1);
            this.rapportCorrectionCSV = new MonFichier(repertoire.concat(NOM_FICHIER_RAPPORT_CORRECTION_CSV), 1);
            this.rapportAjoutCSV = new MonFichier(repertoire.concat(NOM_FICHIER_RAPPORT_AJOUT_PB), 1);
            this.rapportErreurCSV.ecrire(this.getLigneCSV(ENTETE_RAPPORT_CSV));
            this.rapportCorrectionCSV.ecrire(this.getLigneCSV(ENTETE_RAPPORT_CSV));
            this.rapportAjoutCSV.ecrire(this.getLigneCSV(ENTETE_AJOUT_CSV));
        } else {
            this.rapport = null;
            this.rapportErreurCSV = null;
            this.rapportCorrectionCSV = null;
            this.rapportAjoutCSV = null;
        }
    }

    public Referentiel(String cheminCarto, String nomCarto, String cheminFichierRapport) throws Exception {
        this(new CartoReferentiel(cheminCarto, nomCarto), cheminFichierRapport, false);
    }

    public Referentiel(String cheminCarto, String nomCarto, String cheminFichierRapport, boolean reinitialiserBaionnette) throws Exception {
        this(new CartoReferentiel(cheminCarto, nomCarto), cheminFichierRapport, reinitialiserBaionnette);
    }

    protected void ecrireRapport(String ligne) {
        log.debug((Object)ligne);
        if (this.rapport != null) {
            try {
                this.rapport.ecrire(String.valueOf(ligne) + "\n");
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
    }

    protected void ecrireRapportCorrectionCSV(String correction) {
        try {
            this.ecrireRapportCorrectionCSV(this.carto.getLocalisationCourante(false), correction);
        }
        catch (Exception e) {
            log.error((Object)"ERREUR GET LOCALISATION CORRECTION CSV", (Throwable)e);
        }
    }

    protected void ecrireRapportErreurCSV(String erreur) {
        try {
            this.ecrireRapportErreurCSV(this.carto.getLocalisationCourante(false), erreur);
        }
        catch (Exception e) {
            log.error((Object)"ERREUR GET LOCALISATION ERREUR CSV", (Throwable)e);
        }
    }

    protected void ecrireRapportErreurCSV(Localisation localisation, String erreur) {
        if (this.rapportErreurCSV != null) {
            String[] nouvelleLigne = this.getNouvelleLigneRapportLocalisation(localisation);
            nouvelleLigne[4] = erreur;
            try {
                this.rapportErreurCSV.ecrire(this.getLigneCSV(nouvelleLigne));
            }
            catch (Exception e) {
                log.error((Object)"ERREUR ECRITURE FICHIER CSV ERREUR", (Throwable)e);
            }
        }
    }

    protected void ecrireRapportAjoutCSV(LocalisantPr pr, String route) {
        if (this.rapportAjoutCSV != null) {
            String[] nouvelleLigne = this.getNouvelleLigneRapportAjout(route, pr);
            try {
                this.rapportAjoutCSV.ecrire(this.getLigneCSV(nouvelleLigne));
            }
            catch (Exception e) {
                log.error((Object)"ERREUR ECRITURE FICHIER AJOUT CSV ERREUR", (Throwable)e);
            }
        }
    }

    protected void ecrireRapportCorrectionCSV(Localisation localisation, String correction) {
        if (this.rapportCorrectionCSV != null) {
            String[] nouvelleLigne = this.getNouvelleLigneRapportLocalisation(localisation);
            nouvelleLigne[4] = correction;
            try {
                this.rapportCorrectionCSV.ecrire(this.getLigneCSV(nouvelleLigne));
            }
            catch (Exception e) {
                log.error((Object)"ERREUR ECRITURE FICHIER CSV CORRECTION", (Throwable)e);
            }
        }
    }

    private String getLigneCSV(String[] ligne) {
        String ligneCSV = "";
        ligneCSV = String.valueOf(ligneCSV) + CSV.toCSV(ligne[0]);
        int i = 1;
        while (i < ligne.length) {
            ligneCSV = String.valueOf(ligneCSV) + CSV.ajouterChampCSV(ligne[i]);
            ++i;
        }
        return ligneCSV.concat("\n");
    }

    private String[] getNouvelleLigneRapportCSV() {
        return new String[ENTETE_RAPPORT_CSV.length];
    }

    private String[] getNouvelleLigneAjoutCSV() {
        return new String[ENTETE_AJOUT_CSV.length];
    }

    private String[] getNouvelleLigneRapportAjout(String route, LocalisantPr pr) {
        String[] nouvelleLigne = this.getNouvelleLigneAjoutCSV();
        nouvelleLigne[0] = this.nomRouteCourante;
        nouvelleLigne[1] = GLS.getString(pr.getEntitePr().getPr());
        nouvelleLigne[2] = GLS.getString(pr.getEntitePr().getAbscisse());
        return nouvelleLigne;
    }

    private String[] getNouvelleLigneRapportLocalisation(Localisation localisation) {
        String[] nouvelleLigne = this.getNouvelleLigneRapportCSV();
        nouvelleLigne[0] = this.nomRouteCourante;
        nouvelleLigne[1] = GLS.getString(this.iSectionCourante);
        if (localisation != null) {
            try {
                nouvelleLigne[2] = localisation.getTri().getPrMin().getEntitePr().toString(true, false);
                nouvelleLigne[3] = localisation.getTri().getPrMax().getEntitePr().toString(true, false);
            }
            catch (Exception e) {
                log.error((Object)"ERREUR GENERATION LIGNE PR CSV", (Throwable)e);
                nouvelleLigne[2] = "";
                nouvelleLigne[3] = "";
            }
        } else {
            nouvelleLigne[2] = "";
            nouvelleLigne[3] = "";
        }
        nouvelleLigne[4] = "";
        return nouvelleLigne;
    }

    public static Vector<String> getRoutesTriees(Vector<String> array) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String elt : array) {
            map.put(Referentiel.getNumRD(elt), elt);
        }
        Iterator it = map.values().iterator();
        Vector<String> eltTrie = new Vector<String>();
        while (it.hasNext()) {
            eltTrie.add((String)it.next());
        }
        return eltTrie;
    }

    public static String getNumRD(String rd) {
        if (rd.length() >= 2 && GLS.egal(String.valueOf(rd.charAt(0)), "D") && GLS.estNumerique(rd.charAt(1))) {
            String tmp = "";
            String tmpNumRd = "";
            String tmpFinRd = "";
            int i = 1;
            boolean fin = false;
            boolean finNumerique = false;
            NumberFormat nf = NumberFormat.getIntegerInstance();
            nf.setMinimumIntegerDigits(4);
            nf.setMaximumFractionDigits(0);
            nf.setGroupingUsed(false);
            tmp = String.valueOf(rd.charAt(0));
            while (!fin) {
                char c = rd.charAt(i++);
                if (!finNumerique && GLS.estNumerique(c)) {
                    tmpNumRd = String.valueOf(tmpNumRd) + c;
                } else {
                    tmpFinRd = String.valueOf(tmpFinRd) + c;
                    finNumerique = true;
                }
                boolean bl = fin = i >= rd.length();
            }
            tmp = tmp.concat(nf.format(GLS.getDouble(tmpNumRd)).concat(tmpFinRd));
            return tmp;
        }
        return rd;
    }

    public static Vector<String> getRoutes(ICouche coucheRoute) {
        String[] nomRoutes;
        Vector<String> listeRoutes = new Vector<String>();
        if (coucheRoute != null && !GLS.estVide(nomRoutes = coucheRoute.getDon().getColonne(1).getValeursToString())) {
            String[] stringArray = nomRoutes;
            int n = nomRoutes.length;
            int n2 = 0;
            while (n2 < n) {
                String nomRoute = stringArray[n2];
                if (!GLS.estDansLaListe(listeRoutes, (Object)nomRoute)) {
                    listeRoutes.add(nomRoute);
                }
                ++n2;
            }
        }
        return listeRoutes;
    }

    public void verifierSectionRouteCourante(MonFichier rapport) throws Exception {
        this.verifierSectionRoute(this.carto.getLocalisationCourante(), rapport);
    }

    public void verifierSectionRoute(Localisation localisation, MonFichier rapport) throws Exception {
        LocalisantPr prMax = this.carto.getTri().getPrMax();
        LocalisantPr prMin = this.carto.getTri().getPrMin();
        int nbPr = localisation.getTri().getNbPr();
        boolean erreurContinuite = prMax.getPr() != prMin.getPr() + (nbPr - 1);
        this.ecrireRapport("SECTION DU PR " + prMin.getEntitePr().toString(true, false) + " AU PR " + prMax.getEntitePr().toString(true, false) + " - NB PR " + nbPr + " - NB TRONCONS " + localisation.getTri().getNbTroncons());
        if (nbPr == 0) {
            throw new Exception("SECTION ERREUR - AUCUN PR");
        }
        if (nbPr == 1) {
            this.ecrireRapport("SECTION ALERTE - SECTION A UN PR");
        } else {
            if (prMin.equals(prMax)) {
                throw new Exception("SECTION ERREUR - LES PR DE DEBUT ET DE FIN SONT LES MEMES");
            }
            if (prMin.estApres(prMax)) {
                throw new Exception("SECTION ERREUR - LE PR DE FIN DE SECTION EST AVANT LE PR DE DEBUT DE SECTION");
            }
            if (erreurContinuite) {
                this.ecrireRapport("SECTION ALERTE - VERIFIEZ LA CONTINUITE DES PR - NB PR " + nbPr + " - PR DEBUT " + prMin.getEntitePr().toString(true, false) + " - PR FIN " + prMax.getEntitePr().toString(true, false) + " - REGLE (MAX_PR_SECTION != (MIN_PR_SECTION + (NB_PR_SECTION - 1)))");
                this.ecrireRapportErreurCSV("SECTION ALERTE - VERIFIEZ LA CONTINUITE DES PR - NB PR " + nbPr + " - PR DEBUT " + prMin.getEntitePr().toString(true, false) + " - PR FIN " + prMax.getEntitePr().toString(true, false));
            }
        }
    }

    public void verificationPrDebut(Localisation localisation, LocalisantPr dernierPrSectionPrecedente) {
        this.verificationPrDebut(localisation, dernierPrSectionPrecedente, true);
    }

    public void verificationPrDebut(Localisation localisation, LocalisantPr dernierPrSectionPrecedente, boolean reverification) {
        LocalisantPr prDebut;
        try {
            prDebut = localisation.getTri().getPremierTroncon().getPrDebut();
        }
        catch (Exception e) {
            prDebut = null;
            log.error((Object)"ERREUR AUCUN PR DEBUT", (Throwable)e);
        }
        if (localisation.getTri().getNbPr() == 1 && !localisation.getTri().aPrDebut() && localisation.getTri().aPrFin()) {
            try {
                localisation.getSens().changer();
            }
            catch (Exception e) {
                this.ecrireRapport("ERREUR CHANGEMENT SENS ROUTE A 1 PR");
            }
        }
        if (prDebut == null) {
            if (reverification) {
                InfoTroncon premierTronconPr;
                this.ecrireRapport("SECTION ALERTE - LA SECTION N'A PAS DE PR EN DEBUT");
                try {
                    premierTronconPr = localisation.getTri().getPremierTronconPr();
                }
                catch (Exception e) {
                    premierTronconPr = null;
                    this.ecrireRapport("SECTION ERREUR - LA SECTION N'A AUCUN PR");
                }
                if (premierTronconPr != null) {
                    LocalisantPr prMin = premierTronconPr.getPrMin();
                    if (prMin.getPr() != 0) {
                        DistanceInfo distancePr = GestionPr.getDistanceInterPrPrecedent(localisation.getTriRoute(), prMin);
                        if (distancePr.getDistance() <= DISTANCE_MAX_REPOSITIONNEMENT_PR_DEBUT) {
                            this.deplacerPrAuDebut(localisation, premierTronconPr, prMin, distancePr.getDistance());
                        } else {
                            this.generePointBaionnette(localisation, prMin, dernierPrSectionPrecedente);
                        }
                    } else if (localisation.getTri().getNbPr() == 1) {
                        if (localisation.getTri().getDistanceDebut() < localisation.getTri().getDistanceFin()) {
                            this.deplacerPrAuDebut(localisation, premierTronconPr, prMin, localisation.getTri().getDistanceDebut());
                        } else {
                            this.deplacerPrEnFin(localisation, premierTronconPr, prMin, localisation.getTri().getDistanceFin());
                        }
                    } else {
                        DistanceInfo distancePr = GestionPr.getDistanceInterPrPrecedent(localisation.getTriRoute(), prMin);
                        if (distancePr.getDistance() <= DISTANCE_MAX_REPOSITIONNEMENT_PR_0) {
                            this.deplacerPrAuDebut(localisation, premierTronconPr, prMin, distancePr.getDistance());
                        } else {
                            this.ecrireRapport("SECTION ERREUR - LE PR DE DEBUT DE SECTION (" + prMin.toString(false) + ") EST TROP ELOIGNE POUR ETRE DEPLACE EN DEBUT DE SECTION (" + distancePr.getDistance() + " > " + DISTANCE_MAX_REPOSITIONNEMENT_PR_DEBUT + ")" + " - VEUILLEZ VERIFIER VOTRE REFERENTIEL");
                            this.ecrireRapportErreurCSV("SECTION ERREUR - LE PR DE DEBUT DE SECTION (" + prMin.toString(false) + ") EST TROP ELOIGNE POUR ETRE DEPLACE EN DEBUT DE SECTION (" + distancePr.getDistance() + " > " + DISTANCE_MAX_REPOSITIONNEMENT_PR_DEBUT + ")" + " - VEUILLEZ VERIFIER VOTRE REFERENTIEL");
                        }
                    }
                    if (reverification) {
                        this.verificationPrDebut(localisation, dernierPrSectionPrecedente, false);
                    }
                }
            } else if (localisation.getTri().getNbPr() > 1) {
                this.ecrireRapport("SECTION ERREUR - REVERIFICATION - CORRECTION DU REFERENTIEL IMPOSSIBLE");
                this.ecrireRapportErreurCSV("SECTION ERREUR - REVERIFICATION - CORRECTION DU REFERENTIEL IMPOSSIBLE");
            } else {
                this.ecrireRapport("SECTION ALERTE - REVERIFICATION - SECTION A UN SEUL PR");
                this.ecrireRapportErreurCSV("SECTION ALERTE - REVERIFICATION - SECTION A UN SEUL PR");
            }
        } else if (!prDebut.estBaionnette()) {
            this.ecrireRapport("SECTION ALERTE - Attention le premier pr n'est pas baionnette - PR(" + prDebut.getEntitePr().toString(true) + ")+" + prDebut.getDistancePr());
        } else if (dernierPrSectionPrecedente != null) {
            if (prDebut.getPr() == dernierPrSectionPrecedente.getPr()) {
                if (prDebut.getEntitePr().getAbscisse() == dernierPrSectionPrecedente.getEntitePr().getAbscisse()) {
                    this.ecrireRapport("Le troncon a d\u00e9j\u00e0 un point baionnette valide");
                } else if (Math.abs(prDebut.getEntitePr().getAbscisse() - dernierPrSectionPrecedente.getEntitePr().getAbscisse()) <= DISTANCE_MAX_TOLERENCE_PB_DEBUT) {
                    this.ecrireRapport("SECTION ALERTE - Le troncon a un point baionnette valide mais la longueur calcul\u00e9e est diff\u00e9rente mais tol\u00e9rable - N\u00b0Borne " + prDebut.getEntitePr().toString(false, false) + " - seuil tol\u00e9rence = " + DISTANCE_MAX_TOLERENCE_PB_DEBUT + "m - longueur PB calcul\u00e9e = " + dernierPrSectionPrecedente.getEntitePr().getAbscisse() + "m - longueur PB fourni = " + prDebut.getEntitePr().getAbscisse() + "m");
                    this.ecrireRapportCorrectionCSV("Deplacement du PB - Le troncon a un point baionnette valide mais la longueur calcul\u00e9e est diff\u00e9rente mais tol\u00e9rable - N\u00b0Borne " + prDebut.getEntitePr().toString(false, false) + " - seuil tol\u00e9rence = " + DISTANCE_MAX_TOLERENCE_PB_DEBUT + "m - longueur PB calcul\u00e9e = " + dernierPrSectionPrecedente.getEntitePr().getAbscisse() + "m - longueur PB fourni = " + prDebut.getEntitePr().getAbscisse() + "m");
                    this.generePointBaionnette(localisation, prDebut, dernierPrSectionPrecedente);
                } else {
                    this.ecrireRapport("SECTION ERREUR - Le troncon a un point baionnette valide mais la longueur calcul\u00e9e est sup\u00e9rieure au seuil de tol\u00e9rence - N\u00b0Borne " + prDebut.getEntitePr().toString(false, false) + " - seuil tol\u00e9rence = " + DISTANCE_MAX_TOLERENCE_PB_DEBUT + "m - longueur PB calcul\u00e9e = " + dernierPrSectionPrecedente.getEntitePr().getAbscisse() + "m - longueur PB fourni = " + prDebut.getEntitePr().getAbscisse() + "m");
                    this.ecrireRapportErreurCSV("SECTION ERREUR - Le troncon a un point baionnette valide mais la longueur calcul\u00e9e est sup\u00e9rieure au seuil de tol\u00e9rence - N\u00b0Borne " + prDebut.getEntitePr().toString(false, false) + " - seuil tol\u00e9rence = " + DISTANCE_MAX_TOLERENCE_PB_DEBUT + "m - longueur PB calcul\u00e9e = " + dernierPrSectionPrecedente.getEntitePr().getAbscisse() + "m - longueur PB fourni = " + prDebut.getEntitePr().getAbscisse() + "m");
                }
            } else if (!this.aPrSuivantConsecutif(localisation, prDebut)) {
                this.ecrireRapport("SECTION ERREUR - Le troncon a un point baionnette non valide car il n'a pas le bon num\u00e9ro de borne - N\u00b0Borne PB " + prDebut.getEntitePr().toString(false, false) + " - N\u00b0Borne requis " + dernierPrSectionPrecedente.getEntitePr().toString(false, false));
                this.ecrireRapportErreurCSV("SECTION ERREUR - Le troncon a un point baionnette non valide car il n'a pas le bon num\u00e9ro de borne - N\u00b0Borne PB " + prDebut.getEntitePr().toString(false, false) + " - N\u00b0Borne requis " + dernierPrSectionPrecedente.getEntitePr().toString(false, false));
            } else {
                this.ecrireRapport("Le troncon a d\u00e9j\u00e0 un point baionnette valide (NON CONSECUTIF)");
            }
        } else {
            this.ecrireRapport("Le troncon a d\u00e9j\u00e0 un point baionnette valide");
        }
    }

    private boolean aPrSuivantConsecutif(Localisation localisation, LocalisantPr prDebut) {
        LocalisantPr prSuivant = GestionPr.getPrSuivant(localisation.getTriRoute());
        return prDebut.getPr() + 1 == prSuivant.getPr();
    }

    public void supprimerPointsBaionnette() {
        ICouche couchePr = this.carto.getCarte().getCouche("pr");
        Enregistrement[] enrs = couchePr.getDon().getAllEnreg();
        int i = enrs.length - 1;
        while (i >= 0) {
            Enregistrement enr = enrs[i];
            if (GLS.egal(enr.getValeur(3), "PB")) {
                couchePr.supprimeEntite(enr.getNum());
            }
            --i;
        }
    }

    public void generePointBaionnette(Localisation localisation, LocalisantPr prMinSectionCourante, LocalisantPr prMaxSectionPrecedente) {
        LocalisantPr pb;
        InfoTroncon premierTroncon = this.carto.getTri().getPremierTroncon();
        if (prMaxSectionPrecedente == null || prMaxSectionPrecedente.getPr() + 1 < prMinSectionCourante.getPr()) {
            pb = new LocalisantPr(prMinSectionCourante.getPr() - 1, (long)premierTroncon.getAbscisseMinimum());
            DistanceInfo distanceInterPrDebutTroncon = GestionPr.getDistanceInterPrPrecedent(this.carto.getTri(), prMinSectionCourante);
            if (distanceInterPrDebutTroncon.getDistance() >= 1000) {
                pb.getEntitePr().setAbscisse(0);
            } else {
                pb.getEntitePr().setAbscisse(1000 - distanceInterPrDebutTroncon.getDistance());
            }
            this.ecrireRapport("Correction discontinuit\u00e9 - Distance entre le d\u00e9but du troncon et le premier PR - " + distanceInterPrDebutTroncon.getDistance() + "m" + " - abscisse PB = " + pb.getEntitePr().getAbscisse());
        } else {
            pb = prMaxSectionPrecedente;
        }
        pb.initialiseDistancePr(premierTroncon.getAbscisseMinimum());
        this.ecrireRapport("## V\u00e9rification de la pr\u00e9sence du point baionnette - PR(" + pb.getEntitePr().toString(true) + ")+" + pb.getDistancePr() + " sur le troncon " + premierTroncon.getIdgdf() + " (abs " + premierTroncon.getAbscisseMinimum() + ")");
        this.ecrireRapport("Ajout du point baionnette PR" + pb.getEntitePr().toString(true));
        this.ecrireRapportCorrectionCSV("Ajout du point baionnette PR" + pb.getEntitePr().toString(true, false));
        try {
            GestionPlo.ajouterEntiteCouchePlo(localisation, pb, localisation.getTri().getPremierPoint());
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        try {
            GestionPr.ajouterEntiteCouchePr(localisation.getRoute(), String.valueOf(pb.getPr()), "PB", localisation.getTri().getPremierPoint());
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        this.ecrireRapportAjoutCSV(pb, localisation.getRoute());
        this.ecrirePointBaionnette(premierTroncon, pb);
    }

    public void deplacerPrAuDebut(Localisation localisation, InfoTroncon premierTronconPr, LocalisantPr prMin, double distancePr) {
        this.ecrireRapport("REPOSITIONNEMENT DU PR " + prMin.toString(false) + " EN DEBUT DE SECTION (DEPLACEMENT DE " + distancePr + "m)");
        prMin.initialiseDistancePr(localisation.getTri().getPremierTroncon().getAbscisseMinimum());
        premierTronconPr.deplacerPr(prMin, localisation.getTri().getPremierTroncon());
        this.ecrireRapportCorrectionCSV("REPOSITIONNEMENT DU PR " + prMin.getEntitePr().toString(true, false) + " EN DEBUT DE SECTION (DEPLACEMENT DE " + (distancePr <= 0.0 ? 1.0 : distancePr) + "m)");
        if (!prMin.estBaionnette() && LocalisationInfo.appliquerChangementFinRoute) {
            try {
                GestionPr.deplacerEntiteCouchePr(localisation.getRoute(), GLS.getString(prMin.getPr()), localisation.getTri().getPremierPoint());
            }
            catch (Exception e) {
                log.error((Object)"ERREUR DANS LE DEPLACEMENT DE L'ENTITE PR", (Throwable)e);
                this.ecrireRapport("ERREUR DANS LE DEPLACEMENT DE L'ENTITE PR EN DEBUT DE ROUTE - " + e.getMessage());
            }
        }
        ++this.nbPrRepositionne;
    }

    public void deplacerPrEnFin(Localisation localisation, InfoTroncon dernierTronconPr, LocalisantPr prMin, double distancePr) {
        this.ecrireRapport("REPOSITIONNEMENT DU PR " + prMin.toString(false) + " EN DEBUT DE SECTION (DEPLACEMENT DE " + distancePr + "m)");
        prMin.initialiseDistancePr(localisation.getTri().getDernierTroncon().getAbscisseMaximum());
        dernierTronconPr.deplacerPr(prMin, localisation.getTri().getDernierTroncon());
        this.ecrireRapportCorrectionCSV("REPOSITIONNEMENT DU PR " + prMin.getEntitePr().toString(true, false) + " EN FIN DE SECTION (DEPLACEMENT DE " + (distancePr <= 0.0 ? 1.0 : distancePr) + "m)");
        if (!prMin.estBaionnette() && LocalisationInfo.appliquerChangementFinRoute) {
            try {
                GestionPr.deplacerEntiteCouchePr(localisation.getRoute(), GLS.getString(prMin.getPr()), localisation.getTri().getDernierPoint());
            }
            catch (Exception e) {
                log.error((Object)"ERREUR DANS LE DEPLACEMENT DE L'ENTITE PR", (Throwable)e);
                this.ecrireRapport("ERREUR DANS LE DEPLACEMENT DE L'ENTITE PR EN FIN DE ROUTE - " + e.getMessage());
            }
        }
        ++this.nbPrRepositionne;
    }

    public void generationPointBaionette(String[] listeCouches, boolean modificationCartographie) throws Exception {
        this.carto.appliquerChangementCartographique(modificationCartographie);
        Vector<String> listeRoutes = new Vector<String>();
        log.debug((Object)"R\u00e9cup\u00e9ration de la liste des routes");
        String[] stringArray = listeCouches;
        int n = listeCouches.length;
        int n2 = 0;
        while (n2 < n) {
            String nomCouche = stringArray[n2];
            log.debug((Object)("R\u00e9cup\u00e9ration de la liste des routes sur la couche " + nomCouche));
            ICouche couche = this.carto.getCarte().getCouche(nomCouche);
            listeRoutes.addAll(Referentiel.getRoutes(couche));
            if (this.reinitialiserBaionnette) {
                log.debug((Object)"R\u00e9initialisation des points baionnettes...");
                Enregistrement[] enregistrementArray = couche.getDon().getAllEnreg();
                int n3 = enregistrementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Enregistrement enr = enregistrementArray[n4];
                    InfoTroncon troncon = new InfoTroncon(enr, couche);
                    for (LocalisantPr pr : troncon.getPR()) {
                        if (!pr.estBaionnette()) continue;
                        troncon.supprimerPr(pr);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (this.reinitialiserBaionnette) {
            this.supprimerPointsBaionnette();
        }
        this.nbPointBaionnette = 0;
        this.nbPrRepositionne = 0;
        if (!GLS.estVide(listeRoutes)) {
            listeRoutes = Referentiel.getRoutesTriees(listeRoutes);
            for (String route : listeRoutes) {
                this.generationPointBaionetteRoute(route);
            }
        } else {
            this.ecrireRapport("Aucune route dans la carte - aucun point baionette g\u00e9n\u00e9r\u00e9");
        }
        this.ecrireRapport("### NB POINTS BAIONNETTE GENERES : " + this.nbPointBaionnette);
        this.ecrireRapport("### NB PR REPOSITIONNE : " + this.nbPrRepositionne);
        this.ecrireRapport("Traitement termin\u00e9");
        this.fermerRapport();
        this.carto.appliquerChangementCartographique(false);
    }

    public void fermerRapport() {
        if (this.rapport != null) {
            try {
                this.rapport.fermer();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.rapportCorrectionCSV != null) {
            try {
                this.rapportCorrectionCSV.fermer();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.rapportErreurCSV != null) {
            try {
                this.rapportErreurCSV.fermer();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.rapportAjoutCSV != null) {
            try {
                this.rapportAjoutCSV.fermer();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void generationPointBaionetteRoute(String route) {
        LocalisantPr dernierPr;
        LocalisantPr prCourant;
        this.ecrireRapport("######################################");
        this.ecrireRapport("TRAITEMENT DE LA ROUTE " + route);
        Vector<String> listePr = GestionPr.getPr(route);
        boolean fin = false;
        DistanceInfo distanceInterPrFinRoute = new DistanceInfo();
        LocalisantPr dernierPrTri = null;
        int iSection = 1;
        int premierPrSectionSuivante = -1;
        if (!GLS.estVide(listePr)) {
            prCourant = new LocalisantPr(listePr.firstElement());
            dernierPr = new LocalisantPr(listePr.lastElement());
        } else {
            prCourant = null;
            dernierPr = null;
            this.ecrireRapport("LA ROUTE NE CONTIENT AUCUN PR");
            fin = true;
        }
        this.nomRouteCourante = route;
        boolean erreur = false;
        while (!fin && !erreur) {
            this.iSectionCourante = iSection;
            this.ecrireRapport(">---------------------------------");
            this.ecrireRapport("> SECTION N\u00b0" + iSection++);
            try {
                this.carto.initialiseLocalisationCourante();
                this.carto.localisationPR(prCourant, prCourant, route);
            }
            catch (Exception e) {
                log.error((Object)"ERREUR DE LOCALISATION ", (Throwable)e);
                this.ecrireRapport("ERREUR DE LOCALISATION AU PR " + prCourant);
                this.ecrireRapportErreurCSV(null, "SECTION ERREUR - IMPOSSIBLE DE LOCALISATION AU PR " + prCourant.getEntitePr().toString(true, false));
                erreur = true;
            }
            if (!erreur) {
                try {
                    this.verifierSectionRouteCourante(this.rapport);
                }
                catch (Exception e) {
                    log.error((Object)e);
                    this.ecrireRapport(e.getMessage());
                    this.ecrireRapportErreurCSV(e.getMessage());
                    erreur = true;
                }
            }
            if (!erreur) {
                try {
                    this.verificationPrDebut(this.carto.getLocalisationCourante(false), dernierPrTri);
                }
                catch (Exception e) {
                    log.error((Object)"ERREUR VERIFICATION PR DEBUT", (Throwable)e);
                    this.ecrireRapport("ERREUR VERIFICATION PR DEBUT " + e.getMessage());
                }
                dernierPrTri = this.carto.getTri().getPrMax();
                premierPrSectionSuivante = this.recherchePremierPrSectionSuivante(dernierPrTri.getPr(), listePr);
                if (dernierPrTri.equals(dernierPr) || premierPrSectionSuivante > dernierPr.getPr()) {
                    fin = true;
                    continue;
                }
                GeoPositionnement positionDernierPr = Recherche.getPositionAtPR(this.carto.getTri(), dernierPrTri);
                distanceInterPrFinRoute = GestionPr.getDistanceInterPrSuivant(this.carto.getTri(), positionDernierPr, dernierPrTri);
                dernierPrTri.getEntitePr().setAbscisse(distanceInterPrFinRoute.getDistance() + 1);
                prCourant = new LocalisantPr(premierPrSectionSuivante, 0L);
                try {
                    if (!this.carto.getLocalisationCourante(false).getTri().aPr(prCourant)) continue;
                    this.ecrireRapport("LE PR DE LA SECTION SUIVANTE EST DEJA PRESENT DANS LE TRI " + prCourant);
                    this.ecrireRapportErreurCSV("VERIFIER LE PR " + prCourant + " IL N'EST PAS CORRECTEMENT PLACE");
                    erreur = true;
                }
                catch (Exception e) {
                    this.ecrireRapport("LE PROCESSUS VA S'ARRETER - CAUSE ERREUR LOCALISATION ");
                }
                continue;
            }
            this.ecrireRapport("LE PROCESSUS VA S'ARRETER - CAUSE ERREUR LOCALISATION ");
        }
    }

    protected int recherchePremierPrSectionSuivante(int dernierPrSectionCourante, Vector<String> listePr) {
        int premierPrSectionSuivante = dernierPrSectionCourante + 1;
        while (!GLS.estDansLaListe(listePr, (Object)GLS.getString(premierPrSectionSuivante)) && GLS.getInt(listePr.lastElement()) >= premierPrSectionSuivante) {
            ++premierPrSectionSuivante;
        }
        return premierPrSectionSuivante;
    }

    protected void ecrirePointBaionnette(InfoTroncon troncon, LocalisantPr pr) {
        ++this.nbPointBaionnette;
        troncon.ajouterPr(pr);
    }

    public static void main(String ... strings) {
        try {
            Referentiel referentiel = new Referentiel("e:/carto/", "cg67", "e:/carto/cg67/", true);
            DISTANCE_MAX_REPOSITIONNEMENT_PR_0 = 2000;
            LocalisationInfo.margeRechercheRoute = 1000;
            LocalisationInfo.zoneUTM = 20;
            referentiel.generationPointBaionetteRoute("D180");
            referentiel.fermerRapport();
        }
        catch (Exception e) {
            log.error((Object)"ERREUR GENERATION POINT BAIONNETTE", (Throwable)e);
            e.printStackTrace();
        }
    }
}

