/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui.saisie.onglet;

import gls.outils.GLS;
import gls.outils.ui.saisie.composant.ComposantSaisieGLS;
import gls.outils.ui.saisie.composant.ComposantsSaisieGLS;
import gls.outils.ui.saisie.composant.GLSComposant;
import gls.outils.ui.saisie.composant.GLSCoucheBox;
import java.util.Vector;
import javax.swing.JPanel;

public class OngletGLS {
    protected String nom;
    protected String libelle;
    protected ComposantsSaisieGLS composants;

    public OngletGLS(String nom, String libelle) {
        this(nom, libelle, new ComposantsSaisieGLS());
    }

    public OngletGLS(String nom, String libelle, ComposantsSaisieGLS composants) {
        this.nom = nom;
        this.libelle = libelle;
        this.composants = composants;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public String getLibelle() {
        return this.libelle;
    }

    public void setLibelle(String libelle) {
        this.libelle = libelle;
    }

    public ComposantsSaisieGLS getComposants() {
        return this.composants;
    }

    public void setComposants(ComposantsSaisieGLS composants) {
        this.composants = composants;
    }

    public boolean aDesComposants() {
        return !GLS.estVide(this.composants);
    }

    public void ajouterComposant(ComposantSaisieGLS composant) {
        if (this.composants == null) {
            this.composants = new ComposantsSaisieGLS();
        }
        this.composants.ajouter(composant);
    }

    public ComposantSaisieGLS getComposant(String composant) throws Exception {
        if (this.aDesComposants()) {
            return this.composants.get(composant);
        }
        throw new Exception("IL N'Y A AUCUN COMPOSANT");
    }

    public ComposantsSaisieGLS getComposantsDynamiques() {
        ComposantsSaisieGLS composantsDynamiques = new ComposantsSaisieGLS();
        for (ComposantSaisieGLS composant : this.composants) {
            if (composant instanceof GLSComposant) continue;
            composantsDynamiques.add(composant);
        }
        return composantsDynamiques;
    }

    public ComposantsSaisieGLS getComposantsDynamiquesNonCarto() {
        ComposantsSaisieGLS composantsDynamiques = new ComposantsSaisieGLS();
        for (ComposantSaisieGLS composant : this.composants) {
            if (composant instanceof GLSComposant || composant instanceof GLSCoucheBox) continue;
            composantsDynamiques.add(composant);
        }
        return composantsDynamiques;
    }

    public ComposantsSaisieGLS getComposantsStatiques() {
        ComposantsSaisieGLS composantsStatiques = new ComposantsSaisieGLS();
        for (ComposantSaisieGLS composant : this.composants) {
            if (!(composant instanceof GLSComposant)) continue;
            composantsStatiques.add(composant);
        }
        return composantsStatiques;
    }

    public Vector<GLSCoucheBox> getComposantsCarto() {
        Vector<GLSCoucheBox> composantsCarto = new Vector<GLSCoucheBox>();
        for (ComposantSaisieGLS composant : this.composants) {
            if (!(composant instanceof GLSCoucheBox)) continue;
            composantsCarto.add((GLSCoucheBox)composant);
        }
        return composantsCarto;
    }

    public void reorganiserComposants(String[] ordreComposants) {
        if (ordreComposants != null) {
            int i = ordreComposants.length - 1;
            while (i >= 0) {
                String composant = ordreComposants[i];
                int indice = GLS.getIndiceObjetListe(this.composants, (Object)composant);
                if (indice > -1) {
                    this.composants.insertElementAt((ComposantSaisieGLS)this.composants.remove(indice), 0);
                }
                --i;
            }
        }
    }

    public JPanel getPanneau() {
        return GLS.getUI().creerPanneauComposants(this.composants);
    }
}

