/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui.saisie.composant.definition;

import com.toedter.calendar.JDayChooser;
import com.toedter.calendar.JYearChooser;
import gls.outils.ui.ChoixValeur;
import gls.outils.ui.GlsUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Calendar;
import javax.swing.JFrame;

public class MyYearChooser
extends JYearChooser {
    private static final long serialVersionUID = 2648810220491090064L;
    protected JDayChooser dayChooser;
    protected int oldYear;
    protected int startYear;
    protected int endYear;
    protected ChoixValeur choix = new ChoixValeur();

    public MyYearChooser() {
        this.spinner = null;
        this.removeAll();
        this.setName("JYearChooser");
        Calendar calendar = Calendar.getInstance();
        this.dayChooser = null;
        this.choix = new ChoixValeur(calendar.get(1), calendar.getMinimum(1), calendar.getMaximum(1), 1);
        this.choix.setFont(GlsUI.FONT_CALENDRIER);
        this.setLayout(new BorderLayout());
        this.add(this.choix, "Center");
        this.repaint();
    }

    public void setYear(int y) {
        if (this.choix != null) {
            this.choix.setValue(y);
        }
        if (this.dayChooser != null) {
            this.dayChooser.setYear(this.value);
        }
        this.firePropertyChange("year", this.oldYear, this.value);
        this.oldYear = this.value;
    }

    public void setValue(int value) {
        this.setYear(value);
    }

    public int getYear() {
        return this.choix.toInt();
    }

    public void setDayChooser(JDayChooser dayChooser) {
        this.dayChooser = dayChooser;
    }

    public int getEndYear() {
        if (this.choix != null) {
            return this.choix.getMax();
        }
        return Calendar.getInstance().getMaximum(1);
    }

    public void setEndYear(int endYear) {
        if (this.choix != null) {
            this.choix.setMax(endYear);
        }
    }

    public int getStartYear() {
        if (this.choix != null) {
            return this.choix.getMin();
        }
        return Calendar.getInstance().getMinimum(1);
    }

    public void setStartYear(int startYear) {
        if (this.choix != null) {
            this.choix.setMin(startYear);
        }
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame("JYearChooser");
        frame.getContentPane().add((Component)new JYearChooser());
        frame.pack();
        frame.setVisible(true);
    }
}

