/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui.saisie.composant;

import gls.outils.ConstantesGLS;
import gls.outils.ui.saisie.composant.GLSPanneau;
import gls.outils.ui.saisie.composant.GLSPanneaux;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;

public class GLSTabbedPane
extends JTabbedPane {
    private GLSPanneaux panneaux;
    private GLSPanneau panneauCourant;
    private GLSPanneau panneauSauvegarde;
    private GLSPanneaux panneauxSauvegardes;

    public GLSTabbedPane() {
        super(1);
        this.initialisation();
        this.initialisationUI();
    }

    public GLSPanneaux getPanneaux() {
        return this.panneaux;
    }

    public void initialisation() {
        this.panneaux = new GLSPanneaux();
        this.panneauxSauvegardes = new GLSPanneaux();
    }

    public void initialisationUI() {
    }

    public void setPanneauCourant(GLSPanneau panneau) {
        this.panneauCourant = panneau;
    }

    public GLSPanneau getPanneauCourant() throws Exception {
        if (this.panneauCourant != null) {
            return this.panneauCourant;
        }
        throw new Exception("AUCUN PANNEAU COURANT");
    }

    public void sauverPanneauCourant() {
        this.sauver(this.panneauCourant);
    }

    public void sauver(GLSPanneau panneau) {
        this.panneauSauvegarde = panneau;
    }

    public void sauver() {
        if (!ConstantesGLS.estVide(this.panneaux)) {
            this.panneauxSauvegardes.removeAllElements();
            for (GLSPanneau panneau : this.panneaux) {
                this.panneauxSauvegardes.add(panneau);
            }
            this.panneauxSauvegardes.setIndice(this.getSelectedIndex());
        }
    }

    public void afficher(boolean etat) {
        this.setVisible(etat);
    }

    public boolean existe(GLSPanneau panneau) {
        return this.getIndice(panneau) != -1;
    }

    public int getIndice(GLSPanneau panneau) {
        if (panneau != null) {
            return this.panneaux.indexOf(panneau);
        }
        return -1;
    }

    public void allerA(GLSPanneau panneau) {
        int iPanneau = this.indexOfComponent(panneau);
        this.allerA(iPanneau);
    }

    public void allerA(int iPanneau) {
        if (!ConstantesGLS.estNulle(iPanneau)) {
            this.setSelectedIndex(iPanneau);
        }
    }

    public void inserer(GLSPanneau panneau, int index) {
        if (panneau != null) {
            this.inserer(panneau.getTitre(), panneau.getIcone(), panneau, panneau.getDescription(), index);
        }
    }

    public void inserer(String libelle, GLSPanneau panneau, int index) {
        this.inserer(libelle, null, panneau, libelle, index);
    }

    public void inserer(ImageIcon icone, GLSPanneau panneau, int index) {
        this.inserer("", icone, panneau, null, index);
    }

    public void inserer(String libelle, ImageIcon icone, GLSPanneau panneau, int index) {
        this.inserer(libelle, icone, panneau, libelle, index);
    }

    public void inserer(String libelle, ImageIcon icone, GLSPanneau panneau, String description, int index) {
        if (!this.existe(panneau)) {
            panneau.setTitre(libelle);
            panneau.setIcone(icone);
            panneau.setDescription(description);
            this.sauver(panneau);
            this.setPanneauCourant(panneau);
            this.panneaux.ajouter(panneau);
            this.insertTab(libelle, icone, panneau, description, index);
        }
    }

    public void allerAPanneauSauvegarde() {
        if (this.aUnPanneauSauvegarde()) {
            this.allerA(this.panneauSauvegarde);
        }
    }

    public void ajouterEtAllerAPanneauxSauvegardes() {
        if (this.aUnPanneauSauvegarde()) {
            this.ajouter(this.panneauxSauvegardes);
            this.allerA(this.panneauxSauvegardes.getIndice());
        }
    }

    public void enleverToutEtAllerAPanneauxSauvegardes() {
        if (this.aUnPanneauSauvegarde()) {
            this.supprimerPanneaux();
            this.ajouterEtAllerAPanneauxSauvegardes();
        }
    }

    public boolean aUnPanneauSauvegarde() {
        return !ConstantesGLS.estVide(this.panneauxSauvegardes);
    }

    public void ajouter(GLSPanneaux panneaux) {
        if (!ConstantesGLS.estVide(panneaux)) {
            for (GLSPanneau panneau : panneaux) {
                this.ajouter(panneau);
            }
        }
    }

    public void ajouter(GLSPanneau panneau) {
        if (panneau != null) {
            this.ajouter(panneau.getTitre(), panneau.getIcone(), panneau, panneau.getDescription());
        }
    }

    public void ajouter(String libelle, ImageIcon icone, GLSPanneau panneau) {
        this.ajouter(libelle, icone, panneau, libelle);
    }

    public void ajouter(ImageIcon icone, GLSPanneau panneau) {
        this.ajouter("", icone, panneau, null);
    }

    public void ajouter(String libelle, GLSPanneau panneau) {
        this.ajouter(libelle, null, panneau, libelle);
    }

    public void ajouter(String libelle, ImageIcon icone, GLSPanneau panneau, String description) {
        this.inserer(libelle, icone, panneau, description, this.getTabCount());
    }

    public void supprimer(GLSPanneau panneau) {
        int iPanneau = this.getIndice(panneau);
        if (!ConstantesGLS.estNulle(iPanneau)) {
            this.remove(iPanneau);
            this.panneaux.remove(iPanneau);
        }
    }

    public void sauverEtSupprimerPanneaux() {
        this.sauver();
        this.supprimerPanneaux();
    }

    public void supprimerPanneaux() {
        this.removeAll();
        this.panneaux.removeAllElements();
    }

    public void ajouterEtAllerA(GLSPanneau panneau) {
        this.ajouter(panneau);
        this.allerA(panneau);
    }
}

