/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui.saisie.composant;

import gls.outils.GLS;
import gls.outils.GLSHashMap;
import gls.outils.ui.GlsUI;
import gls.outils.ui.saisie.composant.ComposantSaisieGLS;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class GLSRadioBox
extends ComposantSaisieGLS {
    public static final String TYPE = "GLSRadioBox";
    private JPanel panneauRadio;
    protected ButtonGroup bgRadio;
    protected Vector<JRadioButton> radios;
    protected String[] listeLibelle;

    public GLSRadioBox(int type, String nom, String libelle, Object objet, Object valeur, String restriction, int hauteur) {
        super(type, nom, libelle, objet, valeur, restriction, hauteur, 416);
    }

    public GLSRadioBox(String nom, String libelle, Object objet, Object valeur, int hauteur) {
        super(nom, libelle, objet, valeur, hauteur);
    }

    public GLSRadioBox(int type, String nom, String libelle, Object objet, Object valeur, int hauteur) {
        super(type, nom, libelle, objet, valeur, hauteur);
    }

    public GLSRadioBox(GLSHashMap config) {
        super(config);
    }

    @Override
    public Object getValeur() {
        if (this.bgRadio.getSelection() != null && this.estActive()) {
            return this.bgRadio.getSelection().getActionCommand();
        }
        return "";
    }

    @Override
    public void initialisationHandle() {
        this.panneauRadio = new JPanel();
        this.bgRadio = new ButtonGroup();
        this.radios = new Vector();
        if (this.definition != null) {
            this.listeLibelle = this.definition instanceof Vector ? GLS.toTableauString((Vector)this.definition) : (this.definition instanceof String[] ? (String[])this.definition : (this.definition instanceof String ? GLS.getTableauString((String)this.definition, ";") : new String[0]));
            if (!GLS.estVide(this.listeLibelle)) {
                this.panneauRadio.setLayout(new GridLayout(1, this.listeLibelle.length));
                this.panneauRadio.setBackground(GlsUI.COULEUR_FOND_PANNEAU);
                String[] stringArray = this.listeLibelle;
                int n = this.listeLibelle.length;
                int n2 = 0;
                while (n2 < n) {
                    String libelle = stringArray[n2];
                    JRadioButton radio = new JRadioButton(GLS.getLibelleComposantPlusieursLigne(libelle));
                    radio.setActionCommand(libelle);
                    radio.setBackground(GlsUI.COULEUR_FOND_RADIO);
                    radio.setFont(GlsUI.FONT_RADIO);
                    this.bgRadio.add(radio);
                    this.radios.add(radio);
                    this.panneauRadio.add(radio);
                    ++n2;
                }
            }
        }
    }

    @Override
    protected void setValeur() {
        if (this.valeur != null) {
            this.setValeur(this.valeur);
        } else {
            this.setValeur(this.listeLibelle[0]);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        for (JRadioButton radio : this.radios) {
            radio.addActionListener(actionListener);
        }
    }

    @Override
    public void initialisationUIHandle() {
        this.initialiser(UI.creerPanneauAffichage(this.style, this.libelle, GlsUI.getImageStyleDefaut(this.style), this.panneauRadio, this.hauteur), false);
    }

    @Override
    public void setValeur(Object object) {
        int i = GLS.getIndiceObjetListe(this.listeLibelle, GLS.getString(object));
        if (!GLS.estNulle(i)) {
            this.bgRadio.setSelected(((JRadioButton)this.panneauRadio.getComponent(i)).getModel(), true);
        }
    }

    public boolean estActive() {
        for (JRadioButton radio : this.radios) {
            if (!radio.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void activer(boolean etat) {
        for (JRadioButton radio : this.radios) {
            radio.setEnabled(etat);
        }
    }
}

