/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui.saisie.composant;

import gls.outils.GLS;
import gls.outils.ui.GlsUI;
import gls.outils.ui.GlsUIEnvironnement;
import gls.outils.ui.saisie.composant.ComposantSaisieGLS;
import gls.outils.ui.saisie.composant.ComposantsSaisieGLS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public abstract class GLSPanneau
extends JPanel
implements GlsUIEnvironnement,
ActionListener {
    private static final Logger LOG = Logger.getLogger(GLSPanneau.class);
    protected static final GlsUI UI = GlsUI.instanceOf();
    protected final int ESPACEMENT_COMPOSANTS_DEFAUT = 10;
    protected int ESPACEMENT_COMPOSANTS = 10;
    protected JPanel panneauNord;
    protected JPanel panneauCentre;
    protected JPanel panneauSud;
    protected ComposantsSaisieGLS composants;
    protected ImageIcon icone;
    protected String titre;
    protected String description;
    protected int largeur;
    protected int hauteur;

    public GLSPanneau(String titre) {
        this(GlsUI.LARGEUR_PANNEAU, GLSPanneau.TAILLE_ECRAN.height, titre, null, null);
    }

    public GLSPanneau(String titre, ImageIcon icone, String description) {
        this(GlsUI.LARGEUR_PANNEAU, GLSPanneau.TAILLE_ECRAN.height, titre, icone, description);
    }

    public GLSPanneau(int largeur, int hauteur) {
        this(largeur, hauteur, null, null, null);
    }

    public GLSPanneau() {
        this(GlsUI.LARGEUR_PANNEAU, GLSPanneau.TAILLE_ECRAN.height);
    }

    public GLSPanneau(int largeur, int hauteur, String titre, ImageIcon icone, String description) {
        this.largeur = largeur;
        this.hauteur = hauteur;
        this.titre = titre;
        this.icone = icone;
        this.description = description;
        this.composants = new ComposantsSaisieGLS();
        this.initialisation();
        this.initialisationUI();
    }

    protected void initialisation() {
        GLS.fixerTailleObjet(this, this.largeur, this.hauteur);
        this.setBackground(GlsUI.COULEUR_FOND_PANNEAU);
        this.setBorder(BorderFactory.createLineBorder(GlsUI.COULEUR_BORDURE_PANNEAU, 1));
        this.setLayout(new BorderLayout());
        this.panneauCentre = new JPanel();
        this.panneauCentre.setLayout(new BoxLayout(this.panneauCentre, 1));
        this.initialisationHandle();
    }

    protected void initialisationUI() {
        this.initialisationUIHandle();
        this.panneauNord = this.getPanneauNord();
        this.initialisationPanneauCentre();
        this.panneauSud = this.getPanneauSud();
        this.assemblerComposants();
    }

    protected void assemblerComposants() {
        this.assemblerPanneauNord();
        this.assemblerPanneauCentre();
        this.assemblerPanneauSud();
    }

    protected void assemblerPanneauNord() {
        if (this.panneauNord != null) {
            this.add((Component)this.panneauNord, "North");
        }
    }

    protected void assemblerPanneauSud() {
        if (this.panneauSud != null) {
            this.add((Component)this.panneauSud, "South");
        }
    }

    protected void assemblerPanneauCentre() {
        if (this.panneauCentre != null) {
            this.add((Component)GlsUI.getScollPane(this.panneauCentre), "Center");
        }
    }

    protected abstract JPanel getPanneauNord();

    protected abstract void initialisationPanneauCentre();

    protected abstract JPanel getPanneauSud();

    public void ajouterSections(Vector<ComposantsSaisieGLS> sections) {
        this.ajouterSections(this.panneauCentre, sections);
    }

    protected void ajouterSections(JPanel panneau, Vector<ComposantsSaisieGLS> sections) {
        for (ComposantsSaisieGLS section : sections) {
            this.ajouterSection(panneau, section);
        }
    }

    public void ajouterSection(ComposantsSaisieGLS section) {
        this.ajouterSection(this.panneauCentre, section);
    }

    public void ajouterSection(JPanel panneau, ComposantsSaisieGLS section) {
        this.ajouterSection(panneau, section, this.ESPACEMENT_COMPOSANTS);
    }

    public void ajouterSection(ComposantsSaisieGLS section, int espacementSection) {
        this.ajouterSection(this.panneauCentre, section, espacementSection);
    }

    public void ajouterSection(JPanel panneau, ComposantsSaisieGLS section, int espacementSection) {
        this.composants.ajouter(section);
        try {
            this.ajouter(panneau, UI.creerPanneauAffichage(UI.creerLabelAffichage(section.getLibelle(), GlsUI.IMAGE_LABEL_SECTION), section.getComposantGLS(), 0).getComposant());
        }
        catch (Exception e) {
            LOG.error((Object)("ERREUR AJOUT COMPOSANT PANNEAU " + section.getNom()), (Throwable)e);
        }
    }

    public void ajouterComposants(ComposantsSaisieGLS composants) {
        this.ajouterComposants(this.panneauCentre, composants, this.ESPACEMENT_COMPOSANTS);
    }

    public void ajouterComposants(JPanel panneau, ComposantsSaisieGLS composants) {
        this.ajouterComposants(panneau, composants, this.ESPACEMENT_COMPOSANTS);
    }

    public void ajouterComposants(ComposantsSaisieGLS composants, int espacement) {
        this.ajouterComposants(this.panneauCentre, composants, espacement);
    }

    public void ajouterComposants(JPanel panneau, ComposantsSaisieGLS composants, int espacement) {
        for (ComposantSaisieGLS composant : composants) {
            this.ajouterComposant(panneau, composant, espacement);
        }
    }

    public void ajouterComposant(ComposantSaisieGLS composant) {
        this.ajouterComposant(composant, this.ESPACEMENT_COMPOSANTS);
    }

    public ComposantSaisieGLS getComposantSaisie(String nomComposant) throws Exception {
        return this.composants.get(nomComposant);
    }

    public Calendar getCalendar(String nomComposant) throws Exception {
        Object obj = this.getValeur(nomComposant);
        if (obj instanceof Calendar) {
            return (Calendar)obj;
        }
        throw new Exception("LE TYPE DE DONNEE N'EST PAS DE TYPE CALENDRIER");
    }

    public Object getValeur(String nomComposant) throws Exception {
        return this.getComposantSaisie(nomComposant).getValeur();
    }

    public double getDouble(String nomComposant) throws Exception {
        return this.getComposantSaisie(nomComposant).getDouble();
    }

    public int getInt(String nomComposant) throws Exception {
        return this.getComposantSaisie(nomComposant).getInt();
    }

    public String getString(String nomComposant, String defaut) {
        try {
            return GLS.getString(this.getString(nomComposant), defaut);
        }
        catch (Exception e) {
            return defaut;
        }
    }

    public String getString(String nomComposant) throws Exception {
        return this.getComposantSaisie(nomComposant).getString();
    }

    public boolean estIntVide(String nomComposant) {
        try {
            return this.getInt(nomComposant) <= 0;
        }
        catch (Exception e) {
            return true;
        }
    }

    public void effacer(String nomComposant) throws Exception {
        this.getComposantSaisie(nomComposant).effacer();
    }

    public void effacer() {
        for (ComposantSaisieGLS composant : this.composants) {
            try {
                composant.effacer();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean estStringVide(String nomComposant) {
        try {
            return GLS.estVide(this.getString(nomComposant));
        }
        catch (Exception e) {
            return true;
        }
    }

    public void ajouterComposant(ComposantSaisieGLS composant, int espacement) {
        this.ajouterComposant(this.panneauCentre, composant, espacement);
    }

    public void ajouterComposant(JPanel panneau, ComposantSaisieGLS composant) {
        this.ajouterComposant(panneau, composant, this.ESPACEMENT_COMPOSANTS);
    }

    public void ajouterComposant(JPanel panneau, ComposantSaisieGLS composant, int espacement) {
        this.composants.ajouter(composant);
        try {
            this.ajouter(panneau, composant.getComposant(), espacement);
        }
        catch (Exception e) {
            LOG.error((Object)("ERREUR AJOUT COMPOSANT PANNEAU " + composant.getNom()), (Throwable)e);
        }
    }

    protected void ajouterEntete(String entete, String image) {
        try {
            this.ajouter(UI.creerLabelAffichage(entete, image).getComposant());
        }
        catch (Exception e) {
            LOG.error((Object)"ERREUR AJOUT ENTETE", (Throwable)e);
        }
    }

    protected void ajouter(JPanel panneau, JComponent composant) {
        this.ajouter(panneau, composant, this.ESPACEMENT_COMPOSANTS);
    }

    protected void ajouter(JComponent composant) {
        this.ajouter(this.panneauCentre, composant);
    }

    protected void ajouter(JPanel panneau, JComponent composant, int espacement) {
        panneau.add(composant);
        if (espacement != -1) {
            panneau.add(Box.createVerticalStrut(espacement));
        }
    }

    protected abstract void initialisationHandle();

    protected abstract void initialisationUIHandle();

    public void rafraichir() {
        this.setVisible(false);
        this.setVisible(true);
    }

    public int tiersDuPanneau() {
        return GlsUI.LARGEUR_PANNEAU / 3 - 5;
    }

    public int moitieDuPanneau() {
        return GlsUI.LARGEUR_PANNEAU / 2 - 5;
    }

    public void afficher(boolean etat) {
        this.setVisible(etat);
    }

    public ImageIcon getIcone() {
        return this.icone;
    }

    public void setIcone(ImageIcon icone) {
        this.icone = icone;
    }

    public String getTitre() {
        return this.titre;
    }

    public void setTitre(String titre) {
        this.titre = titre;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void actionPerformed(ActionEvent a) {
        this.actionPerformed(a.getActionCommand());
    }

    public void setValeur(String nomComposant, Object valeur) throws Exception {
        this.getComposantSaisie(nomComposant).setValeur(valeur);
    }

    @Override
    public String toString() {
        return this.titre;
    }

    public boolean equals(Object obj) {
        return GLS.egal(obj, (Object)this.titre);
    }

    public abstract void actionPerformed(String var1);
}

