/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui.saisie.composant;

import gls.outils.GLS;
import gls.outils.GLSHashMap;
import gls.outils.ui.GlsUI;
import gls.outils.ui.saisie.composant.ComposantSaisieGLS;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class GLSMultiCheckBox
extends ComposantSaisieGLS {
    public static final String TYPE = "GLSMultiCheckBox";
    private static final String SEPARATEUR_SELECTION = ";";
    protected Vector<JCheckBox> checks;
    protected JPanel panneauCheck;
    protected String[] listeLibelle;

    public GLSMultiCheckBox(int type, String nom, String libelle, Object objet, Object valeur, String restriction, int hauteur) {
        super(type, nom, libelle, objet, valeur, restriction, hauteur, 416);
    }

    public GLSMultiCheckBox(String nom, String libelle, Object objet, Object valeur, int hauteur) {
        super(nom, libelle, objet, valeur, hauteur);
    }

    public GLSMultiCheckBox(int type, String nom, String libelle, Object objet, Object valeur, int hauteur) {
        super(type, nom, libelle, objet, valeur, hauteur);
    }

    public GLSMultiCheckBox(GLSHashMap config) {
        super(config);
    }

    public String getValeurDefaut() {
        return "";
    }

    @Override
    public Object getValeur() {
        Vector<String> listeSelection = new Vector<String>();
        String resultat = "";
        for (JCheckBox check : this.checks) {
            if (!check.isSelected()) continue;
            listeSelection.add(check.getActionCommand());
        }
        if (!GLS.estVide(listeSelection)) {
            int i = 0;
            while (i < listeSelection.size() - 1) {
                resultat = String.valueOf(resultat) + (String)listeSelection.get(i) + SEPARATEUR_SELECTION;
                ++i;
            }
        } else {
            return this.getValeurDefaut();
        }
        resultat = String.valueOf(resultat) + (String)listeSelection.get(listeSelection.size() - 1);
        return resultat;
    }

    @Override
    public void initialisationHandle() {
        this.panneauCheck = new JPanel();
        if (this.definition != null) {
            this.checks = new Vector();
            this.listeLibelle = this.definition instanceof String ? GLS.getTableauString((String)this.definition, SEPARATEUR_SELECTION) : (this.definition instanceof String[] ? (String[])this.definition : (this.definition instanceof Vector ? GLS.toTableauString((Vector)this.definition) : new String[0]));
            if (!GLS.estVide(this.listeLibelle)) {
                this.panneauCheck.setLayout(new GridLayout(1, this.listeLibelle.length));
                this.panneauCheck.setBackground(GlsUI.COULEUR_FOND_PANNEAU);
                String[] stringArray = this.listeLibelle;
                int n = this.listeLibelle.length;
                int n2 = 0;
                while (n2 < n) {
                    String libelle = stringArray[n2];
                    this.ajouterCheckBox(libelle);
                    ++n2;
                }
            }
        }
    }

    protected void ajouterCheckBox(String libelle) {
        JCheckBox check = new JCheckBox(GLS.getLibelleComposantPlusieursLigne(libelle));
        check.setBackground(GlsUI.COULEUR_FOND_CHECKBOX);
        check.setFont(GlsUI.FONT_CHECKBOX);
        check.setActionCommand(libelle);
        this.checks.add(check);
        this.panneauCheck.add(check);
    }

    @Override
    public void initialisationUIHandle() {
        this.initialiser(UI.creerPanneauAffichage(this.style, this.libelle, GlsUI.getImageStyleDefaut(this.style), this.panneauCheck, this.hauteur), false);
    }

    public void toutSelectionner() {
        for (JCheckBox check : this.checks) {
            check.setSelected(true);
        }
    }

    public void toutDeselectionner() {
        for (JCheckBox check : this.checks) {
            check.setSelected(false);
        }
    }

    public void setValeur(String[] valeurs) {
        this.toutDeselectionner();
        if (!GLS.estVide(this.listeLibelle) && !GLS.estVide(valeurs)) {
            String[] stringArray = valeurs;
            int n = valeurs.length;
            int n2 = 0;
            while (n2 < n) {
                String valeur = stringArray[n2];
                int i = GLS.getIndiceObjetListe(this.listeLibelle, valeur);
                if (!GLS.estNulle(i)) {
                    this.checks.get(i).setSelected(true);
                }
                ++n2;
            }
        }
    }

    @Override
    public void setValeur(Object object) {
        this.setValeur(GLS.getTableauString(object));
    }

    @Override
    public void activer(boolean etat) {
        for (JCheckBox check : this.checks) {
            check.setEnabled(etat);
        }
    }
}

