/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui.saisie.composant;

import gls.outils.GLS;
import gls.outils.GLSHashMap;
import gls.outils.ui.GlsUI;
import gls.outils.ui.checkboxlist.CheckBoxJList;
import gls.outils.ui.saisie.composant.ComposantSaisieGLS;
import gls.outils.ui.saisie.composant.definition.GLSListDefinition;
import java.util.Vector;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GLSListCheckBox
extends ComposantSaisieGLS
implements ListSelectionListener {
    private CheckBoxJList liste;
    protected GLSListDefinition listeDefinition;

    public GLSListCheckBox(GLSHashMap config) {
        super(config);
    }

    public GLSListCheckBox(int type, String nom, String libelle, Object objet, Object valeur, int hauteur) {
        super(type, nom, libelle, objet, valeur, hauteur);
    }

    public GLSListCheckBox(int type, String nom, String libelle, Object objet, Object valeur, String restriction, int hauteur, int largeur) {
        super(type, nom, libelle, objet, valeur, restriction, hauteur, largeur);
    }

    public GLSListCheckBox(int type, String nom, String libelle, Object objet, Object valeur, String restriction, int hauteur) {
        super(type, nom, libelle, objet, valeur, restriction, hauteur);
    }

    public GLSListCheckBox(String nom, String libelle, Object objet, Object valeur, int hauteur) {
        super(nom, libelle, objet, valeur, hauteur);
    }

    @Override
    public Object getValeur() {
        return this.liste.getSelectedValues();
    }

    @Override
    public String getString() {
        return GLS.getString(this.liste.getSelectedValues());
    }

    public Object getPremierElementSelectionne() throws Exception {
        if (!GLS.estVide(this.liste.getSelectedValues())) {
            return this.liste.getSelectedValues()[0];
        }
        throw new Exception("AUCUN ELEMENT SELECTIONNE");
    }

    public void reinitialisationListe(Vector vector) {
        if (this.listeDefinition != null) {
            this.listeDefinition.setVector(vector);
        } else {
            this.listeDefinition = new GLSListDefinition(vector);
        }
        this.reinitialisationListe(this.listeDefinition);
    }

    public void reinitialisationListe(GLSListDefinition listeDefinition) {
        if (listeDefinition != null && this.liste != null) {
            if (listeDefinition.getListCellRenderer() != null) {
                this.liste.setCellRenderer(listeDefinition.getListCellRenderer());
            }
            if (!GLS.estVide(listeDefinition.getVector())) {
                this.liste.setListData(listeDefinition.getVector());
            }
            this.liste.revalidate();
            this.liste.repaint();
        } else {
            this.initialisationListe(listeDefinition);
        }
    }

    public void initialisationListe(GLSListDefinition listeDefinition) {
        if (listeDefinition != null) {
            this.liste = !GLS.estVide(listeDefinition.getVector()) ? new CheckBoxJList(listeDefinition.getVector()) : new CheckBoxJList();
            if (listeDefinition.getListCellRenderer() != null) {
                this.liste.setCellRenderer(listeDefinition.getListCellRenderer());
            }
        } else {
            this.liste = new CheckBoxJList();
        }
    }

    @Override
    public void initialisationHandle() {
        this.listeDefinition = this.definition instanceof Vector ? new GLSListDefinition((Vector)this.definition) : (this.definition instanceof Object[] ? new GLSListDefinition(GLS.getVector((Object[])this.definition)) : (this.definition instanceof ListCellRenderer ? new GLSListDefinition((ListCellRenderer)this.definition) : (this.definition instanceof GLSListDefinition ? (GLSListDefinition)this.definition : new GLSListDefinition())));
        this.initialisationListe(this.listeDefinition);
        this.liste.setBackground(GlsUI.COULEUR_FOND_LISTE);
        this.liste.setFont(GlsUI.FONT_LISTE);
        this.liste.addListSelectionListener(this);
    }

    @Override
    public void initialisationUIHandle() {
        this.initialiser(UI.creerPanneauAffichage(this.style, this.libelle, GlsUI.getImageStyleDefaut(this.style), GlsUI.getScollPane(this.liste), this.hauteur), true);
    }

    @Override
    public void setValeur(Object object) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (!(object instanceof GLSListDefinition)) break block5;
                        this.reinitialisationListe((GLSListDefinition)object);
                        break block6;
                    }
                    if (!(object instanceof Vector)) break block7;
                    for (Object objetListe : (Vector)object) {
                        int i = GLS.getIndiceObjetListe(this.liste, objetListe);
                        if (GLS.estNulle(i) || this.liste.estCoche(i)) continue;
                        this.liste.selectionnerIndice(i, true);
                    }
                    break block6;
                }
                if (!(object instanceof Object[])) break block8;
                Object[] objectArray = (Object[])object;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object objetListe = objectArray[n2];
                    int i = GLS.getIndiceObjetListe(this.liste, objetListe);
                    if (!GLS.estNulle(i) && !this.liste.estCoche(i)) {
                        this.liste.selectionnerIndice(i, true);
                    }
                    ++n2;
                }
                break block6;
            }
            String[] val = GLS.getTableauString(object);
            if (GLS.estVide(val)) break block6;
            String[] stringArray = val;
            int n = val.length;
            int n3 = 0;
            while (n3 < n) {
                String v = stringArray[n3];
                int i = GLS.getIndiceObjetListe(this.liste, (Object)v);
                if (!GLS.estNulle(i) && !this.liste.estCoche(i)) {
                    this.liste.selectionnerIndice(i, true);
                }
                ++n3;
            }
        }
    }

    public int getNbElements() {
        return this.liste.getModel().getSize();
    }

    @Override
    public void activer(boolean etat) {
        this.liste.setEnabled(etat);
    }

    public GLSListDefinition getListeDefinition() {
        return this.listeDefinition;
    }

    public void setListeDefinition(GLSListDefinition listeDefinition) {
        this.reinitialisationListe(listeDefinition);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }
}

