/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui.saisie.composant;

import gls.outils.GLS;
import gls.outils.GLSHashMap;
import gls.outils.ui.GlsUI;
import gls.outils.ui.saisie.composant.ComposantSaisieGLS;
import gls.outils.ui.saisie.composant.definition.GLSListDefinition;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GLSList
extends ComposantSaisieGLS
implements ListSelectionListener {
    protected JList liste;
    protected GLSListDefinition listeDefinition;

    public GLSList(GLSHashMap config) {
        super(config);
    }

    public GLSList(int type, String nom, String libelle, Object objet, Object valeur, int hauteur) {
        super(type, nom, libelle, objet, valeur, hauteur);
    }

    public GLSList(int type, String nom, String libelle, Object objet, Object valeur, String restriction, int hauteur, int largeur) {
        super(type, nom, libelle, objet, valeur, restriction, hauteur, largeur);
    }

    public GLSList(int type, String nom, String libelle, Object objet, Object valeur, String restriction, int hauteur) {
        super(type, nom, libelle, objet, valeur, restriction, hauteur);
    }

    public GLSList(String nom, String libelle, Object objet, Object valeur, int hauteur) {
        super(nom, libelle, objet, valeur, hauteur);
    }

    @Override
    public Object getValeur() {
        return this.liste.getSelectedValues();
    }

    public Object getPremierElementSelectionne() throws Exception {
        if (!GLS.estVide(this.liste.getSelectedValues())) {
            return this.liste.getSelectedValues()[0];
        }
        throw new Exception("AUCUN ELEMENT SELECTIONNE");
    }

    public void reinitialisationListe(Vector vector) {
        if (this.listeDefinition != null) {
            this.listeDefinition.setVector(vector);
        } else {
            this.listeDefinition = new GLSListDefinition(vector);
        }
        this.reinitialisationListe(this.listeDefinition);
    }

    public void reinitialisationListe(GLSListDefinition listeDefinition) {
        if (listeDefinition != null && this.liste != null) {
            if (listeDefinition.getListCellRenderer() != null) {
                this.liste.setCellRenderer(listeDefinition.getListCellRenderer());
            }
            if (!GLS.estVide(listeDefinition.getVector())) {
                this.liste.setListData(listeDefinition.getVector());
            }
            this.liste.revalidate();
            this.liste.repaint();
        } else {
            this.initialisationListe(listeDefinition);
        }
    }

    public void initialisationListe(GLSListDefinition listeDefinition) {
        if (listeDefinition != null) {
            this.liste = !GLS.estVide(listeDefinition.getVector()) ? new JList(listeDefinition.getVector()) : new JList();
            if (listeDefinition.getListCellRenderer() != null) {
                this.liste.setCellRenderer(listeDefinition.getListCellRenderer());
            }
        } else {
            this.liste = new JList();
        }
    }

    @Override
    public void initialisationHandle() {
        this.listeDefinition = this.definition instanceof Vector ? new GLSListDefinition((Vector)this.definition) : (this.definition instanceof ListCellRenderer ? new GLSListDefinition((ListCellRenderer)this.definition) : (this.definition instanceof GLSListDefinition ? (GLSListDefinition)this.definition : new GLSListDefinition()));
        this.initialisationListe(this.listeDefinition);
        this.liste.setBackground(GlsUI.COULEUR_FOND_LISTE);
        this.liste.setFont(GlsUI.FONT_LISTE);
        this.liste.addListSelectionListener(this);
    }

    @Override
    public void initialisationUIHandle() {
        this.initialiser(UI.creerPanneauAffichage(this.style, this.libelle, GlsUI.getImageStyleDefaut(this.style), GlsUI.getScollPane(this.liste), this.hauteur), true);
    }

    @Override
    public void setValeur(Object object) {
        if (object instanceof GLSListDefinition) {
            this.reinitialisationListe((GLSListDefinition)object);
        } else if (object instanceof Vector) {
            for (Object objetListe : (Vector)object) {
                int i = GLS.getIndiceObjetListe(this.liste, objetListe);
                if (GLS.estNulle(i)) continue;
                this.liste.setSelectedIndex(i);
            }
        } else {
            int i = GLS.getIndiceObjetListe(this.liste, object);
            if (!GLS.estNulle(i)) {
                this.liste.setSelectedIndex(i);
            }
        }
    }

    public int getNbElements() {
        return this.liste.getModel().getSize();
    }

    @Override
    public void activer(boolean etat) {
        this.liste.setEnabled(etat);
    }

    public GLSListDefinition getListeDefinition() {
        return this.listeDefinition;
    }

    public void setListeDefinition(GLSListDefinition listeDefinition) {
        this.reinitialisationListe(listeDefinition);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }
}

