/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui.saisie.composant;

import gls.outils.GLS;
import gls.outils.GLSHashMap;
import gls.outils.ui.GlsUI;
import gls.outils.ui.saisie.composant.ComposantSaisieGLS;
import gls.outils.ui.saisie.composant.definition.GLSIntBoxDefinition;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class GLSDecimalBox
extends ComposantSaisieGLS
implements KeyListener {
    public static final String TYPE = GLSDecimalBox.class.getSimpleName();
    private JFormattedTextField choixValeur;
    private GLSIntBoxDefinition intBoxDefinition;

    public GLSDecimalBox(GLSHashMap config) {
        super(config);
    }

    public GLSDecimalBox(String nom, String libelle, Object objet, Object valeur, int hauteur) {
        super(nom, libelle, objet, valeur, hauteur);
    }

    public GLSDecimalBox(int type, String nom, String libelle, Object objet, Object valeur, int hauteur) {
        super(type, nom, libelle, objet, valeur, hauteur);
    }

    public GLSDecimalBox(int type, String nom, String libelle, Object objet, Object valeur, String restriction, int hauteur) {
        super(type, nom, libelle, objet, valeur, restriction, hauteur);
    }

    public GLSDecimalBox(int type, String nom, String libelle, Object objet, Object valeur, String restriction, int hauteur, int largeur) {
        super(type, nom, libelle, objet, valeur, restriction, hauteur, largeur);
    }

    @Override
    public void activer(boolean etat) {
        this.choixValeur.setEnabled(etat);
    }

    @Override
    public Object getValeur() {
        return this.choixValeur.getText();
    }

    @Override
    public void initialisationHandle() {
        if (this.definition != null && this.definition instanceof GLSIntBoxDefinition) {
            this.intBoxDefinition = (GLSIntBoxDefinition)this.definition;
        } else {
            this.intBoxDefinition = new GLSIntBoxDefinition();
            this.intBoxDefinition.setDefaut(0);
            this.intBoxDefinition.setMin(0);
            this.intBoxDefinition.setMax(100);
            this.intBoxDefinition.setStep(1);
        }
        this.choixValeur = new JFormattedTextField();
        this.choixValeur.setFocusLostBehavior(0);
        DecimalFormat numFormat = new DecimalFormat("###.#");
        NumberFormatter num1 = new NumberFormatter(numFormat);
        num1.setAllowsInvalid(true);
        num1.setMaximum(new Double(this.intBoxDefinition.getMax()));
        num1.setMinimum(new Double(this.intBoxDefinition.getMin()));
        num1.setCommitsOnValidEdit(true);
        DefaultFormatterFactory factory = new DefaultFormatterFactory(num1, num1, num1);
        this.choixValeur.setFormatterFactory(factory);
    }

    @Override
    public void initialisationUIHandle() {
        this.initialiser(UI.creerPanneauAffichage(this.style, this.libelle, GlsUI.getImageStyleDefaut(this.style), this.choixValeur, this.hauteur), false);
    }

    @Override
    public void setValeur(Object object) {
        this.choixValeur.setText(GLS.getString(object));
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyChar() == '\u007f' || e.getKeyChar() == '\b') {
            this.choixValeur.setText("");
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

