/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui.saisie.composant;

import cartoj.CartesG2;
import cartoj.ICouche;
import gls.geometry.GeoPoint;
import gls.localisation.recherche.Recherche;
import gls.outils.GLS;
import gls.outils.GLSHashMap;
import gls.outils.ui.saisie.composant.GLSLabelBox;

public class GLSCoucheBox
extends GLSLabelBox {
    public static final String TYPE = "GLSCoucheBox";
    private static final int CHAMP_NOM_COUCHE = 0;
    private static final int CHAMP_NUM_CHAMP_COUCHE = 1;
    private static final int CHAMP_NUM_CHAMP_DISTANCE = 2;
    private String nomCouche;
    private int champCouche;
    private int distanceRecherche;

    public GLSCoucheBox(int type, String nom, String libelle, Object objet, Object valeur, String restriction, int hauteur) {
        super(type, nom, libelle, objet, valeur, restriction, hauteur);
    }

    public GLSCoucheBox(String nom, String libelle, Object objet, Object valeur, int hauteur) {
        super(nom, libelle, objet, valeur, hauteur);
    }

    public GLSCoucheBox(int type, String nom, String libelle, Object objet, Object valeur, int hauteur) {
        super(type, nom, libelle, objet, valeur, hauteur);
    }

    public GLSCoucheBox(GLSHashMap config) {
        super(config);
    }

    @Override
    public void initialisationHandle() {
        if (this.definition != null) {
            String[] coucheCarto = null;
            if (this.definition instanceof String[]) {
                coucheCarto = (String[])this.definition;
            } else if (this.definition instanceof String) {
                coucheCarto = GLS.getTableauString((String)this.definition, ";");
            }
            if (!GLS.estVide(coucheCarto)) {
                this.nomCouche = coucheCarto[0];
                this.champCouche = coucheCarto.length > 1 ? GLS.getInt(coucheCarto[1], 0) : 0;
                this.distanceRecherche = coucheCarto.length > 2 ? GLS.getInt(coucheCarto[2], 0) : 1;
            } else {
                this.nomCouche = null;
                this.champCouche = -1;
                this.distanceRecherche = -1;
            }
        } else {
            this.nomCouche = null;
            this.champCouche = -1;
            this.distanceRecherche = -1;
        }
        super.initialisationHandle();
    }

    public void setValeur(CartesG2 carte, GeoPoint point) {
        ICouche couche;
        if (carte != null && point != null && this.nomCouche != null && (couche = carte.getCouche(this.nomCouche)) != null) {
            this.setValeur(Recherche.getChampEnregistrement(this.champCouche, Recherche.rechercherPremierEnregistrementDistance(couche, point, this.distanceRecherche)));
        }
    }
}

