/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui.saisie.composant;

import gls.outils.GLS;
import gls.outils.GLSHashMap;
import gls.outils.ui.GlsUI;
import gls.outils.ui.saisie.composant.ComposantSaisieGLS;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;

public class GLSCheckBox
extends ComposantSaisieGLS {
    public static final String TYPE = "GLSCheckBox";
    private JCheckBox check;

    public GLSCheckBox(int type, String nom, String libelle, Object objet, Object valeur, String restriction, int hauteur) {
        super(type, nom, libelle, objet, valeur, restriction, hauteur, 416);
    }

    public GLSCheckBox(int type, String nom, String libelle, Object objet, Object valeur, int hauteur) {
        super(type, nom, libelle, objet, valeur, hauteur);
    }

    public GLSCheckBox(String nom, String libelle, Object objet, Object valeur, int hauteur) {
        super(nom, libelle, objet, valeur, hauteur);
    }

    public GLSCheckBox(GLSHashMap config) {
        super(config);
    }

    @Override
    public Object getValeur() {
        return GLS.getString(this.check.isSelected());
    }

    @Override
    public boolean getBoolean() {
        return this.check.isSelected();
    }

    @Override
    public void initialisationHandle() {
        this.check = this.definition != null ? new JCheckBox(GLS.getString(this.definition)) : new JCheckBox();
        this.check.setBackground(GlsUI.COULEUR_FOND_CHECKBOX);
        this.check.setFont(GlsUI.FONT_CHECKBOX);
    }

    @Override
    public String getPhrase() {
        return this.getPhrase(this.check.isSelected());
    }

    @Override
    public String getPhrase(String valeur) {
        return this.getPhrase(GLS.getBoolean(valeur, false));
    }

    public String getPhrase(boolean valeur) {
        String lib = GLS.estVide(GLS.getString(this.definition)) ? GLS.getString(this.definition) : this.libelle;
        if (valeur) {
            return this.getPhrase(lib, "oui");
        }
        return this.getPhrase(lib, "non");
    }

    @Override
    public void initialisationUIHandle() {
        this.initialiser(UI.creerPanneauAffichage(this.style, this.libelle, GlsUI.getImageStyleDefaut(this.style), this.check, this.hauteur), false);
    }

    @Override
    public void setValeur(Object object) {
        this.check.setSelected(GLS.getBoolean(GLS.getString(object)));
    }

    public void addActionListener(ActionListener a) {
        this.check.addActionListener(a);
        this.check.setActionCommand(this.nom);
    }

    @Override
    public void activer(boolean etat) {
        this.check.setEnabled(etat);
    }
}

