/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui.saisie.composant;

import gls.outils.GLS;
import gls.outils.GLSDate;
import gls.outils.GLSHashMap;
import gls.outils.ui.GlsUI;
import gls.outils.ui.saisie.composant.ComposantSaisieGLS;
import gls.outils.ui.saisie.composant.definition.MonCalendrier;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class GLSCalendarBox
extends ComposantSaisieGLS {
    public static final String TYPE = "GLSCalendarBox";
    public static String[] HEURE;
    public static String[] MINUTE;
    public static NumberFormat numberFormat;
    public static final int LARGEUR_DATE_DEFAUT = 60;
    public static final int LARGEUR_HEURE_DEFAUT = 120;
    public static final int TYPE_DATE_HEURE = 0;
    public static final int TYPE_DATE = 1;
    public static final int TYPE_HEURE = 2;
    private int typeCalendrier;
    private Calendar calendar;
    private MonCalendrier calendarComboBox;
    private JPanel panneauDate;
    private JPanel jpHeure;
    private JComboBox jcbHeures;
    private JComboBox jcbMinutes;

    static {
        numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setMinimumIntegerDigits(2);
        numberFormat.setMaximumFractionDigits(0);
        numberFormat.setGroupingUsed(false);
        HEURE = new String[24];
        int i = 0;
        while (i < 24) {
            GLSCalendarBox.HEURE[i] = numberFormat.format(i);
            ++i;
        }
        MINUTE = new String[60];
        i = 0;
        while (i < 60) {
            GLSCalendarBox.MINUTE[i] = numberFormat.format(i);
            ++i;
        }
    }

    public GLSCalendarBox(GLSHashMap config) {
        super(config);
    }

    public GLSCalendarBox(String nom, String libelle, Object objet, Object valeur, int hauteur) {
        super(nom, libelle, objet, valeur, hauteur);
    }

    public GLSCalendarBox(int type, String nom, String libelle, Object objet, Object valeur, int hauteur) {
        super(type, nom, libelle, objet, valeur, hauteur);
    }

    public GLSCalendarBox(int type, String nom, String libelle, Object objet, Object valeur, String restriction, int hauteur) {
        super(type, nom, libelle, objet, valeur, restriction, hauteur);
    }

    public GLSCalendarBox(int type, String nom, String libelle, Object objet, Object valeur, String restriction, int hauteur, int largeur) {
        super(type, nom, libelle, objet, valeur, restriction, hauteur, largeur);
    }

    @Override
    public void activer(boolean etat) {
        this.calendarComboBox.setEnabled(etat);
        this.jcbHeures.setEnabled(etat);
        this.jcbMinutes.setEnabled(etat);
    }

    private Date getDateHeure() {
        GLS.getDate();
        Calendar c = GLSDate.maintenant();
        c.set(11, this.jcbHeures.getSelectedIndex());
        c.set(12, this.jcbMinutes.getSelectedIndex());
        return c.getTime();
    }

    private void initialisationCalendrier() {
        switch (this.typeCalendrier) {
            case 0: {
                GLSDate.copie(this.calendarComboBox.getDate(), this.calendar);
                GLSDate.setHeure(this.calendar, this.getDateHeure());
                break;
            }
            case 1: {
                GLSDate.copie(this.calendarComboBox.getDate(), this.calendar);
                break;
            }
            case 2: {
                GLSDate.setHeure(this.calendar, this.getDateHeure());
            }
        }
    }

    @Override
    public Object getValeur() {
        this.initialisationCalendrier();
        return this.calendar;
    }

    @Override
    public String getString() {
        switch (this.typeCalendrier) {
            case 0: {
                return this.getString(GLSDate.formatDate);
            }
            case 1: {
                return this.getString(GLSDate.formatDateJour);
            }
            case 2: {
                return this.getString(GLSDate.formatHeure);
            }
        }
        return "";
    }

    private DateFormat getDateFormat() {
        switch (this.typeCalendrier) {
            case 0: {
                return GLSDate.formatDate;
            }
            case 1: {
                return GLSDate.formatDateJour;
            }
            case 2: {
                return GLSDate.formatHeure;
            }
        }
        return GLSDate.formatDate;
    }

    public String getString(DateFormat format) {
        this.initialisationCalendrier();
        GLS.getLogs().debug((Object)GLSDate.toDate(this.calendar, format));
        return GLSDate.toDate(this.calendar, format);
    }

    public Calendar getCalendar() {
        this.initialisationCalendrier();
        return this.calendar;
    }

    @Override
    public void initialisationHandle() {
        this.typeCalendrier = GLS.getInt(this.definition, 0);
        this.calendar = GregorianCalendar.getInstance();
    }

    @Override
    public void initialisationUIHandle() {
        this.panneauDate = new JPanel(new BorderLayout());
        this.jcbHeures = new JComboBox<String>(HEURE);
        this.jcbMinutes = new JComboBox<String>(MINUTE);
        this.jcbHeures.setFont(GlsUI.FONT_CALENDRIER);
        this.jcbMinutes.setFont(GlsUI.FONT_CALENDRIER);
        this.jpHeure = new JPanel(new GridLayout(1, 2, 4, 4));
        this.jpHeure.add(this.jcbHeures);
        this.jpHeure.add(this.jcbMinutes);
        this.jpHeure.setBackground(Color.white);
        this.jcbHeures.setBackground(Color.white);
        this.jcbMinutes.setBackground(Color.white);
        GLS.getDate();
        this.setDateHeure(GLSDate.maintenant());
        GLS.fixerTailleObjet(this.jpHeure, 120, this.hauteur);
        this.calendarComboBox = new MonCalendrier(this.hauteur);
        this.calendarComboBox.setFont(GlsUI.FONT_CALENDRIER);
        GLS.fixerTailleObjet((JComponent)((Object)this.calendarComboBox), 60, this.hauteur - 5);
        this.panneauDate.setBackground(Color.WHITE);
        switch (this.typeCalendrier) {
            case 0: {
                this.panneauDate.add((Component)((Object)this.calendarComboBox), "Center");
                this.panneauDate.add((Component)this.jpHeure, "East");
                break;
            }
            case 1: {
                this.panneauDate.add((Component)((Object)this.calendarComboBox), "Center");
                break;
            }
            case 2: {
                this.panneauDate.add((Component)this.jpHeure, "Center");
            }
        }
        this.initialiser(UI.creerPanneauAffichage(this.style, this.libelle, GlsUI.getImageStyleDefaut(this.style), this.panneauDate, this.hauteur), false);
    }

    @Override
    public void setValeur(Object object) {
        if (object instanceof Calendar) {
            this.calendar = (Calendar)object;
        } else if (object instanceof String) {
            try {
                GLS.getDate();
                this.calendar = GLSDate.toDate((String)object, this.getDateFormat());
            }
            catch (Exception e) {
                this.calendar = GregorianCalendar.getInstance();
                e.printStackTrace();
            }
        }
        if (this.calendar == null) {
            this.calendar = GregorianCalendar.getInstance();
        }
        this.calendarComboBox.setDate(this.calendar.getTime());
        this.setDateHeure(this.calendar);
    }

    private void setDateHeure(Calendar calendar) {
        this.jcbHeures.setSelectedIndex(calendar.get(11));
        this.jcbMinutes.setSelectedIndex(calendar.get(12));
    }
}

