/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui.saisie.composant;

import gls.outils.GLS;
import gls.outils.ui.ComposantGLS;
import gls.outils.ui.GlsUI;
import gls.outils.ui.saisie.composant.ComposantSaisieGLS;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ComposantsSaisieGLS
extends Vector<ComposantSaisieGLS> {
    private String nom;
    private String libelle;

    public String getLibelle() {
        return this.libelle;
    }

    public void setLibelle(String libelle) {
        this.libelle = libelle;
    }

    public ComposantsSaisieGLS() {
        this("", "");
    }

    public ComposantsSaisieGLS(String nom) {
        this(nom, nom);
    }

    public ComposantsSaisieGLS(String nom, String libelle) {
        this.nom = nom;
        this.libelle = libelle;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public void ajouter(ComposantSaisieGLS composant) {
        if (composant != null && GLS.estNulle(GLS.getIndiceObjetListe(this, (Object)composant.toString()))) {
            this.add(composant);
        }
    }

    public void ajouter(ComposantsSaisieGLS composants) {
        if (!GLS.estVide(composants)) {
            for (ComposantSaisieGLS composant : composants) {
                this.ajouter(composant);
            }
        }
    }

    public int getHauteur() {
        int hauteur = 0;
        for (ComposantSaisieGLS composant : this) {
            hauteur += composant.getHauteur();
        }
        return hauteur;
    }

    public int getLargeur() {
        if (!this.isEmpty()) {
            return ((ComposantSaisieGLS)this.get(0)).getLargeur();
        }
        return 0;
    }

    public boolean existe(String composant) {
        int i = GLS.getIndiceObjetListe(this, (Object)composant);
        return !GLS.estNulle(i);
    }

    public ComposantSaisieGLS get(String composant) throws Exception {
        int i = GLS.getIndiceObjetListe(this, (Object)composant);
        if (!GLS.estNulle(i)) {
            return (ComposantSaisieGLS)this.get(i);
        }
        throw new Exception("LE COMPOSANT " + composant + " N'EXISTE PAS");
    }

    public Vector<JComponent> toComponents() {
        Vector<JComponent> components = new Vector<JComponent>();
        for (ComposantGLS composant : this) {
            try {
                components.add(composant.getComposant());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return components;
    }

    public ComposantGLS getComposantGLS() {
        return ComposantGLS.toComposantGLS((JComponent)this.getComposant(), this.getHauteur(), this.getLargeur());
    }

    public JPanel getComposant() {
        return GlsUI.instanceOf().creerPanneauComposants(this);
    }

    public JPanel getComposantGrille() {
        return GlsUI.instanceOf().creerPanneauComposantsGrille(this);
    }

    public Box getComposantBox() {
        return GlsUI.instanceOf().creerPanneauComposantsBox(this);
    }

    public ComposantGLS getComposantGrilleGLS() {
        return ComposantGLS.toComposantGLS((JComponent)this.getComposantGrille(), this.getHauteur(), this.getLargeur());
    }
}

