/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui.saisie.composant;

import cartoj.Enregistrement;
import gls.outils.GLS;
import gls.outils.GLSHashMap;
import gls.outils.ui.ComposantGLS;
import gls.outils.ui.GlsUI;

public abstract class ComposantSaisieGLS
extends ComposantGLS {
    public static final String SEPARATEUR_LISTE = ";";
    protected static GlsUI UI = GLS.getUI();
    protected String nom;
    protected String libelle;
    protected Object valeur;
    protected int style;
    protected Object definition;
    protected String restriction;
    protected String parent;
    protected boolean active;
    protected GLSHashMap config;

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public ComposantSaisieGLS(GLSHashMap config) {
        this.initialisation(config);
    }

    public ComposantSaisieGLS(String nom, String libelle, Object objet, Object valeur, int hauteur) {
        this(GlsUI.STYLE_PANNEAU_AFFICHAGE, nom, libelle, objet, valeur, "", hauteur, 416);
    }

    public ComposantSaisieGLS(int type, String nom, String libelle, Object objet, Object valeur, int hauteur) {
        this(type, nom, libelle, objet, valeur, "", hauteur, 416);
    }

    public ComposantSaisieGLS(int type, String nom, String libelle, Object objet, Object valeur, String restriction, int hauteur) {
        this(type, nom, libelle, objet, valeur, restriction, hauteur, 416);
    }

    public ComposantSaisieGLS(int type, String nom, String libelle, Object objet, Object valeur, String restriction, int hauteur, int largeur) {
        this.config = new GLSHashMap();
        this.config.put("nom", nom);
        this.config.put("libelle", libelle);
        this.config.put("style", type);
        this.config.put("definition", objet);
        this.config.put("valeur", valeur);
        this.config.put("hauteur", hauteur);
        this.config.put("largeur", largeur);
        this.config.put("restriction", restriction);
        this.initialisation(this.config);
    }

    private void initialisation(GLSHashMap config) {
        this.config = config;
        if (config != null) {
            this.nom = config.getString("nom");
            this.libelle = config.getString("libelle");
            this.style = config.getInt("style", GlsUI.STYLE_PANNEAU_AFFICHAGE);
            this.definition = config.get("definition");
            this.valeur = config.get("valeur");
            this.hauteur = config.getInt("hauteur");
            this.largeur = config.getInt("largeur", 416);
            this.restriction = config.getString("restriction");
            if (this.style == -1) {
                this.style = GlsUI.STYLE_PANNEAU_AFFICHAGE;
            }
        }
        this.active = true;
        this.initialisationHandle();
        this.initialisationUIHandle();
        this.setValeur();
    }

    protected void setValeur() {
        if (this.valeur != null) {
            this.setValeur(this.valeur);
        }
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public abstract void initialisationHandle();

    public abstract void initialisationUIHandle();

    public String getPhrase() {
        return this.getPhrase(this.getLibelle(), this.getString());
    }

    public String getPhrase(String valeur) {
        return this.getPhrase(this.getLibelle(), valeur);
    }

    protected String getPhrase(String libelle, String valeur) {
        return GLS.getString(libelle).concat(" : ").concat(GLS.getString(valeur));
    }

    public void effacer() {
        this.setValeur("");
    }

    public abstract void setValeur(Object var1);

    public abstract Object getValeur();

    public abstract void activer(boolean var1);

    public void setValeur(Enregistrement enregistrement) {
        if (enregistrement != null) {
            int indice;
            try {
                indice = GLS.getIndiceChamp(enregistrement.getFichierDon(), this.nom);
            }
            catch (Exception e) {
                indice = -1;
            }
            if (!GLS.estNulle(indice)) {
                this.setValeur(enregistrement.getValeur(indice));
            }
        }
    }

    public String getString() {
        return GLS.getString(this.getValeur(), "");
    }

    public int getInt() {
        return GLS.getInt(this.getString(), -1);
    }

    public double getDouble() {
        return GLS.getDouble(this.getString(), -1.0);
    }

    public boolean getBoolean() {
        return GLS.getBoolean(this.getString());
    }

    public float getFloat() {
        return (float)this.getDouble();
    }

    public String toString() {
        return this.nom;
    }

    public boolean equals(Object objet) {
        return this.nom.equals(GLS.getString(objet));
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getRestriction() {
        return this.restriction;
    }

    public void setRestriction(String restriction) {
        this.restriction = restriction;
    }

    public String getLibelle() {
        return this.libelle;
    }

    public void setLibelle(String libelle) {
        this.libelle = libelle;
    }
}

