/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui.msgbox;

import gls.outils.GLS;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MsgBox
extends JDialog
implements ActionListener {
    private JLabel jlMessage;
    private JLabel jlIcone;
    private JButton jbOk;
    private JButton jbNon;
    private JButton jbOui;
    private JPanel jpBoutons;
    private static JFrame frame;
    private boolean messageRetour = false;
    public static final int TYPE_ERREUR = 0;
    public static final int TYPE_INFO = 1;
    public static final int TYPE_QUESTION = 2;
    public static final int jOkOnly = 0;
    public static final int jOkCancel = 1;
    private static ImageIcon ICONE_ERREUR;
    private static ImageIcon ICONE_INFO;
    private static ImageIcon ICONE_QUESTION;
    private static ImageIcon imageOk;
    private static ImageIcon imageOui;
    private static ImageIcon imageNon;
    private static final String ACTION_OUI = "oui";
    private static final String ACTION_NON = "non";
    private static final String ACTION_OK = "ok";
    private static MsgBox msgBox;

    static {
        ICONE_ERREUR = new ImageIcon("images/iconeMessageErreur.jpg");
        ICONE_INFO = new ImageIcon("images/iconeMessageInfo.jpg");
        ICONE_QUESTION = new ImageIcon("images/iconeMessageQuestion.jpg");
    }

    private MsgBox(JFrame frame) {
        super(frame);
        this.init();
    }

    public static void initFrame(JFrame frame) {
        MsgBox.frame = frame;
        if (msgBox != null) {
            msgBox = null;
            msgBox = new MsgBox(frame);
        }
    }

    public static boolean afficherErreur(String message) {
        return MsgBox.instanceOf().afficherMessageTexte(message, 0);
    }

    public static boolean afficherInfo(String message) {
        return MsgBox.instanceOf().afficherMessageTexte(message, 1);
    }

    public static boolean afficherQuestion(String message) {
        return MsgBox.instanceOf().afficherMessageTexte(message, 2);
    }

    public static boolean afficher(String message, int type) {
        return MsgBox.instanceOf().afficherMessageTexte(message, type);
    }

    private boolean afficherMessageTexte(String message, int type) {
        this.getContentPane().removeAll();
        JPanel jpMessage = new JPanel(new BorderLayout());
        this.jlMessage = null;
        this.jlMessage = new JLabel();
        this.jlMessage.setFont(GLS.getFont("Arial", 14, false));
        this.jlIcone = null;
        this.jlIcone = new JLabel();
        switch (type) {
            case 0: {
                this.jlMessage.setBackground(new Color(255, 175, 150));
                this.jlMessage.setOpaque(true);
                this.jlMessage.setBorder(BorderFactory.createLineBorder(new Color(255, 94, 41), 4));
                this.jlIcone.setIcon(ICONE_ERREUR);
                break;
            }
            case 1: {
                this.jlMessage.setBackground(new Color(184, 220, 255));
                this.jlMessage.setOpaque(true);
                this.jlMessage.setBorder(BorderFactory.createLineBorder(new Color(120, 174, 255), 4));
                this.jlIcone.setIcon(ICONE_INFO);
                break;
            }
            case 2: {
                this.jlMessage.setBackground(new Color(184, 220, 255));
                this.jlMessage.setOpaque(true);
                this.jlMessage.setBorder(BorderFactory.createLineBorder(new Color(120, 174, 255), 4));
                this.jlIcone.setIcon(ICONE_QUESTION);
            }
        }
        GLS.fixerTailleObjet(this.jlMessage, 246, 68);
        GLS.fixerTailleObjet(jpMessage, 308, 68);
        jpMessage.add((Component)this.jlMessage, "Center");
        jpMessage.add((Component)this.jlIcone, "East");
        this.jlMessage.setText(MsgBox.toHtml(message));
        this.getContentPane().add((Component)jpMessage, "Center");
        if (type != 2) {
            this.getContentPane().add((Component)this.jbOk, "South");
        } else {
            this.initialiserBoutonOuiNon(imageOui, imageNon);
            this.getContentPane().add((Component)this.jpBoutons, "South");
        }
        this.pack();
        Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension mysize = this.getSize();
        this.setLocation((screensize.width - mysize.width) / 2, (screensize.height - mysize.height) / 2);
        screensize = null;
        mysize = null;
        this.setAlwaysOnTop(true);
        this.setVisible(true);
        return this.messageRetour;
    }

    public static String toHtml(String ligne) {
        return "<html><body><center>" + ligne + "</center></body></html>";
    }

    private void initialiserBoutonOuiNon(ImageIcon imgOui, ImageIcon imgNon) {
        this.jbOui.setIcon(imgOui);
        this.jbNon.setIcon(imgNon);
    }

    private static MsgBox instanceOf() {
        if (msgBox == null) {
            msgBox = frame != null ? new MsgBox(frame) : new MsgBox();
        }
        return msgBox;
    }

    private MsgBox() {
        this.init();
    }

    private void init() {
        this.setUndecorated(true);
        this.getContentPane().setBackground(Color.white);
        imageOk = new ImageIcon("images/btOk.jpg");
        imageOui = new ImageIcon("images/btoui.jpg");
        imageNon = new ImageIcon("images/btnon.jpg");
        this.jlMessage = new JLabel();
        this.jlMessage.setOpaque(false);
        this.jlMessage.setFont(GLS.getFont("Arial", 14, false));
        this.jlMessage.setAutoscrolls(true);
        this.jbOk = new JButton(imageOk);
        this.jbOui = new JButton(imageOui);
        this.jbNon = new JButton(imageNon);
        this.jbOk.setActionCommand(ACTION_OK);
        this.jbNon.setActionCommand(ACTION_NON);
        this.jbOui.setActionCommand(ACTION_OUI);
        this.jbOk.setBackground(Color.white);
        this.jbNon.setBackground(Color.white);
        this.jbOui.setBackground(Color.white);
        this.jbOk.addActionListener(this);
        this.jbNon.addActionListener(this);
        this.jbOui.addActionListener(this);
        this.jpBoutons = new JPanel(new GridLayout(1, 2));
        this.jbOk.setBorder(BorderFactory.createEmptyBorder());
        this.jbNon.setBorder(BorderFactory.createEmptyBorder());
        this.jbOui.setBorder(BorderFactory.createEmptyBorder());
        this.jlMessage.setBorder(BorderFactory.createEmptyBorder());
        this.jpBoutons.setBorder(BorderFactory.createEmptyBorder());
        this.jpBoutons.add(this.jbOui);
        this.jpBoutons.add(this.jbNon);
        this.getContentPane().setLayout(new GridLayout(2, 1));
        this.setModal(true);
        this.setAlwaysOnTop(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String bt = e.getActionCommand();
        if (bt.equals(ACTION_OK)) {
            this.messageRetour = false;
            this.setVisible(false);
        } else if (bt.equals(ACTION_OUI)) {
            this.messageRetour = true;
            this.setVisible(false);
        } else if (bt.equals(ACTION_NON)) {
            this.messageRetour = false;
            this.setVisible(false);
        }
    }
}

