/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui.checkboxlist;

import gls.outils.ui.checkboxlist.CanEnable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class CheckBoxListCellRenderer
extends JComponent
implements ListCellRenderer {
    static Color listForeground;
    static Color listBackground;
    static Color listSelectionForeground;
    static Color listSelectionBackground;
    private DefaultListCellRenderer defaultComp;
    private JCheckBox checkbox;

    static {
        UIDefaults uid = UIManager.getLookAndFeel().getDefaults();
        listForeground = uid.getColor("List.foreground");
        listBackground = uid.getColor("List.background");
        listSelectionForeground = uid.getColor("List.selectionForeground");
        listSelectionBackground = uid.getColor("List.selectionBackground");
    }

    public CheckBoxListCellRenderer() {
        this.setLayout(new BorderLayout());
        this.defaultComp = new DefaultListCellRenderer();
        this.checkbox = new JCheckBox();
        this.add((Component)this.checkbox, "West");
        this.add((Component)this.defaultComp, "Center");
    }

    public JCheckBox getJCheckBox() {
        return this.checkbox;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.defaultComp.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        this.checkbox.setSelected(isSelected);
        Component[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            if (!((CanEnable)value).isEnabled()) {
                comps[i].setBackground(list.getBackground());
                comps[i].setForeground(UIManager.getColor("Label.disabledForeground"));
            } else {
                comps[i].setForeground(listForeground);
                comps[i].setBackground(listBackground);
            }
            ++i;
        }
        return this;
    }
}

