/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui.checkboxlist;

import gls.outils.ui.checkboxlist.CheckBoxListCellRenderer;
import gls.outils.ui.checkboxlist.ListItem;
import gls.outils.ui.checkboxlist.ListMouseListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;

public class CheckBoxJList
extends JList {
    private HashSet selectionCache = new HashSet();
    private int toggleIndex = -1;
    private boolean toggleWasSelected;

    public CheckBoxJList(Object[] liste) {
        this.setListData(liste);
        this.initialiser();
    }

    public CheckBoxJList(Vector liste) {
        this.setListData(liste);
        this.initialiser();
    }

    public CheckBoxJList() {
        this.initialiser();
    }

    public void initialiser() {
        this.setCellRenderer(new CheckBoxListCellRenderer());
        this.addMouseListener(new ListMouseListener(this));
    }

    public void toutSelectionner() {
        this.selectionCache.clear();
        int i = 0;
        while (i < this.getModel().getSize()) {
            this.selectionCache.add(new Integer(i));
            if (!this.getSelectionModel().isSelectedIndex(i)) {
                this.getSelectionModel().addSelectionInterval(i, i);
            }
            ++i;
        }
    }

    public void selectionnerIndices(Vector<Integer> listeIndices) {
        this.toutDeselectionner();
        for (int indice : listeIndices) {
            this.selectionnerIndice(indice);
        }
    }

    public void selectionnerIndice(int indice, boolean selectionner) {
        if (selectionner) {
            this.selectionnerIndice(indice);
        } else {
            this.deselectionnerIndice(indice);
        }
    }

    public void selectionnerIndice(int indice) {
        this.getSelectionModel().addSelectionInterval(indice, indice);
        this.selectionCache.add(new Integer(indice));
    }

    public void deselectionnerIndice(int indice) {
        if (this.getSelectionModel().isSelectedIndex(indice)) {
            this.getSelectionModel().removeSelectionInterval(indice, indice);
            this.selectionCache.remove(new Integer(indice));
        }
    }

    public void activerIndice(int indice, boolean etat) throws Exception {
        this.getListItem(indice).setEnabled(etat);
        this.repaint();
    }

    public void toutDeselectionner() {
        this.selectionCache.clear();
        int i = 0;
        while (i < this.getModel().getSize()) {
            if (this.getSelectionModel().isSelectedIndex(i)) {
                this.getSelectionModel().removeSelectionInterval(i, i);
            }
            ++i;
        }
    }

    public void selectionnerCache() {
        Iterator it = this.selectionCache.iterator();
        while (it.hasNext()) {
            int index = (Integer)it.next();
            this.getSelectionModel().addSelectionInterval(index, index);
        }
    }

    public void valueChanged(ListSelectionEvent lse) {
        if (!lse.getValueIsAdjusting()) {
            HashSet<Integer> newSelections = new HashSet<Integer>();
            int size = this.getModel().getSize();
            int i = 0;
            while (i < size) {
                if (this.getSelectionModel().isSelectedIndex(i)) {
                    newSelections.add(new Integer(i));
                }
                ++i;
            }
            this.selectionnerCache();
            for (Integer nextInt : newSelections) {
                int index = nextInt;
                if (this.selectionCache.contains(nextInt)) {
                    this.getSelectionModel().removeSelectionInterval(index, index);
                    continue;
                }
                this.getSelectionModel().addSelectionInterval(index, index);
            }
            this.selectionCache.clear();
            int i2 = 0;
            while (i2 < size) {
                if (this.getSelectionModel().isSelectedIndex(i2)) {
                    this.selectionCache.add(new Integer(i2));
                }
                ++i2;
            }
            this.toggleIndex = this.getSelectedIndex();
        }
    }

    public boolean estCoche(int i) {
        return this.getSelectionModel().isSelectedIndex(i);
    }

    @Override
    public Object[] getSelectedValues() {
        Object[] listeObjets = new Object[this.selectionCache.size()];
        int i = 0;
        Iterator it = this.selectionCache.iterator();
        while (it.hasNext()) {
            int index = (Integer)it.next();
            try {
                listeObjets[i] = this.getItem(index);
                ++i;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return listeObjets;
    }

    public int getNbItem() {
        return this.getModel().getSize();
    }

    public ListItem getListItem(int i) throws Exception {
        if (i >= 0 && i < this.getModel().getSize()) {
            return (ListItem)this.getModel().getElementAt(i);
        }
        throw new Exception();
    }

    public Object getItem(int i) throws Exception {
        return this.getListItem(i).getObject();
    }

    public void setListData(Vector liste) {
        if (liste != null && liste.size() > 0) {
            Vector<ListItem> listeListItem = new Vector<ListItem>();
            for (Object objet : liste) {
                listeListItem.add(new ListItem(objet));
            }
            super.setListData(listeListItem);
        }
    }

    public void setListData(Object[] liste) {
        if (liste != null && liste.length > 0) {
            Vector<ListItem> listeListItem = new Vector<ListItem>();
            Object[] objectArray = liste;
            int n = liste.length;
            int n2 = 0;
            while (n2 < n) {
                Object objet = objectArray[n2];
                listeListItem.add(new ListItem(objet));
                ++n2;
            }
            super.setListData(listeListItem);
        }
    }
}

