/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui.carto;

import gls.outils.fichier.MonFichier;
import gls.outils.ui.carto.ConstantesCarto;
import java.io.File;
import java.io.FilenameFilter;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class GenerateurFichierProjet
implements ConstantesCarto {
    private static final Logger LOG = Logger.getLogger(GenerateurFichierProjet.class);
    private final FiltreCarto filtreCartoCTR = new FiltreCarto("", ".ctr");
    private final FiltreCarto filtreCartoDON = new FiltreCarto("", ".don");
    private String cheminParametres;
    private String nomCarto;

    public GenerateurFichierProjet(String cheminParametres, String nomCarto) {
        this.cheminParametres = cheminParametres;
        this.nomCarto = nomCarto;
    }

    private String getNomFichierSansExtension(String nomFichier) {
        return nomFichier.substring(0, nomFichier.length() - 4);
    }

    private boolean aUnFichierDON(File[] fichiersDON, File fichierCTR) {
        boolean trouve = false;
        boolean fin = false;
        String nomFichierCTR = this.getNomFichierSansExtension(fichierCTR.getName());
        int i = 0;
        fin = i == fichiersDON.length;
        while (!trouve && !fin) {
            String nomFichierDONCourant = this.getNomFichierSansExtension(fichiersDON[i].getName());
            System.out.println("+--> Fichier CTR " + nomFichierCTR + " -- Fichier DON Courant - " + nomFichierDONCourant);
            if (nomFichierCTR.equals(nomFichierDONCourant)) {
                // empty if block
            }
            trouve = true;
            boolean bl = fin = ++i == fichiersDON.length;
        }
        return trouve;
    }

    public void genererFichierProjet() {
        File[] fichiersCartoDON;
        File[] fichiersCartoCTR;
        MonFichier fichierProjet;
        block37: {
            fichierProjet = null;
            String cheminFichiers = this.cheminParametres.concat(this.nomCarto).concat("/carto/");
            try {
                LOG.debug((Object)("+ Creation fichier projet " + cheminFichiers + " -- " + GregorianCalendar.getInstance().getTime().toString() + '\r'));
            }
            catch (Exception e) {
                System.out.println("#--> ERREUR ECRITURE FICHIER");
                return;
            }
            File dossierCarto = null;
            try {
                dossierCarto = new File(cheminFichiers);
            }
            catch (Exception e) {
                dossierCarto = null;
                try {
                    LOG.debug((Object)("# ERREUR OUVERTURE DOSSIER CARTO PROJET # " + e.toString() + '\r'));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            if (dossierCarto != null) {
                if (!dossierCarto.isDirectory()) {
                    dossierCarto = null;
                    try {
                        LOG.debug((Object)("# LE CHEMIN SPECIFIE NE DESIGNE PAS UN DOSSIER # " + cheminFichiers + '\r'));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return;
                }
            } else {
                try {
                    LOG.debug((Object)("# LE CHEMIN N'EST PAS VALIDE # " + cheminFichiers + '\r'));
                }
                catch (Exception e) {
                    // empty catch block
                }
                return;
            }
            fichiersCartoCTR = null;
            fichiersCartoDON = null;
            int nbFichiersCTR = 0;
            int nbFichiersDON = 0;
            boolean erreur = false;
            try {
                fichiersCartoCTR = dossierCarto.listFiles(this.filtreCartoCTR);
                nbFichiersCTR = fichiersCartoCTR.length;
                fichiersCartoDON = dossierCarto.listFiles(this.filtreCartoDON);
                nbFichiersDON = fichiersCartoDON.length;
                System.out.println("! Nombre de fichiers carto -- DON = " + nbFichiersDON + " -- CTR = " + nbFichiersCTR);
                LOG.debug((Object)("! Nombre de fichiers carto -- DON = " + nbFichiersDON + " -- CTR = " + nbFichiersCTR + '\r'));
                if (nbFichiersCTR == nbFichiersDON) {
                    String nomFichier;
                    int i = 0;
                    while (i < nbFichiersCTR) {
                        if (!this.aUnFichierDON(fichiersCartoDON, fichiersCartoCTR[i])) {
                            try {
                                LOG.debug((Object)("# ERREUR LE FICHIER CONTOUR " + fichiersCartoCTR[i].getName() + " N'A PAS DE FICHIER DON" + '\r'));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return;
                        }
                        ++i;
                    }
                    String nomFichierProjet = String.valueOf(this.cheminParametres) + this.nomCarto + "/carto/" + this.nomCarto + ".prj";
                    String ligneCartoFichierDON = "";
                    String ligneCartoFichierCTR = "";
                    String ligneCartoMemoireDON = "";
                    String ligneCartoMemoireCTR = "";
                    LOG.debug((Object)("# VERIFICATION DON CTR OK ! " + this.nomCarto));
                    System.out.println("+--> ECRITURE DU FICHIER PROJET");
                    try {
                        if (MonFichier.existe(nomFichierProjet)) {
                            MonFichier.supprimer(nomFichierProjet);
                        }
                    }
                    catch (Exception e) {
                        System.out.println("#--> ERREUR SUPPRESSION FICHIER");
                        return;
                    }
                    fichierProjet = new MonFichier(nomFichierProjet, 1);
                    fichierProjet.ecrire("atlasprj\r");
                    fichierProjet.ecrire(String.valueOf(this.cheminParametres) + this.nomCarto + "/carto/" + "\r");
                    fichierProjet.ecrire(String.valueOf(this.nomCarto) + "\r");
                    fichierProjet.ecrire("\r");
                    i = 0;
                    while (i < nbFichiersDON - 1) {
                        nomFichier = this.getNomFichierSansExtension(fichiersCartoDON[i].getName());
                        ligneCartoFichierDON = String.valueOf(ligneCartoFichierDON) + nomFichier + ".don,";
                        ligneCartoFichierCTR = String.valueOf(ligneCartoFichierCTR) + nomFichier + ".ctr,";
                        ++i;
                    }
                    nomFichier = this.getNomFichierSansExtension(fichiersCartoDON[i].getName());
                    ligneCartoFichierDON = String.valueOf(ligneCartoFichierDON) + nomFichier + ".don";
                    ligneCartoFichierCTR = String.valueOf(ligneCartoFichierCTR) + nomFichier + ".ctr";
                    fichierProjet.ecrire(String.valueOf(ligneCartoFichierDON) + '\r');
                    fichierProjet.ecrire(String.valueOf(ligneCartoMemoireDON) + '\r');
                    fichierProjet.ecrire(String.valueOf(ligneCartoFichierCTR) + '\r');
                    fichierProjet.ecrire(String.valueOf(ligneCartoMemoireCTR) + '\r');
                    fichierProjet.ecrire("route,");
                    i = 1;
                    while (i < nbFichiersDON) {
                        fichierProjet.ecrire(String.valueOf(i) + "," + i + ",0,");
                        ++i;
                    }
                    fichierProjet.ecrire(String.valueOf(i) + "," + i + ",0");
                    break block37;
                }
                try {
                    LOG.debug((Object)("# LE NOMBRE DE FICHIER DON N'EST PAS LE MEME QUE CELUI DES CTR # " + cheminFichiers + " --- CTR " + nbFichiersCTR + " --- DON " + nbFichiersDON + '\r'));
                }
                catch (Exception nomFichierProjet) {
                    // empty catch block
                }
                return;
            }
            catch (Exception e) {
                dossierCarto = null;
                fichiersCartoDON = null;
                fichiersCartoCTR = null;
                try {
                    LOG.debug((Object)("# ERREUR LISTAGE FICHIERS # " + e.toString() + '\r'));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
        }
        try {
            fichiersCartoDON = null;
            fichiersCartoCTR = null;
        }
        catch (Exception e) {
            try {
                LOG.debug((Object)("# ERREUR FERMETURE # " + e.toString() + '\r'));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            LOG.debug((Object)("+ Fin du traitement du fichier projet -- " + GregorianCalendar.getInstance().getTime().toString() + '\r'));
        }
        catch (Exception e) {
            System.out.println("#--> ERREUR ECRITURE FICHIER");
        }
        try {
            fichierProjet.fermer();
        }
        catch (Exception e) {
            System.out.println("#--> ERREUR FERMETURE FICHIERS");
        }
    }

    class FiltreCarto
    implements FilenameFilter {
        private String filtreDebutFichier;
        private String filtreExtensionFichier;

        public FiltreCarto(String debutFichier, String extensionFichier) {
            this.filtreDebutFichier = debutFichier;
            this.filtreExtensionFichier = extensionFichier.toLowerCase();
        }

        @Override
        public boolean accept(File file, String name) {
            return name.startsWith(this.filtreDebutFichier) && name.toLowerCase().endsWith(this.filtreExtensionFichier);
        }
    }
}

