/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui.carto;

import gls.geometry.GeoPoint;
import gls.localisation.Localisation;
import gls.localisation.LocalisationInfo;
import gls.localisation.alertc.LocalisantAlertc;
import gls.localisation.pr.LocalisantPr;
import gls.outils.GLS;
import gls.outils.OutilsCartoJ;
import gls.outils.fichier.FichierCONFIG;
import gls.outils.ui.carto.Carto;
import gls.outils.ui.carto.ConstantesCartoLocalisation;
import java.awt.event.MouseEvent;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class CartoLocalisation
extends Carto
implements ConstantesCartoLocalisation {
    private static final Logger LOG = Logger.getLogger(CartoLocalisation.class);
    protected Localisation localisationCourante;

    public CartoLocalisation(String cheminParametres, String nomCarto) throws Exception {
        super(cheminParametres, nomCarto);
    }

    @Override
    protected void initialisation() throws Exception {
        super.initialisation();
        this.initialisationLocalisationInfo();
    }

    public Localisation getLocalisationCourante() throws Exception {
        return this.getLocalisationCourante(false);
    }

    public Localisation getLocalisationCourante(boolean nouvelleLocalisationSiNulle) throws Exception {
        if (this.localisationCourante != null) {
            return this.localisationCourante;
        }
        if (nouvelleLocalisationSiNulle) {
            this.localisationCourante = null;
            this.localisationCourante = this.getNouvelleLocalisation();
            return this.localisationCourante;
        }
        throw new Exception("ERREUR LA LOCATION EST NULLE");
    }

    public void activerDoubleSens(boolean doubleSens) throws Exception {
        this.getLocalisationCourante().getSens().setDoubleSens(doubleSens);
        this.getLocalisationCourante().relocaliser();
        this.localisationAt(this.localisationCourante);
    }

    public void changerSens() throws Exception {
        if (this.localisationCourante.getSens().getSensEvenement() == 1) {
            this.localisationCourante.getSens().verifier(2);
        } else {
            this.localisationCourante.getSens().verifier(1);
        }
        this.localisationCourante.relocaliser();
        this.localisationAt(this.localisationCourante);
        this.dessinerLocalisation(this.localisationCourante);
    }

    public void localisationPR(String prDebut, String prFin, String route) throws Exception {
        this.localisationPR(new LocalisantPr(prDebut), new LocalisantPr(prFin), route);
    }

    public void localisationPR(LocalisantPr prDebut, LocalisantPr prFin, String route) throws Exception {
        this.getLocalisationCourante(true).relocaliser(prDebut, prFin, route, true);
        this.localisationAt(this.localisationCourante);
        this.dessinerLocalisation(this.localisationCourante);
    }

    public void localisationAlertc(String alertcDebut, String distanceDebut, String alertcFin, String distanceFin, String sens) throws Exception {
        this.localisationAlertc(new LocalisantAlertc(alertcDebut, distanceDebut), new LocalisantAlertc(alertcFin, distanceFin), sens);
    }

    public void localisationAlertc(LocalisantAlertc alertcDebut, LocalisantAlertc alertcFin, String sens) throws Exception {
        this.getLocalisationCourante(true).relocaliser(alertcDebut, alertcFin, -1.0, sens);
        this.localisationAt(this.localisationCourante);
        this.dessinerLocalisation(this.localisationCourante);
    }

    protected void chargerThemeTmp() {
        try {
            OutilsCartoJ.ajoutTheme(this.fichierProjet, "tmp");
            this.couchesPonctuelles.put(this.fichierProjet.getNbdon() - 1, "tmp");
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void clicDroit(GeoPoint point) {
    }

    @Override
    protected void chargerCouches() {
        this.chargerThemeTmp();
        super.chargerCouches();
    }

    protected abstract FichierCONFIG getConfig();

    protected void initialisationLocalisationInfo() {
        LocalisationInfo.initialiser(this.getConfig(), this.carte);
        LocalisationInfo.initialiserAlertc(this.cheminConfigCarto.concat(this.nomCarto).concat(".alertc"));
    }

    protected void clicLocalisation(GeoPoint point) {
        try {
            this.localisationCourante = this.getLocalisationAtPoint(point);
            this.localisationAt(this.localisationCourante);
            this.dessinerLocalisation(this.localisationCourante);
        }
        catch (Exception e) {
            LOG.error((Object)"ERREUR CARTO_LOCALISATION #", (Throwable)e);
            this.localisationCourante = null;
            this.erreurLocalisation(e);
        }
    }

    public abstract void erreurLocalisation(Exception var1);

    public abstract void localisationAt(Localisation var1);

    public void dessinerLocalisation(Localisation localisation) {
        try {
            OutilsCartoJ.supprimerEntitesCouche(this.carte, "tmp");
            OutilsCartoJ.ajoutObjetCouche(this.carte.getCouche("tmp"), new String[]{"null"}, localisation.getPoints());
            this.carte.dessineCarte();
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
        }
    }

    public void activerOutilLocalisation(boolean etat) throws Exception {
        this.activerOutil("localiser", etat);
    }

    @Override
    protected void clic(MouseEvent m) {
        GeoPoint point = this.getPoint(m);
        if (this.outilCourant.equals("localiser")) {
            this.clicLocalisation(point);
        } else {
            this.clic(point, this.outilCourant);
        }
    }

    @Override
    protected void clicDroit(MouseEvent m) {
        GeoPoint point = this.getPoint(m);
        if (this.outilCourant.equals("localiser")) {
            this.clicDistance(point);
        } else {
            this.clicDroit(point, this.outilCourant);
        }
    }

    public void clicDistance(GeoPoint point) {
        if (this.localisationCourante != null && this.localisationCourante.estPositionnee()) {
            try {
                if (this.localisationCourante.distanceAtPoint(point)) {
                    this.localisationCourante.relocaliser();
                    this.localisationAt(this.localisationCourante);
                    this.dessinerLocalisation(this.localisationCourante);
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    protected String[] genererMesOutils() {
        return GLS.concat(OUTILS_DEFAUT, OUTILS_LOCALISATION);
    }

    protected Localisation getNouvelleLocalisation() {
        return new Localisation(true, true, true, false);
    }

    public Localisation getLocalisationAtPoint(GeoPoint point) throws Exception {
        Localisation localisation = this.getNouvelleLocalisation();
        localisation.initialiser(point);
        localisation.relocaliser();
        if (localisation.estPositionnee()) {
            return localisation;
        }
        throw new Exception("LA LOCALISATION NE S'EST PAS PASSEE CORRECTEMENT");
    }

    public String[] getListeCommune() {
        String[] communes = LocalisationInfo.getListeNomsCommunes();
        int i = 0;
        while (i < communes.length) {
            if (LocalisationInfo.estCommuneAvecDepartement(communes[i])) {
                communes[i] = String.valueOf(communes[i].substring(2)) + " (" + communes[i].substring(0, 2) + ")";
            }
            ++i;
        }
        return communes;
    }

    public Vector getListeAxe() {
        Vector<String> routes = LocalisationInfo.getListeRoutes();
        return LocalisationInfo.sortRD(routes);
    }

    public Double[] getCommuneBounds(String commune) {
        return LocalisationInfo.getCommuneBounds(commune);
    }

    public Vector getListePR(String axe) {
        return LocalisationInfo.getListePr(axe);
    }

    public Double[] getAdresseBounds(String commune, String adresse) {
        return LocalisationInfo.getAdresseBounds(commune, adresse);
    }

    public Double[] getBoundsNumero(String commune, String adresse, String numero) {
        return LocalisationInfo.getNumeroBounds(commune, adresse, numero);
    }

    public Vector<String> getListeNumero(String commune, String adresse) {
        return LocalisationInfo.getListeNumero(commune, adresse);
    }

    public Vector<String> getListeAdresse(String commune) {
        return LocalisationInfo.getListeAdresse(commune);
    }

    public Double[] getPrBounds(String axe, String pr) {
        return LocalisationInfo.getPrBounds(axe, pr);
    }

    public void setLocalisationCourante(Localisation localisationCourante) {
        this.localisationCourante = localisationCourante;
    }
}

