/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui.carto;

import cartoj.Cartes;
import cartoj.CartesG2;
import cartoj.Couche;
import cartoj.CoucheD;
import cartoj.CoucheU;
import cartoj.CoucheUUniverselle;
import cartoj.Enregistrement;
import cartoj.FichierCont;
import cartoj.FichierProjet;
import gls.carto.StyleCouche;
import gls.geometry.GeoPoint;
import gls.outils.GLS;
import gls.outils.OutilsCartoJ;
import gls.outils.fichier.FichierCONFIG;
import gls.outils.ui.GlsUI;
import gls.outils.ui.carto.ConstantesCarto;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public abstract class Carto
extends JPanel
implements MouseListener,
ConstantesCarto,
ActionListener {
    private static final GlsUI UI = GlsUI.instanceOf();
    private static final Logger LOG = Logger.getLogger(Carto.class);
    protected boolean dessineCarteApresClic;
    protected String cheminParametres;
    protected FichierProjet fichierProjet;
    private FichierCONFIG configCarto;
    protected String nomCarto;
    protected Cartes carte;
    private Vector<JButton> boutonsOutils;
    private JPanel outils;
    private String[] mesOutils;
    protected String outilCourant;
    protected String cheminCarto;
    protected String cheminConfigCarto;
    protected String cheminImageTypeCarto;
    protected HashMap<Integer, String> couchesPonctuelles;
    protected HashMap<Integer, String> couchesLineaires;
    protected HashMap<Integer, String> couchesSurfaciques;
    private Vector<String> listeCouches;

    public Carto(String cheminParametres, String nomCarto) throws Exception {
        this.cheminParametres = cheminParametres;
        this.nomCarto = nomCarto;
        this.listeCouches = new Vector();
        this.cheminCarto = cheminParametres.concat(GLS.getString(this.getRepertoireCarto(), "/"));
        this.cheminConfigCarto = cheminParametres.concat(GLS.getString(this.getRepertoireConfig(), "/"));
        this.cheminImageTypeCarto = cheminParametres.concat(GLS.getString(this.getRepertoireCheminTypeEvenement(), "/"));
        this.initialisation();
        this.initialisationUI();
    }

    protected String getNomFichierPrj() {
        return this.nomCarto;
    }

    protected String getNomFichierConfig() {
        return this.nomCarto;
    }

    protected String getRepertoireCarto() {
        return this.nomCarto.concat("/carto/");
    }

    protected String getRepertoireConfig() {
        return this.nomCarto.concat("/config/");
    }

    protected String getRepertoireCheminTypeEvenement() {
        return this.nomCarto.concat("/images/type/");
    }

    protected void initialisation() throws Exception {
        this.initialisationCarto();
        this.initialisationOutils();
    }

    protected abstract String[] genererMesOutils();

    protected void initialisationOutils() {
        this.mesOutils = this.genererMesOutils();
        if (GLS.estVide(this.mesOutils)) {
            this.mesOutils = OUTILS_DEFAUT;
        }
        this.boutonsOutils = UI.creerBoutonsActions(1, this.mesOutils, this.mesOutils, this, 30);
        this.outils = UI.creerPanneauAction(this.boutonsOutils, 30, 400);
    }

    public JButton getOutil(String nomOutil) throws Exception {
        return GlsUI.getBouton(this.boutonsOutils, nomOutil);
    }

    public void activerOutil(String nomOutil, boolean etat) throws Exception {
        this.getOutil(nomOutil).setEnabled(etat);
    }

    protected void initialisationCarto() throws Exception {
        this.configCarto = new FichierCONFIG(this.cheminConfigCarto.concat(GLS.getString(this.getNomFichierConfig(), this.nomCarto)).concat(".jcfg"));
        this.carte = new CartesG2();
        this.fichierProjet = new FichierProjet(String.valueOf(this.cheminCarto) + GLS.getString(this.getNomFichierPrj(), this.nomCarto) + ".prj", this.cheminCarto);
        this.couchesPonctuelles = OutilsCartoJ.getCouchesPonctuelles(this.fichierProjet);
        this.couchesLineaires = OutilsCartoJ.getCouchesLineaires(this.fichierProjet);
        this.couchesSurfaciques = OutilsCartoJ.getCouchesSurfaciques(this.fichierProjet);
        this.chargerCouches();
    }

    protected abstract void chargerThemes();

    protected void chargerCouches() {
        this.chargerThemes();
        this.chargerCouches(this.couchesPonctuelles);
        this.chargerCouches(this.couchesLineaires);
        this.chargerCouches(this.couchesSurfaciques);
        this.carte.addMouseListener((MouseListener)this);
    }

    private void chargerCouches(HashMap<Integer, String> map) {
        for (int cle : map.keySet()) {
            String nomCouche = map.get(cle);
            this.ajouterCoucheCarto(nomCouche, cle, this.getStyleCoucheDefaut(nomCouche));
        }
    }

    protected StyleCouche getStyleCoucheDefaut(String nom) {
        return new StyleCouche(nom, 1.0f, Color.blue, Color.blue, 2, "", -1);
    }

    protected void initialisationUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.carte, "Center");
        this.add((Component)this.outils, "South");
    }

    public void ajouterCoucheCarto(String nomTheme, int indiceTheme, StyleCouche styleCouche) {
        StyleCouche styleCouchePerso = StyleCouche.chargerFichierStyle(nomTheme, this.configCarto, this.cheminCarto);
        boolean coucheVisible = styleCouchePerso == null ? true : styleCouchePerso.getZoomAffichage() != 0.0f;
        styleCouche.miseAJour(styleCouchePerso);
        CoucheD couche = null;
        if (styleCouche.getTypeCouche() == 1) {
            couche = new CoucheD(this.fichierProjet, 0, indiceTheme, 0, styleCouche.getNom(), styleCouche.getZoomAffichage(), styleCouche.getCouleurInterieure(), styleCouche.getCouleurExterieure(), styleCouche.getEpaisseur(), styleCouche.getImage(), 0, 0, styleCouche.getEtiquette(), 0, styleCouche.getPositionEtiquette(), styleCouche.getFont(), styleCouche.getCouleurFont());
            couche.setSeuilAffichageLibelle(styleCouche.getZoomAffichageLibelle(), Float.MAX_VALUE);
            couche.setEtiquetteVisible(true);
            couche.setChevauchement(false);
            couche.setLibelleAuDessus(true);
        } else if (styleCouche.getValeurs().length == styleCouche.getImages().length) {
            couche = new CoucheU(this.fichierProjet, 0, indiceTheme, styleCouche.getIndiceChamp(), styleCouche.getNom(), styleCouche.getZoomAffichage(), Float.MAX_VALUE, styleCouche.getValeurs(), styleCouche.getCouleursInterieures(), styleCouche.getCouleursExterieures(), styleCouche.getEpaisseurs(), styleCouche.getLibelleChamp(), styleCouche.getImages(), 0, 0, styleCouche.getEtiquette(), 0, styleCouche.getPositionEtiquette(), styleCouche.getFont(), styleCouche.getCouleurFont());
            couche.setSeuilAffichageLibelle(styleCouche.getZoomAffichageLibelle(), Float.MAX_VALUE);
            couche.setEtiquetteVisible(true);
            couche.setChevauchement(false);
            couche.setLibelleAuDessus(true);
        } else {
            couche = new CoucheUUniverselle(this.fichierProjet, 0, indiceTheme, styleCouche.getIndiceChamp(), styleCouche.getNom(), styleCouche.getZoomAffichage(), Float.MAX_VALUE, styleCouche.getValeurs(), styleCouche.getCouleursInterieures(), styleCouche.getCouleursExterieures(), styleCouche.getEpaisseurs(), styleCouche.getLibelleChamp(), styleCouche.getImages(), 0, 0, styleCouche.getEtiquette(), 0, styleCouche.getPositionEtiquette(), styleCouche.getFont(), styleCouche.getCouleurFont());
            couche.setSeuilAffichageLibelle(styleCouche.getZoomAffichageLibelle(), Float.MAX_VALUE);
            couche.setEtiquetteVisible(true);
            couche.setChevauchement(false);
            couche.setLibelleAuDessus(true);
        }
        if (couche != null) {
            this.carte.ajoutCouche((Couche)couche);
            this.listeCouches.add(nomTheme);
            couche.setVisible(coucheVisible);
        } else {
            GLS.getLogs().error((Object)"ERREUR DANS L'AJOUT DE LA COUCHE");
        }
    }

    public boolean estOutilZoom(String outil) {
        return outil.equals("zoomplus") || outil.equals("zoommoins") || outil.equals("pleinecran");
    }

    public Vector<String> getListeCouches() {
        return this.listeCouches;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.outilCourant = e.getActionCommand();
        if (this.outilCourant.equals("deplacer")) {
            this.carte.setOutilDeplacer();
        } else if (this.outilCourant.equals("zoomplus")) {
            this.carte.setOutilZoomPlus();
        } else if (this.outilCourant.equals("zoommoins")) {
            this.carte.setOutilZoomMoins();
        } else if (this.outilCourant.equals("pleinecran")) {
            this.carte.setOutilPleinEcran();
            this.carte.dessineCarte();
        } else {
            this.clicOutilMetier();
        }
    }

    private void clicOutilMetier() {
        this.carte.setNoOutil();
        this.clicOutilMetier(this.outilCourant);
    }

    public abstract void clicOutilMetier(String var1);

    public GeoPoint getPoint(MouseEvent m) {
        return new GeoPoint(this.carte.getPointInReelXY(m.getX(), m.getY()));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.dessineCarteApresClic = true;
        if (e.getButton() == 3) {
            this.clicDroit(e);
        } else if (e.getButton() == 1) {
            this.clic(e);
        }
        if (this.dessineCarteApresClic) {
            this.carte.dessineCarte();
        }
    }

    public Cartes getCarte() {
        return this.carte;
    }

    public GeoPoint getPoint(Couche couche, Enregistrement enregistrement) throws Exception {
        if (couche != null && enregistrement != null) {
            FichierCont cont = couche.getCont();
            return new GeoPoint(cont.getX(enregistrement.getNum())[0], cont.getY(enregistrement.getNum())[0]);
        }
        throw new Exception("ERREUR ## L'ENREGISTREMENT OU LA COUCHE EST VIDE");
    }

    protected void clic(MouseEvent m) {
        this.clic(this.getPoint(m), this.outilCourant);
    }

    protected void clicDroit(MouseEvent m) {
        this.clicDroit(this.getPoint(m), this.outilCourant);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public abstract void clic(GeoPoint var1, String var2);

    public abstract void clicDroit(GeoPoint var1, String var2);
}

