/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui;

import gls.outils.GLS;
import gls.outils.ui.ConstantesUI;
import gls.outils.ui.GlsUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class LabelGLS
extends JLabel
implements ConstantesUI {
    private ImageIcon image;
    private String libelle;

    public LabelGLS(String libelle, ImageIcon image) {
        this.image = image;
        this.libelle = libelle;
        this.initialisation();
    }

    public void initialisation() {
        if (this.image != null) {
            this.setIcon(this.image);
        } else {
            this.setOpaque(true);
            this.setBackground(Color.white);
        }
        if (GLS.estVide(this.libelle)) {
            this.setText(this.libelle);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        int maxY = (int)dimension.getHeight();
        int maxX = (int)dimension.getWidth();
        Point pointInitial = new Point(0, 0);
        Point pointFinal = new Point(maxX, maxY);
        graphics2D.fillRect(0, 0, maxX, maxY);
        if (this.image != null) {
            graphics2D.drawImage(this.image.getImage(), 0, 0, null);
        }
        graphics2D.setColor(Color.black);
        graphics2D.setFont(GlsUI.FONT_LABEL_GLS);
        if (this.libelle != null) {
            FontMetrics metrics = graphics2D.getFontMetrics();
            int width = metrics.stringWidth(this.libelle);
            int height = metrics.getHeight();
            graphics2D.drawString(this.libelle, 0, maxY * 7 / 10);
        }
    }

    public ImageIcon getImage() {
        return this.image;
    }

    public void setImage(ImageIcon image) {
        this.image = image;
    }

    public String getLibelle() {
        return this.libelle;
    }

    public void setLibelle(String libelle) {
        this.libelle = libelle;
    }
}

