/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui;

import gls.outils.ui.ComboAjustableListCellRenderer;
import gls.outils.ui.GlsUI;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class JComboBoxAjustable
extends JComboBox
implements PopupMenuListener {
    public static boolean AJUSTE_AFFICHAGE_DEFAUT = false;
    private static final long serialVersionUID = -4175497686287387685L;
    private boolean ajusteAffichage;
    private static final float COEFF_FONT = 2.0f;
    private float tailleBase = -1.0f;
    private float tailleAjustee;
    private Font fontBase;
    private Font fontAjustee;
    private ComboAjustableListCellRenderer renderer;
    private int largeurMax = -1;
    private boolean layingOut = false;

    public JComboBoxAjustable() {
        this.init();
    }

    public JComboBoxAjustable(Vector v) {
        super(v);
        this.init();
    }

    public JComboBoxAjustable(Object[] v) {
        super(v);
        this.init();
    }

    public void init() {
        this.ajusteAffichage = AJUSTE_AFFICHAGE_DEFAUT;
        if (this.ajusteAffichage) {
            this.addPopupMenuListener(this);
            this.initFont(this.getFont());
            this.setUI(new StyledComboBoxUI());
            this.setMaximumRowCount(10);
        }
    }

    public void setAjusteAffichage(boolean ajusteAffichage) {
        if (this.ajusteAffichage != ajusteAffichage) {
            this.setFont(this.getFont());
        }
    }

    public void initFont(Font f) {
        super.setFont(f);
        this.tailleBase = f.getSize();
        this.fontBase = f.deriveFont(this.tailleBase);
        if (this.ajusteAffichage) {
            this.tailleAjustee = (int)(this.tailleBase * 2.0f);
            this.fontAjustee = f.deriveFont(this.tailleAjustee);
            this.renderer = new ComboAjustableListCellRenderer(this);
            this.renderer.setFont(this.fontAjustee);
            this.setRenderer(this.renderer);
            this.calcMetrics();
        } else {
            this.tailleAjustee = this.tailleBase;
            this.fontAjustee = f.deriveFont(this.tailleAjustee);
        }
    }

    private void calcMetrics() {
        FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(this.fontAjustee);
        int largeurMax = -1;
        int i = 0;
        while (i < this.getModel().getSize()) {
            largeurMax = Math.max(metrics.stringWidth(this.getModel().getElementAt(i).toString()), largeurMax);
            ++i;
        }
        this.largeurMax = largeurMax += 50;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent arg0) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
        this.renderer.setFont(this.fontBase);
        this.setFont(this.fontBase);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
        this.renderer.setFont(this.fontAjustee);
        this.setFont(this.fontAjustee);
        this.calcMetrics();
    }

    @Override
    public void doLayout() {
        try {
            this.layingOut = true;
            super.doLayout();
        }
        finally {
            this.layingOut = false;
        }
    }

    @Override
    public Dimension getSize() {
        Dimension dim = super.getSize();
        if (!this.layingOut) {
            int t = this.getModel().getSize();
            dim.width = Math.max(dim.width, this.largeurMax);
        }
        return dim;
    }

    class StyledComboBoxUI
    extends MetalComboBoxUI {
        StyledComboBoxUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            BasicComboPopup popup = new BasicComboPopup(this.comboBox){

                @Override
                protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
                    return super.computePopupBounds(px, py, Math.max(JComboBoxAjustable.this.largeurMax, GlsUI.LARGEUR_COMPOSANT), ph + 100);
                }
            };
            popup.getAccessibleContext().setAccessibleParent(this.comboBox);
            popup.setLightWeightPopupEnabled(true);
            return popup;
        }
    }
}

