/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui;

import cartoj.CartesG2;
import gls.geometry.GeoPoint;
import gls.localisation.Localisation;
import gls.localisation.LocalisationInfo;
import gls.outils.ConstantesGLS;
import gls.outils.ui.InfoBulle;
import java.util.Vector;

public class InfoBulleLocalisation
extends InfoBulle {
    private Localisation localisation = new Localisation();

    public InfoBulleLocalisation(CartesG2 carte) {
        super(carte);
    }

    @Override
    public Vector<InfoBulle.LabelChamps> getLabels(GeoPoint point) {
        Vector<InfoBulle.LabelChamps> labels = new Vector<InfoBulle.LabelChamps>();
        try {
            this.localisation.relocaliser(point);
            if (this.localisation.estPositionnee() && this.localisation.getConstructionInfo() != null) {
                if (this.localisation.getPoint() != null) {
                    labels.add(new InfoBulle.LabelChamps("Point : (UTM) " + this.localisation.getPoint()));
                    labels.add(new InfoBulle.LabelChamps("Point : (LL) " + this.localisation.getPoint().toNewLL()));
                }
                if (this.localisation.getRoute() != null) {
                    labels.add(0, new InfoBulle.LabelChamps("Sur la route " + this.localisation.getRoute()));
                }
                if (!this.localisation.getAlertcDebut().estVide() && !this.localisation.getAlertcFin().estVide()) {
                    labels.add(0, new InfoBulle.LabelChamps("Point alertc debut " + this.localisation.getAlertcDebut().getEntiteAlertc().getLibelle() + " (" + this.localisation.getAlertcDebut() + ")"));
                    labels.add(0, new InfoBulle.LabelChamps("Point alertc fin " + this.localisation.getAlertcFin().getEntiteAlertc().getLibelle() + " (" + this.localisation.getAlertcFin() + ")"));
                }
                if (!this.localisation.getPrDebut().estVide() && !this.localisation.getPrFin().estVide()) {
                    if (this.localisation.getPrDebut().equals(this.localisation.getPrFin()) && this.localisation.getPrDebut().getDistancePr() == this.localisation.getPrFin().getDistancePr()) {
                        labels.add(0, new InfoBulle.LabelChamps("Au PR " + this.localisation.getPrDebut()));
                    } else {
                        labels.add(0, new InfoBulle.LabelChamps("Du PR " + this.localisation.getPrDebut() + " au PR " + this.localisation.getPrFin()));
                    }
                }
                if (!ConstantesGLS.estVide(this.localisation.getCommune())) {
                    labels.add(new InfoBulle.LabelChamps("Commune : " + this.localisation.getCommune()));
                }
            }
        }
        catch (Exception e) {
            LocalisationInfo.ecrireLogDebug("#--> ERREUR LOCALISATION " + e);
        }
        return labels;
    }
}

