/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui;

import cartoj.CartesG2;
import gls.geometry.GeoPoint;
import gls.geometry.GeoPositionnement;
import gls.localisation.InfoTroncon;
import gls.localisation.LocalisationInfo;
import gls.localisation.recherche.Recherche;
import gls.outils.ui.InfoBulle;
import java.util.Iterator;
import java.util.Vector;

public class InfoBulleDebug
extends InfoBulle {
    private static final String DECALAGE = "   ";

    public InfoBulleDebug(CartesG2 cartes) {
        super(cartes);
    }

    @Override
    public Vector<InfoBulle.LabelChamps> getLabels(GeoPoint point) {
        Vector<InfoTroncon> listeTroncons = Recherche.getTroncons(LocalisationInfo.LISTE_ROUTES, point, 30);
        Vector<InfoBulle.LabelChamps> listeLabels = new Vector<InfoBulle.LabelChamps>();
        if (listeTroncons != null) {
            Iterator<InfoTroncon> iterator = listeTroncons.iterator();
            while (iterator.hasNext()) {
                InfoTroncon obj;
                InfoTroncon troncon = obj = iterator.next();
                GeoPositionnement position = new GeoPositionnement(point, troncon);
                listeLabels.add(0, new InfoBulle.LabelChamps(String.valueOf(troncon.getNom()) + " (" + troncon.getCouche().getNom() + " - " + troncon.getIdgdf() + ")"));
                listeLabels.add(0, new InfoBulle.LabelChamps(DECALAGE.concat("DIST PRJ : " + position.getDistanceProjection())));
                listeLabels.add(0, new InfoBulle.LabelChamps(DECALAGE.concat("DF : " + troncon.getDF() + " - LNG : " + troncon.getLongueur())));
                listeLabels.add(0, new InfoBulle.LabelChamps(DECALAGE.concat("EXT : " + troncon.getPointDebut() + " --> " + troncon.getPointFin())));
                listeLabels.add(0, new InfoBulle.LabelChamps(DECALAGE.concat("ALC : " + troncon.getValeur(8) + " - " + troncon.getValeur(9))));
                listeLabels.add(0, new InfoBulle.LabelChamps(DECALAGE.concat("PR : " + troncon.getValeur(6) + " - " + troncon.getValeur(7))));
            }
        }
        listeLabels.add(0, new InfoBulle.LabelChamps(point.toNewLL().toString()));
        return listeLabels;
    }
}

