/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui;

import cartoj.CartesG2;
import cartoj.Enregistrement;
import cartoj.ICouche;
import gls.geometry.GeoPoint;
import gls.localisation.LocalisationInfo;
import gls.outils.ConstantesGLS;
import gls.outils.GLS;
import gls.outils.fichier.FichierINFOBULLE;
import gls.outils.ui.InfoBulle;
import java.util.Vector;

public class InfoBulleCouche
extends InfoBulle {
    protected Vector listeCouchesRecherche;

    public InfoBulleCouche(CartesG2 carte, String fichierInfoBulle) {
        super(carte);
        this.initialiser(fichierInfoBulle);
    }

    public InfoBulleCouche(CartesG2 carte) {
        super(carte);
        this.initialiser();
    }

    protected void initialiser() {
        this.listeCouchesRecherche = new Vector();
        int i = 0;
        while (i < this.cartes.getNbcouches()) {
            this.listeCouchesRecherche.add(new CoucheLabel(this.cartes.getCouche(i)));
            ++i;
        }
    }

    private void initialiser(String fichierInfoBulle) {
        FichierINFOBULLE infoBulles = new FichierINFOBULLE(fichierInfoBulle);
        if (infoBulles.estVide()) {
            LocalisationInfo.ecrireLog("+--> Le fichier infobulles est vide. Chargement de toutes les couches");
            this.initialiser();
        } else {
            LocalisationInfo.ecrireLog("+--> Le fichier infobulles n'est pas vide " + infoBulles.getNbChamps());
            this.listeCouchesRecherche = new Vector();
            int i = 0;
            while (i < infoBulles.getNbChamps()) {
                Vector vec = infoBulles.getChamps(i);
                if (vec != null) {
                    LocalisationInfo.ecrireLog("+--> Le vecteur nest pas nul " + vec);
                    this.listeCouchesRecherche.add(new CoucheLabel(infoBulles.getCouche(i), (int[])vec.get(0), (String[])vec.get(1), (String[])vec.get(2)));
                }
                ++i;
            }
        }
    }

    @Override
    public Vector<InfoBulle.LabelChamps> getLabels(GeoPoint point) {
        Vector<InfoBulle.LabelChamps> labels = new Vector<InfoBulle.LabelChamps>();
        if (this.listeCouchesRecherche != null) {
            LocalisationInfo.ecrireLogDebug("Nb couche label " + this.listeCouchesRecherche.size());
            int i = 0;
            while (i < this.listeCouchesRecherche.size()) {
                int[] numEnrs;
                CoucheLabel coucheLabel = (CoucheLabel)this.listeCouchesRecherche.get(i);
                ICouche couche = this.cartes.getCouche(coucheLabel.getCouche());
                if (couche != null && couche.isVisible() && !GLS.estVide(numEnrs = couche.getCont().getAllNumEntXYPlusProche((float)point.getX(), (float)point.getY(), (double)DISTANCE_ACCROCHE))) {
                    int[] nArray = numEnrs;
                    int n = numEnrs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int numEnr = nArray[n2];
                        Enregistrement objetTrouve = null;
                        if (numEnr >= 0 && numEnr < couche.getDon().getNbval()) {
                            objetTrouve = couche.getDon().getEnreg(numEnr);
                        }
                        if (objetTrouve != null) {
                            Vector labelsTmp = new Vector();
                            Vector imagesTmp = new Vector();
                            Vector listeLabel = coucheLabel.getLabels(objetTrouve);
                            labelsTmp = (Vector)listeLabel.get(0);
                            imagesTmp = (Vector)listeLabel.get(1);
                            if (labelsTmp.size() != 0) {
                                int l = labelsTmp.size() - 1;
                                while (l >= 0) {
                                    String nomLabel = (String)labelsTmp.get(l);
                                    String imageLabel = (String)imagesTmp.get(l);
                                    if (!ConstantesGLS.estVide(nomLabel) && !this.estDejaPresent(nomLabel, imageLabel, labels)) {
                                        labels.add(new InfoBulle.LabelChamps(nomLabel, imageLabel));
                                    }
                                    --l;
                                }
                            }
                        }
                        ++n2;
                    }
                }
                ++i;
            }
        }
        return labels;
    }

    public class CoucheLabel {
        private String couche;
        private int[] indices;
        private String[] libelles;
        private String[] images;
        private boolean multiLabel;

        public CoucheLabel(ICouche calque) {
            if (calque != null && calque.getDon().getNbvar() > 0) {
                this.couche = calque.getNom();
                this.indices = new int[1];
                this.libelles = new String[]{String.valueOf(calque.getNom()) + " : "};
                this.images = new String[]{""};
                this.multiLabel = false;
            }
        }

        public CoucheLabel(String couche, int[] indices, String[] libelles, String[] images, boolean multiLabel) {
            this.couche = couche;
            this.indices = indices;
            this.libelles = libelles;
            this.images = images;
            this.multiLabel = multiLabel;
        }

        public CoucheLabel(String couche, int[] indices, String[] libelles, String[] images) {
            this.couche = couche;
            this.indices = indices;
            this.libelles = libelles;
            this.images = images;
            this.multiLabel = indices.length > 1;
        }

        public int[] getIndices() {
            return this.indices;
        }

        public String[] getLibelles() {
            return this.libelles;
        }

        public String getCouche() {
            return this.couche;
        }

        public Vector getLabels(Enregistrement enregistrement) {
            String label = "";
            Vector labels = new Vector();
            Vector<String> listeLabel = new Vector<String>();
            Vector<String> listeImage = new Vector<String>();
            if (this.multiLabel) {
                int i = 0;
                while (i < this.indices.length) {
                    label = enregistrement.getValeur(this.indices[i]).trim();
                    if (!ConstantesGLS.estVide(label)) {
                        label = String.valueOf(this.libelles[i]) + label;
                        listeLabel.add(label);
                        listeImage.add(this.images[i]);
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.indices.length) {
                    String tmpLabel = enregistrement.getValeur(this.indices[i]).trim();
                    if (!ConstantesGLS.estVide(tmpLabel)) {
                        label = String.valueOf(label) + this.libelles[i] + tmpLabel;
                    }
                    ++i;
                }
                listeLabel.add(label);
                listeImage.add(this.images[0]);
            }
            labels.add(listeLabel);
            labels.add(listeImage);
            return labels;
        }
    }
}

