/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui;

import cartoj.CartesG2;
import gls.geometry.GeoPoint;
import gls.localisation.LocalisationInfo;
import gls.outils.ConstantesGLS;
import gls.outils.MyCollator;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.Timer;

public abstract class InfoBulle
implements MouseMotionListener,
MouseListener,
ActionListener {
    private boolean enCours;
    public static int DISTANCE_ACCROCHE = 30;
    public static int TEMPS_ATTENTE = 2000;
    public static int TEMPS_VERIFICATION = 2000;
    private Timer timerAttente;
    private boolean enTrainDeBouger;
    protected CartesG2 cartes;
    private Point2D.Double position;

    public InfoBulle(CartesG2 cartes) {
        this.cartes = cartes;
        this.timerAttente = new Timer(TEMPS_ATTENTE, this);
        this.enTrainDeBouger = false;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.enCours) {
            this.timerAttente.restart();
            this.enTrainDeBouger = true;
            this.position = new Point2D.Double(e.getX(), e.getY());
            this.cartes.redessineCarte();
        }
    }

    public abstract Vector<LabelChamps> getLabels(GeoPoint var1);

    @Override
    public void actionPerformed(ActionEvent arg) {
        if (this.cartes.estActive()) {
            LocalisationInfo.ecrireLogDebug("Recherche des labels");
            this.timerAttente.stop();
            this.enCours = true;
            GeoPoint point = new GeoPoint((float)(this.position.x / this.cartes.getEchelle() + this.cartes.getOrigine().x), (float)(this.position.y / -this.cartes.getEchelle() + this.cartes.getOrigine().y));
            Vector<LabelChamps> labels = this.getLabels(point);
            if (labels.size() != 0) {
                this.dessiner(labels, (int)this.position.x + 8, (int)this.position.y - 8);
            }
            this.enCours = false;
        }
    }

    protected boolean estDejaPresent(String label, String image, Vector<LabelChamps> listeLabel) {
        int size = listeLabel.size();
        int i = 0;
        while (i < size) {
            if (label.equals(listeLabel.get(i).getValeur()) && image.equals(listeLabel.get(i).getCheminImage())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void dessiner(LabelChamps label, int posX, int posY) {
        Graphics g = this.cartes.getGraphics();
        g.setFont(InfoBulle.getSerpeFont(14, true));
        int l = g.getFontMetrics().stringWidth(label.getValeur());
        int h = g.getFontMetrics().getHeight();
        g.setColor(Color.white);
        g.fillRect(posX, posY - h, l, h);
        g.setColor(Color.black);
        g.drawString(label.getValeur(), posX, posY);
    }

    public void dessiner(Vector<LabelChamps> labels, int posX, int posY) {
        Graphics g = this.cartes.getGraphics();
        int lMax = -1;
        int hMax = -1;
        int size = labels.size();
        int i = 0;
        while (i < size) {
            LabelChamps labelChamp = labels.get(i);
            String label = labelChamp.getValeur();
            g.setFont(ConstantesGLS.getFont("Arial", 12, false));
            int l = g.getFontMetrics(g.getFont()).stringWidth(label) + 24;
            int h = g.getFontMetrics().getHeight();
            if (labelChamp.aImage()) {
                l += labelChamp.getImage().getIconWidth() * hMax / labelChamp.getImage().getIconHeight() + 2;
            }
            if (l > lMax) {
                lMax = l;
            }
            if (h > hMax) {
                hMax = h;
            }
            ++i;
        }
        Rectangle rect = this.cartes.getBounds();
        int hauteur = (hMax += 5) * size;
        int largeur = lMax;
        if (posX + largeur > rect.width) {
            posX -= largeur;
        }
        if (posY - hauteur < 0) {
            posY += hauteur;
        }
        g.setColor(Color.black);
        g.fillRect(posX - 1, posY - 1 - size * hMax, lMax + 2, size * hMax + 2);
        int i2 = 0;
        while (i2 < size) {
            LabelChamps labelChamp = labels.get(i2);
            String label = labelChamp.getValeur();
            g.setFont(ConstantesGLS.getFont("Arial", 12, false));
            g.setColor(Color.white);
            g.fillRect(posX, posY - (i2 + 1) * hMax, lMax, hMax);
            g.setColor(Color.black);
            if (labelChamp.aImage()) {
                ImageIcon img = labelChamp.getImage();
                int largeurIcone = img.getIconWidth() * hMax / img.getIconHeight();
                g.drawString(label, posX + largeurIcone + 2, posY - 2 - i2 * hMax);
                g.drawImage(img.getImage(), posX, posY - (i2 + 1) * hMax, largeurIcone, hMax, img.getImageObserver());
            } else {
                g.drawString(label, posX, posY - 2 - i2 * hMax);
            }
            ++i2;
        }
    }

    public static final Font getSerpeFont(int _taille, boolean _gras) {
        return new Font("BankGothic Md BT", _gras ? 1 : 0, _taille);
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
    }

    public class LabelChamps {
        private String valeur;
        private ImageIcon image;
        private String cheminImage;

        public LabelChamps(String valeur, String image) {
            this.valeur = valeur;
            this.cheminImage = image;
            if (!ConstantesGLS.estVide(image)) {
                this.image = new ImageIcon(image);
            } else {
                image = null;
            }
        }

        public LabelChamps(String valeur) {
            this.valeur = valeur;
            this.image = null;
            this.cheminImage = "";
        }

        public boolean estVide() {
            return ConstantesGLS.estVide(this.valeur);
        }

        public boolean aImage() {
            return this.image != null;
        }

        public String getValeur() {
            return this.valeur;
        }

        public void setValeur(String valeur) {
            String[] newValeur = new String[]{valeur};
            Arrays.sort(newValeur, new MyCollator());
            this.valeur = newValeur[0];
        }

        public ImageIcon getImage() {
            return this.image;
        }

        public void setImage(ImageIcon image) {
            this.image = image;
        }

        public String getCheminImage() {
            return this.cheminImage;
        }

        public void setCheminImage(String cheminImage) {
            this.cheminImage = cheminImage;
        }
    }
}

